/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.utils;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.ui.internal.model.DocumentInputStream;
import org.eclipse.tm4e.ui.utils.ClassHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class ContentTypeHelper {
    public static ContentTypeInfo findContentTypes(IDocument document) throws CoreException {
        ContentTypeInfo contentTypes = ContentTypeHelper.findContentTypesFromFileBuffers(document);
        if (contentTypes != null) {
            return contentTypes;
        }
        return ContentTypeHelper.findContentTypesFromEditorInput(document);
    }

    public static IContentType getContentTypeById(String contentTypeId) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        return manager.getContentType(contentTypeId);
    }

    private static ContentTypeInfo findContentTypesFromFileBuffers(IDocument document) throws CoreException {
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = bufferManager.getTextFileBuffer(document);
        if (buffer != null) {
            return ContentTypeHelper.getContentTypes(buffer);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ContentTypeInfo getContentTypes(ITextFileBuffer buffer) throws CoreException {
        try {
            String fileName = buffer.getFileStore().getName();
            if (buffer.isDirty()) {
                DocumentInputStream input;
                block18: {
                    ContentTypeInfo contentTypeInfo;
                    input = null;
                    try {
                        input = new DocumentInputStream(buffer.getDocument());
                        IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor((InputStream)input, fileName);
                        if (contentTypes == null) break block18;
                        contentTypeInfo = new ContentTypeInfo(fileName, contentTypes);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (input == null) throw throwable;
                            input.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (input == null) return contentTypeInfo;
                        input.close();
                        return contentTypeInfo;
                    }
                    catch (IOException iOException) {}
                    return contentTypeInfo;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
            try (InputStream contents = null;){
                contents = ContentTypeHelper.getContents(buffer);
                ContentTypeInfo contentTypeInfo = new ContentTypeInfo(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName));
                return contentTypeInfo;
            }
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    private static InputStream getContents(ITextFileBuffer buffer) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile(buffer.getLocation());
        if (file.exists() && buffer.isSynchronized()) {
            return file.getContents();
        }
        return buffer.getFileStore().openInputStream(0, null);
    }

    /*
     * Loose catch block
     */
    private static ContentTypeInfo findContentTypesFromEditorInput(IDocument document) {
        IEditorInput editorInput = ContentTypeHelper.getEditorInput(document);
        if (editorInput != null && editorInput instanceof IStorageEditorInput) {
            InputStream input = null;
            IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
            String fileName = storage.getName();
            input = storage.getContents();
            ContentTypeInfo contentTypeInfo = new ContentTypeInfo(fileName, Platform.getContentTypeManager().findContentTypesFor(input, fileName));
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            return contentTypeInfo;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    private static IEditorInput getEditorInput(IDocument document) {
        block6: {
            try {
                ListenerList listeners = (ListenerList)ClassHelper.getFieldValue(document, "fDocumentListeners");
                if (listeners == null) break block6;
                Object[] l = listeners.getListeners();
                int i = 0;
                while (i < l.length) {
                    Object info = l[i];
                    try {
                        Object input = ClassHelper.getFieldValue(info, "fElement");
                        if (input instanceof IEditorInput) {
                            return (IEditorInput)input;
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

