/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.parsers.preprocess.PreprocessorDirective;
import org.eclipse.titan.designer.parsers.ttcn3parser.ConditionalState;
import org.eclipse.titan.designer.parsers.ttcn3parser.ConditionalTransition;

class ConditionalStateMachine {
    PreprocessorDirective beginDirective;
    ConditionalState state;
    boolean prevCond;
    boolean actCond;

    public ConditionalStateMachine(PreprocessorDirective beginDirective) {
        this.beginDirective = beginDirective;
        this.state = ConditionalState.BEGIN;
        this.prevCond = false;
        this.actCond = beginDirective.type == PreprocessorDirective.Directive_type.IFNDEF ? !beginDirective.condition : beginDirective.condition;
    }

    public void transition(PreprocessorDirective ppDirective, List<TITANMarker> errors) {
        boolean newCond;
        ConditionalTransition transition;
        switch (ppDirective.type) {
            case ELIF: {
                transition = ConditionalTransition.ELIF;
                newCond = ppDirective.condition;
                break;
            }
            case ELSE: {
                transition = ConditionalTransition.ELSE;
                newCond = true;
                break;
            }
            case ENDIF: {
                transition = ConditionalTransition.ENDIF;
                newCond = true;
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
                return;
            }
        }
        ConditionalState newState = this.state.transition(transition);
        if (newState == null) {
            TITANMarker marker = new TITANMarker(MessageFormat.format("Directive {0} after {1} is not a valid preprocessor conditional", ppDirective.type.getName(), this.state.getName()), ppDirective.line, -1, -1, 2, 1);
            errors.add(marker);
            return;
        }
        this.state = newState;
        if (this.actCond) {
            this.prevCond = true;
        }
        this.actCond = newCond;
    }

    public boolean isPassing() {
        return this.actCond && !this.prevCond;
    }

    public boolean hasEnded() {
        return this.state == ConditionalState.END;
    }
}

