/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;

public class FoldingSupport {
    protected int foldingDistance;
    protected List<Position> positions = new ArrayList<Position>();
    protected IPreferencesService preferencesService;
    protected String documentText;
    protected int lastLineIndex;

    public List<Position> calculatePositions(IDocument document) {
        this.positions.clear();
        this.lastLineIndex = document.getNumberOfLines();
        this.documentText = document.get();
        this.preferencesService = Platform.getPreferencesService();
        this.foldingDistance = this.preferencesService.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.distance", 0, null);
        if (this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldingEnabledPreference", true, null)) {
            Interval interval = GlobalIntervalHandler.getInterval(document);
            if (interval == null) {
                return this.positions;
            }
            for (Interval subintervall : interval.getSubIntervals()) {
                this.recursiveTokens(subintervall);
            }
        }
        return this.positions;
    }

    protected void recursiveTokens(Interval interval) {
        int distance;
        int endOffset = interval.getEndOffset();
        if (this.documentText.length() <= endOffset || this.documentText.length() <= interval.getStartOffset()) {
            return;
        }
        if (endOffset == -1) {
            endOffset = this.documentText.length() - 1;
        }
        if (endOffset <= interval.getStartOffset()) {
            ErrorReporter.INTERNAL_ERROR();
            return;
        }
        int endline = interval.getEndLine();
        if (endline > this.lastLineIndex) {
            return;
        }
        if (endline == -1) {
            endline = this.lastLineIndex;
        }
        if ((distance = endline - interval.getStartLine()) >= this.foldingDistance) {
            switch (this.documentText.charAt(interval.getStartOffset())) {
                case '{': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldStatementBlocks", true, null)) break;
                    this.positions.add(new Position(interval.getStartOffset(), endOffset - interval.getStartOffset()));
                    break;
                }
                case '(': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldParenthesis", true, null)) break;
                    this.positions.add(new Position(interval.getStartOffset(), endOffset - interval.getStartOffset()));
                    break;
                }
                case '#': 
                case '/': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldComments", true, null)) break;
                    this.positions.add(new Position(interval.getStartOffset(), endOffset - interval.getStartOffset()));
                    break;
                }
            }
        }
        for (Interval subIntervall : interval.getSubIntervals()) {
            this.recursiveTokens(subIntervall);
        }
    }

    public static synchronized void updateFoldingStructure(ProjectionAnnotationModel annotationModel, List<Annotation> oldAnnotations, List<Position> newPositions) {
        if (oldAnnotations == null || annotationModel == null) {
            return;
        }
        Annotation[] deletedAnnotations = null;
        if (!oldAnnotations.isEmpty()) {
            deletedAnnotations = new Annotation[oldAnnotations.size()];
            int deletedIndex = 0;
            for (int i = oldAnnotations.size() - 1; i >= 0; --i) {
                Position pos = annotationModel.getPosition(oldAnnotations.get(i));
                int foundIndex = -1;
                if (pos != null) {
                    for (int j = newPositions.size() - 1; j >= 0; --j) {
                        if (pos.offset != newPositions.get((int)j).offset) continue;
                        foundIndex = j;
                        break;
                    }
                }
                if (foundIndex >= 0) {
                    newPositions.remove(foundIndex);
                    continue;
                }
                deletedAnnotations[deletedIndex++] = oldAnnotations.remove(i);
            }
        }
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        ArrayList<ProjectionAnnotation> newAnnotations2 = new ArrayList<ProjectionAnnotation>(newAnnotations.size());
        for (int i = 0; i < newPositions.size(); ++i) {
            Position position = newPositions.get(i);
            if (position == null) continue;
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, position);
            newAnnotations2.add(annotation);
        }
        try {
            annotationModel.modifyAnnotations(deletedAnnotations, newAnnotations, null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        oldAnnotations.addAll(newAnnotations2);
    }
}

