/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.IndexedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Indexed_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.SequenceOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SetOf_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Array_Type
extends Type
implements IReferenceableElement {
    private static final String ARRAYVALUEEXPECTED = "Array value was expected";
    private static final String TOOMANYEXPECTED = "Too many elements in the array value: {0} was expected instead of {1}";
    private static final String TOOFEWEXPECTED = "Too few elements in the array value: {0} was expected instead of {1}";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `{1}''";
    private static final String REDUNDANTLENGTHRESTRICTION = "Redundant usage of length restriction with `omit''";
    private static final String TOOMANYTEMPLATEELEMENTS = "Too many elements in the array template: {0} was expected instead of {1}";
    private static final String TOOFEWTEMPLATEELEMENTS = "Too few elements in the array template: {0} was expected instead of {1}";
    private static final String NOTUSEDNOTALLOWED = "Not used symbol `-'' is not allowed in this context";
    private static final String FULLNAMEPART1 = ".<elementType>";
    private static final String FULLNAMEPART2 = ".<dimension>";
    private static final String BADARRAYDIMENSION = "Array types should have the same dimension";
    private static final String NOFFIELDSDONTMATCH = "The size of the array ({0}) must be >= than the number of mandatory fields in the record/SEQUENCE type ({1})";
    private static final String NOTCOMPATIBLESETSETOF = "set/SET and set of/SET OF types are compatible only with other set/SET and set of/SET OF types";
    private static final String NOTCOMPATIBLEUNIONANYTYPE = "union/CHOICE/anytype types are compatible only with other union/CHOICE/anytype types";
    private final Type elementType;
    private final ArrayDimension dimension;
    private final boolean inTypeDefinition;
    private boolean componentInternal;
    private BuildTimestamp lastBuildTimestamp;
    private String lastGenName;
    private boolean insideCanHaveCoding = false;

    public Array_Type(Type elementType, ArrayDimension dimension, boolean inTypeDefinition) {
        this.elementType = elementType;
        this.dimension = dimension;
        this.inTypeDefinition = inTypeDefinition;
        this.componentInternal = false;
        if (elementType != null) {
            elementType.setOwnertype(IType.TypeOwner_type.OT_ARRAY, this);
            elementType.setFullNameParent(this);
        }
        if (dimension != null) {
            dimension.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ARRAY;
    }

    public ArrayDimension getDimension() {
        return this.dimension;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.elementType == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.dimension == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.elementType != null) {
            this.elementType.setMyScope(scope);
        }
        if (this.dimension != null) {
            this.dimension.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type tempType = (ASN1_Sequence_Type)temp;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                int nofOptionalFields = 0;
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    if (!tempTypeCf.isOptional()) continue;
                    ++nofOptionalFields;
                }
                long nofComps = this.getDimension().getSize();
                if (nofComps < (long)tempTypeNofComps - nofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDONTMATCH, nofComps, tempTypeNofComps - nofOptionalFields));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(tempElementType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeCfType, false);
                    if (!(tempElementType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type tempType = (TTCN3_Sequence_Type)temp;
                int tempTypeNofComps = tempType.getNofComponents();
                if (tempTypeNofComps == 0) {
                    return false;
                }
                int nofOptionalFields = 0;
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    if (!tempTypeCf.isOptional()) continue;
                    ++nofOptionalFields;
                }
                long nofComps = this.getDimension().getSize();
                if (nofComps < (long)tempTypeNofComps - nofComps) {
                    info.setErrorStr(MessageFormat.format(NOFFIELDSDONTMATCH, nofComps, tempTypeNofComps - nofOptionalFields));
                    return false;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < tempTypeNofComps; ++i) {
                    CompField tempTypeCf = tempType.getComponentByIndex(i);
                    IType tempTypeCfType = tempTypeCf.getType().getTypeRefdLast(timestamp);
                    IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                    lChain.markState();
                    rChain.markState();
                    lChain.add(tempElementType);
                    rChain.add(tempTypeCfType);
                    TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeCfType, false);
                    if (!(tempElementType.equals(tempTypeCfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeCfType, infoTemp, lChain, rChain))) {
                        info.appendOp1Ref(infoTemp.getOp1RefStr());
                        info.appendOp2Ref("." + tempTypeCf.getIdentifier().getDisplayName() + infoTemp.getOp2RefStr());
                        info.setOp1Type(infoTemp.getOp1Type());
                        info.setOp2Type(infoTemp.getOp2Type());
                        info.setErrorStr(infoTemp.getErrorStr());
                        lChain.previousState();
                        rChain.previousState();
                        return false;
                    }
                    lChain.previousState();
                    rChain.previousState();
                }
                info.setNeedsConversion(true);
                return true;
            }
            case TYPE_SEQUENCE_OF: {
                SequenceOf_Type tempType = (SequenceOf_Type)temp;
                if (!tempType.isSubtypeCompatible(timestamp, this)) {
                    info.setErrorStr("Incompatible record of/SEQUENCE OF subtypes");
                    return false;
                }
                IType tempTypeOfType = tempType.getOfType().getTypeRefdLast(timestamp);
                IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(tempElementType);
                rChain.add(tempTypeOfType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeOfType, false);
                if (!(tempElementType.equals(tempTypeOfType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeOfType, infoTemp, lChain, rChain))) {
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    if (infoTemp.getOp2RefStr().length() > 0) {
                        info.appendOp2Ref("[]");
                    }
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ARRAY: {
                Array_Type tempType = (Array_Type)temp;
                if (this == tempType) {
                    return true;
                }
                if (this.dimension != null && tempType.dimension != null && !this.dimension.isIdentical(timestamp, tempType.dimension)) {
                    info.setErrorStr(BADARRAYDIMENSION);
                    return false;
                }
                IType tempElementType = this.getElementType().getTypeRefdLast(timestamp);
                IType tempTypeElementType = tempType.getElementType().getTypeRefdLast(timestamp);
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                lChain.markState();
                rChain.markState();
                lChain.add(tempElementType);
                rChain.add(tempTypeElementType);
                TypeCompatibilityInfo infoTemp = new TypeCompatibilityInfo(tempElementType, tempTypeElementType, false);
                if (!(tempElementType.equals(tempTypeElementType) || lChain.hasRecursion() && rChain.hasRecursion() || tempElementType.isCompatible(timestamp, tempTypeElementType, infoTemp, lChain, rChain))) {
                    info.appendOp1Ref(infoTemp.getOp1RefStr());
                    info.appendOp2Ref(infoTemp.getOp2RefStr());
                    info.setOp1Type(infoTemp.getOp1Type());
                    info.setOp2Type(infoTemp.getOp2Type());
                    info.setErrorStr(infoTemp.getErrorStr());
                    lChain.previousState();
                    rChain.previousState();
                    return false;
                }
                info.setNeedsConversion(true);
                lChain.previousState();
                rChain.previousState();
                return true;
            }
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: 
            case TYPE_ANYTYPE: {
                info.setErrorStr(NOTCOMPATIBLEUNIONANYTYPE);
                return false;
            }
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: {
                info.setErrorStr(NOTCOMPATIBLESETSETOF);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        if (!IType.Type_type.TYPE_ARRAY.equals((Object)temp.getTypetype())) {
            return false;
        }
        Array_Type other = (Array_Type)temp;
        boolean result = this.elementType != null && other.elementType != null && this.elementType.isIdentical(timestamp, other.elementType);
        return result && this.dimension != null && other.dimension != null && this.dimension.isIdentical(timestamp, other.dimension);
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.elementType != null && referenceChain.add(this)) {
            referenceChain.markState();
            this.elementType.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.initAttributes(timestamp);
        if (this.elementType != null) {
            this.elementType.setGenName(this.getGenNameOwn(), "0");
            this.elementType.setParentType(this);
            this.elementType.check(timestamp);
            this.elementType.checkEmbedded(timestamp, this.elementType.getLocation(), true, "embedded into an array type");
            this.componentInternal = this.elementType.isComponentInternal(timestamp);
        }
        if (this.dimension != null) {
            this.dimension.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (typeSet.contains(this)) {
            return;
        }
        if (this.elementType != null && this.elementType.isComponentInternal(timestamp)) {
            typeSet.add(this);
            this.elementType.checkComponentInternal(timestamp, typeSet, operation);
            typeSet.remove(this);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCEOF_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.ARRAY_VALUE);
                selfReference = this.checkThisValueArray(timestamp, value, lhs, (Array_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case ARRAY_VALUE: {
                selfReference = this.checkThisValueArray(timestamp, value, lhs, (Array_Value)last, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(ARRAYVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueArray(CompilationTimeStamp timestamp, IValue originalValue, Assignment lhs, Array_Value lastValue, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean implicitOmit, boolean strElem) {
        if (this.dimension == null) {
            return false;
        }
        boolean selfReference = false;
        int nofValues = lastValue.getNofComponents();
        if (!this.dimension.getIsErroneous(timestamp) && this.dimension.getSize() < (long)nofValues) {
            originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOMANYEXPECTED, this.dimension.getSize(), nofValues));
            originalValue.setIsErroneous(true);
        }
        if (lastValue.isIndexed()) {
            boolean checkHoles = !this.dimension.getIsErroneous(timestamp) && Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue);
            long arraySize = this.dimension.getSize();
            BigInteger maxIndex = BigInteger.valueOf(-1L);
            HashMap<BigInteger, Integer> indexMap = new HashMap<BigInteger, Integer>(lastValue.getNofComponents());
            int size = lastValue.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = lastValue.getValueByIndex(i);
                Value index = lastValue.getIndexByIndex(i);
                this.dimension.checkIndex(timestamp, index, expectedValue);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                IValue indexLast = index.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (indexLast.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)indexLast.getValuetype())) {
                    checkHoles = false;
                } else {
                    BigInteger tempIndex = ((Integer_Value)indexLast).getValueValue();
                    if (tempIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (tempIndex.compareTo(BigInteger.ZERO) == -1) {
                        index.getLocation().reportSemanticError(MessageFormat.format("A non-negative integer value was expected for indexing type `{0}'' instead of `{1}''", this.getTypename(), tempIndex));
                        checkHoles = false;
                    } else if (indexMap.containsKey(tempIndex)) {
                        index.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for components {1} and {2}", tempIndex, indexMap.get(tempIndex), i + 1));
                        checkHoles = false;
                    } else {
                        indexMap.put(tempIndex, i + 1);
                        if (maxIndex.compareTo(tempIndex) == -1) {
                            maxIndex = tempIndex;
                        }
                    }
                }
                component.setMyGovernor(this.elementType);
                IValue tempValue2 = this.elementType.checkThisValueRef(timestamp, component);
                selfReference |= this.elementType.checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
            if (checkHoles && (long)indexMap.size() < arraySize) {
                lastValue.getLocation().reportSemanticError("It's not allowed to create hole(s) in constant values");
                originalValue.setIsErroneous(true);
            }
        } else {
            if (!this.dimension.getIsErroneous(timestamp)) {
                long arraySize = this.dimension.getSize();
                if (arraySize > (long)nofValues) {
                    originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOFEWEXPECTED, arraySize, nofValues));
                    originalValue.setIsErroneous(true);
                } else if (arraySize < (long)nofValues) {
                    originalValue.getLocation().reportSemanticError(MessageFormat.format(TOOMANYEXPECTED, arraySize, nofValues));
                    originalValue.setIsErroneous(true);
                }
            }
            int size = lastValue.getNofComponents();
            for (int i = 0; i < size; ++i) {
                IValue component = lastValue.getValueByIndex(i);
                component.setMyGovernor(this.elementType);
                if (IValue.Value_type.NOTUSED_VALUE.equals((Object)component.getValuetype())) {
                    if (incompleteAllowed) continue;
                    component.getLocation().reportSemanticError("Not used symbol `-' is not allowed in this context");
                    continue;
                }
                IValue tempValue2 = this.elementType.checkThisValueRef(timestamp, component);
                selfReference |= this.elementType.checkThisValue(timestamp, tempValue2, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, implicitOmit, strElem));
            }
        }
        return selfReference;
    }

    public IType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        boolean selfReference = false;
        switch (template.getTemplatetype()) {
            case OMIT_VALUE: {
                if (template.getLengthRestriction() == null) break;
                template.getLocation().reportSemanticWarning(REDUNDANTLENGTHRESTRICTION);
                break;
            }
            case PERMUTATION_MATCH: {
                int nofComponents = ((PermutationMatch_Template)template).getNofTemplates();
                for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = ((PermutationMatch_Template)template).getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.elementType);
                    templateComponent = this.elementType.checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.elementType, isModified, false, true, true, false, lhs);
                }
                break;
            }
            case TEMPLATE_LIST: {
                Template_List listTemplate = (Template_List)template;
                ITTCN3Template baseTemplate = listTemplate.getBaseTemplate();
                int nofBaseComponents = 0;
                if (baseTemplate != null) {
                    if (ITTCN3Template.Template_type.TEMPLATE_LIST.equals((Object)(baseTemplate = baseTemplate.getTemplateReferencedLast(timestamp, null)).getTemplatetype())) {
                        nofBaseComponents = ((Template_List)baseTemplate).getNofTemplates();
                    } else {
                        baseTemplate = null;
                    }
                }
                if (!this.dimension.getIsErroneous(timestamp)) {
                    long arraySize = this.dimension.getSize();
                    int nofComponents = listTemplate.getNofTemplates();
                    boolean fixedSize = true;
                    int templateSize = 0;
                    block14: for (int i = 0; i < nofComponents && fixedSize; ++i) {
                        TTCN3Template templateComponent = listTemplate.getTemplateByIndex(i);
                        switch (templateComponent.getTemplatetype()) {
                            case PERMUTATION_MATCH: {
                                PermutationMatch_Template permutationTemplate = (PermutationMatch_Template)templateComponent;
                                if (permutationTemplate.containsAnyornoneOrPermutation(timestamp)) {
                                    fixedSize = false;
                                    continue block14;
                                }
                                templateSize += permutationTemplate.getNofTemplatesNotAnyornone(timestamp);
                                continue block14;
                            }
                            default: {
                                ++templateSize;
                            }
                        }
                    }
                    if (fixedSize) {
                        if (arraySize < (long)templateSize) {
                            listTemplate.getLocation().reportSemanticError(MessageFormat.format(TOOMANYTEMPLATEELEMENTS, arraySize, templateSize));
                        } else if (arraySize > (long)templateSize) {
                            listTemplate.getLocation().reportSemanticError(MessageFormat.format(TOOFEWTEMPLATEELEMENTS, arraySize, templateSize));
                        }
                    }
                }
                int nofComponents = ((Template_List)template).getNofTemplates();
                block15: for (int i = 0; i < nofComponents; ++i) {
                    ITTCN3Template templateComponent = listTemplate.getTemplateByIndex(i);
                    templateComponent.setMyGovernor(this.elementType);
                    if (baseTemplate != null && i < nofBaseComponents) {
                        templateComponent.setBaseTemplate(((Template_List)baseTemplate).getTemplateByIndex(i));
                    }
                    templateComponent = this.elementType.checkThisTemplateRef(timestamp, templateComponent);
                    switch (templateComponent.getTemplatetype()) {
                        case PERMUTATION_MATCH: {
                            selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this, isModified, false, true, true, implicitOmit, lhs);
                            continue block15;
                        }
                        case TEMPLATE_NOTUSED: {
                            if (isModified) continue block15;
                            templateComponent.getLocation().reportSemanticWarning(NOTUSEDNOTALLOWED);
                            continue block15;
                        }
                        default: {
                            selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.elementType, isModified, false, true, true, implicitOmit, lhs);
                        }
                    }
                }
                break;
            }
            case INDEXED_TEMPLATE_LIST: {
                HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
                Indexed_Template_List indexedTemplateList = (Indexed_Template_List)template;
                for (int i = 0; i < indexedTemplateList.getNofTemplates(); ++i) {
                    IndexedTemplate indexedTemplate = indexedTemplateList.getIndexedTemplateByIndex(i);
                    Value indexValue = indexedTemplate.getIndex().getValue();
                    this.dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                    ITTCN3Template templateComponent = indexedTemplate.getTemplate();
                    ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IValue lastValue = indexValue.getValueRefdLast(timestamp, chain);
                    chain.release();
                    if (IValue.Value_type.INTEGER_VALUE.equals((Object)lastValue.getValuetype())) {
                        long index = ((Integer_Value)lastValue).getValue();
                        if (index > Integer.MAX_VALUE) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("An integer value less than `{0}'' was expected for indexing type `{1}'' instead of `{2}''", Integer.MAX_VALUE, this.getTypename(), index));
                            indexValue.setIsErroneous(true);
                        } else if (indexMap.containsKey(index)) {
                            indexValue.getLocation().reportSemanticError(MessageFormat.format("Duplicate index value `{0}'' for component `{1}'' and `{2}''", index, i + 1, indexMap.get(index)));
                            indexValue.setIsErroneous(true);
                        } else {
                            indexMap.put(index, i);
                        }
                    }
                    templateComponent.setMyGovernor(this.elementType);
                    templateComponent = this.elementType.checkThisTemplateRef(timestamp, templateComponent);
                    selfReference |= templateComponent.checkThisTemplateGeneric(timestamp, this.elementType, isModified, false, true, true, implicitOmit, lhs);
                }
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
            }
        }
        return selfReference;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (this.insideCanHaveCoding) {
            this.insideCanHaveCoding = false;
            return true;
        }
        this.insideCanHaveCoding = true;
        if (coding != IType.MessageEncoding_type.JSON) {
            this.insideCanHaveCoding = false;
            return false;
        }
        boolean result = this.elementType.getTypeRefdLast(timestamp).canHaveCoding(timestamp, coding);
        this.insideCanHaveCoding = false;
        return result;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
        this.elementType.getTypeRefdLast(timestamp).setGenerateCoderFunctions(timestamp, encodingType);
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        this.elementType.checkCodingAttributes(timestamp, refChain);
        refChain.previousState();
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        this.elementType.forceJson(timestamp);
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_SET: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
        this.elementType.getTypesWithNoCodingTable(timestamp, typeList, onlyOwnTable);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || this.elementType == null || this == this.elementType) {
            return "Erroneous type";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.dimension.createStringRepresentation());
        Type temp = this.elementType;
        while (temp != null && IType.Type_type.TYPE_ARRAY.equals((Object)temp.getTypetype())) {
            Array_Type tempArray = (Array_Type)temp;
            builder.append(tempArray.dimension.createStringRepresentation());
            temp = tempArray.elementType;
        }
        if (temp != null) {
            builder.insert(0, temp.getTypename());
        }
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "array.gif";
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                Value indexValue = ((ArraySubReference)subreference).getValue();
                indexValue.setLoweridToReference(timestamp);
                IType indexingType = indexValue.getExpressionGovernor(timestamp, expectedIndex);
                if (indexingType == null) {
                    return null;
                }
                if ((indexingType = indexingType.getTypeRefdLast(timestamp)) != null && (indexingType.getTypetype() == IType.Type_type.TYPE_ARRAY || indexingType.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF)) {
                    long length = 0L;
                    if (indexingType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                        Array_Type indexingArray = (Array_Type)indexingType;
                        if (indexingArray.getElementType().getTypetype() != IType.Type_type.TYPE_INTEGER) {
                            subreference.getLocation().reportSemanticError("Only fixed length array or record of integer types are allowed for short-hand notation for nested indexes.");
                            return null;
                        }
                        length = indexingArray.getDimension().getSize();
                    } else if (indexingType.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF) {
                        SequenceOf_Type indexingSequenceOf = (SequenceOf_Type)indexingType;
                        if (indexingSequenceOf.getOfType().getTypetype() != IType.Type_type.TYPE_INTEGER) {
                            subreference.getLocation().reportSemanticError("Only fixed length array or record of integer types are allowed for short-hand notation for nested indexes.");
                            return null;
                        }
                        SubType subType = indexingSequenceOf.getSubtype();
                        if (subType == null) {
                            subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' must have single size length restriction when used as a short-hand notation for nested indexes.", indexingSequenceOf.getTypename()));
                            return null;
                        }
                        length = subType.get_length_restriction();
                        if (length == -1L) {
                            subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' must have single size length restriction when used as a short-hand notation for nested indexes.", indexingSequenceOf.getTypename()));
                            return null;
                        }
                    }
                    IType embeddedType = this.elementType.getTypeRefdLast(timestamp);
                    int j = 0;
                    while ((long)j < length - 1L) {
                        switch (embeddedType.getTypetype()) {
                            case TYPE_ARRAY: {
                                embeddedType = ((Array_Type)embeddedType).getElementType();
                                break;
                            }
                            case TYPE_SEQUENCE_OF: {
                                embeddedType = ((SequenceOf_Type)embeddedType).getOfType();
                                break;
                            }
                            case TYPE_SET_OF: {
                                embeddedType = ((SetOf_Type)embeddedType).getOfType();
                                break;
                            }
                            default: {
                                subreference.getLocation().reportSemanticError(MessageFormat.format("The type `{0}'' contains too many indexes ({1}) in the short-hand notation for nested indexes.", indexingType.getTypename(), length));
                                return null;
                            }
                        }
                        ++j;
                    }
                    return embeddedType;
                }
                if (this.dimension != null) {
                    this.dimension.checkIndex(timestamp, indexValue, expectedIndex);
                }
                if (this.elementType != null) {
                    return this.elementType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
                }
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        if (this.elementType != null) {
            this.elementType.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        builder.append("array of ");
        if (this.elementType != null) {
            this.elementType.getProposalDescription(builder);
        }
        return builder;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() < i) {
            return;
        }
        if (subreferences.size() == i) {
            ISubReference subreference = subreferences.get(i - 1);
            if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
                String candidate = ((FieldSubReference)subreference).getId().getDisplayName();
                propCollector.addTemplateProposal(candidate, new Template(candidate + "[index]", candidate + " with index", propCollector.getContextIdentifier(), candidate + "[${index}]", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            }
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.elementType != null) {
            this.elementType.addProposal(propCollector, i + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() > i + 1 && this.elementType != null) {
            this.elementType.addDeclaration(declarationCollector, i + 1);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.elementType != null) {
            this.elementType.updateSyntax(reparser, false);
            reparser.updateLocation(this.elementType.getLocation());
        }
        if (this.dimension != null) {
            this.dimension.updateSyntax(reparser, false);
            reparser.updateLocation(this.dimension.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.elementType == null) {
            return;
        }
        this.elementType.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.elementType != null) {
            this.elementType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.dimension != null) {
            this.dimension.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.elementType != null && !this.elementType.accept(v)) {
            return false;
        }
        return this.dimension == null || this.dimension.accept(v);
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        if (this.elementType == null) {
            return null;
        }
        IType refdLastOfType = this.elementType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdLastOfType instanceof IReferenceableElement) {
            return ((IReferenceableElement)((Object)refdLastOfType)).resolveReference(reference, subRefIdx + 1, lastSubreference);
        }
        return null;
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        if (beginIndex >= subreferences.size()) {
            return true;
        }
        ISubReference subReference = subreferences.get(beginIndex);
        if (!(subReference instanceof ArraySubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return true;
        }
        if (this.elementType == null) {
            return true;
        }
        return this.elementType.isPresentAnyvalueEmbeddedField(expression, subreferences, beginIndex + 1);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        if (this.inTypeDefinition) {
            this.lastBuildTimestamp = aData.getBuildTimstamp();
            this.lastGenName = this.getGenNameOwn(aData);
        } else if (this.lastBuildTimestamp == null || this.lastBuildTimestamp.isLess(aData.getBuildTimstamp())) {
            this.lastBuildTimestamp = aData.getBuildTimstamp();
            this.lastGenName = aData.getTemporaryVariableName();
        }
        return this.lastGenName;
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        if (this.inTypeDefinition) {
            this.lastBuildTimestamp = aData.getBuildTimstamp();
            this.lastGenName = this.getGenNameOwn(aData);
        } else if (this.lastBuildTimestamp == null || this.lastBuildTimestamp.isLess(aData.getBuildTimstamp())) {
            this.lastBuildTimestamp = aData.getBuildTimstamp();
            this.lastGenName = aData.getTemporaryVariableName();
        }
        return this.lastGenName + "_template";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.inTypeDefinition) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        if (this.lastBuildTimestamp == null || this.lastBuildTimestamp.isLess(aData.getBuildTimstamp())) {
            this.lastBuildTimestamp = aData.getBuildTimstamp();
            this.lastGenName = aData.getTemporaryVariableName();
        }
        return this.lastGenName + "." + this.lastGenName;
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "_json_";
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.inTypeDefinition;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        this.lastBuildTimestamp = aData.getBuildTimstamp();
        this.lastGenName = aData.getTemporaryVariableName();
        if (!this.inTypeDefinition) {
            this.setGenName(this.lastGenName);
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
            return;
        }
        aData.addBuiltinTypeImport("Base_Template");
        String ownName = this.getGenNameValue(aData, source);
        String valueName = this.dimension.getValueType(aData, source, this.elementType, this.myScope);
        String templateName = this.dimension.getTemplateType(aData, source, this.elementType, this.myScope);
        String elementName = this.elementType.getGenNameValue(aData, source);
        StringBuilder descriptor = new StringBuilder();
        this.generateCodeTypedescriptor(aData, source, descriptor, null);
        this.generateCodeDefaultCoding(aData, source, descriptor);
        this.generateCodeForCodingHandlers(aData, source, descriptor);
        if (!this.elementType.generatesOwnClass(aData, source)) {
            this.elementType.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.elementType.generateCodeDefaultCoding(aData, source, descriptor);
            this.elementType.generateCodeForCodingHandlers(aData, source, descriptor);
        }
        this.elementType.generateCode(aData, source);
        source.append(MessageFormat.format("public static class {0} extends {1} '{' \n", ownName, valueName));
        source.append((CharSequence)descriptor);
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to unbound value.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}() '{'\n", ownName));
        source.append(MessageFormat.format("super({0}.class, {1,number,#},{2,number,#});\n", elementName, this.dimension.getSize(), this.dimension.getOffset()));
        source.append("}\n\n");
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to a given value.\n");
            source.append(" *\n");
            source.append(" * @param otherValue\n");
            source.append(" *                the value to initialize to.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}({0} otherValue) '{'\n", ownName));
        source.append("super(otherValue);\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("protected TTCN_Typedescriptor get_elem_descr() {\n");
        source.append(MessageFormat.format("return {0}_descr_;\n", this.elementType.getGenNameTypeDescriptor(aData, source)));
        source.append("}\n");
        source.append("}\n\n");
        source.append(MessageFormat.format("public static class {0}_template extends {1} '{'\n", ownName, templateName));
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to unbound/uninitialized template.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}_template() '{'\n", ownName));
        source.append(MessageFormat.format("super({0}.class, {0}_template.class, {1,number,#}, {2,number,#});\n", elementName, this.dimension.getSize(), this.dimension.getOffset()));
        source.append("}\n\n");
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to a given template.\n");
            source.append(" *\n");
            source.append(" * @param otherValue\n");
            source.append(" *                the template to initialize to.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}_template({0}_template otherValue) '{'\n", ownName));
        source.append("super(otherValue);\n");
        source.append("}\n\n");
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to a given value.\n");
            source.append(" * Copies all of the fields and the template becomes a specific template.\n");
            source.append(" *\n");
            source.append(" * @param otherValue\n");
            source.append(" *                the value to initialize to.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}_template({0} otherValue) '{'\n", ownName));
        source.append(MessageFormat.format("super({0}_template.class, otherValue);\n", elementName));
        source.append("}\n\n");
        if (aData.isDebug()) {
            source.append("/**\n");
            source.append(" * Initializes to a given template kind.\n");
            source.append(" *\n");
            source.append(" * @param otherValue\n");
            source.append(" *                the template kind to initialize to.\n");
            source.append(" * */\n");
        }
        source.append(MessageFormat.format("public {0}_template(final Base_Template.template_sel otherValue) '{'\n", ownName));
        source.append(MessageFormat.format("super({0}.class, {0}_template.class, otherValue);\n", elementName));
        source.append("}\n\n");
        source.append("@Override\n");
        source.append(MessageFormat.format("public {0} valueof() '{'\n", ownName));
        source.append(MessageFormat.format("return ({0})super.valueof();\n", ownName));
        source.append("}\n");
        source.append("@Override\n");
        source.append("public void set_type(final template_sel templateType, final int length) {\n");
        source.append("clean_up();\n");
        source.append("switch (templateType) {\n");
        source.append("case VALUE_LIST:\n");
        source.append("case COMPLEMENTED_LIST:\n");
        source.append("listSize = length;\n");
        source.append(MessageFormat.format("value_list = new {0}_template[listSize];\n", ownName));
        source.append("for (int i = 0; i < length; ++i) {\n");
        source.append(MessageFormat.format("value_list[i] = new {0}_template();\n", ownName));
        source.append("}\n");
        source.append('\n');
        source.append("break;\n");
        source.append("default:\n");
        source.append("throw new TtcnError(\"Internal error: Setting an invalid type for an array template.\");\n");
        source.append("}\n");
        source.append("set_selection(templateType);\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append(MessageFormat.format("public {0}_template list_item(final int index) '{'\n", ownName));
        source.append(MessageFormat.format("return ({0}_template)super.list_item(index);\n", ownName));
        source.append("}\n");
        source.append("}\n\n");
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    public void generateCodeValue(JavaGenData aData, StringBuilder source) {
        String className = this.getGenNameValue(aData, source);
        this.setGenName(this.lastGenName);
        IType elementType = this.getElementType();
        String ofType = elementType.getGenNameValue(aData, source);
        if (elementType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
            ((Array_Type)elementType).generateCodeValue(aData, source);
        }
        ArrayDimension dim = this.getDimension();
        aData.addBuiltinTypeImport("TitanValue_Array");
        source.append(MessageFormat.format("public static class {0} extends TitanValue_Array<{1}> '{'\n", className, ofType));
        this.generateCodeTypedescriptor(aData, source, source, null);
        this.generateCodeDefaultCoding(aData, source, source);
        source.append(MessageFormat.format("public {0}() '{'\n", className));
        source.append(MessageFormat.format("super({0}.class, {1,number,#} , {2,number,#});\n", ofType, dim.getSize(), dim.getOffset()));
        source.append("}\n");
        source.append(MessageFormat.format("public {0}({0} otherValue) '{'\n", className));
        source.append("super(otherValue);\n");
        source.append("}\n");
        source.append(MessageFormat.format("public {0}(final TitanValue_Array<{1}> otherValue) '{'\n", className, ofType));
        source.append("super(otherValue);\n");
        source.append("}\n");
        source.append("@Override\n");
        source.append("protected TTCN_Typedescriptor get_elem_descr() {\n");
        source.append(MessageFormat.format("return {0}_descr_;\n", elementType.getGenNameTypeDescriptor(aData, source)));
        source.append("}\n");
        this.generateCodeForCodingHandlers(aData, source, source);
        source.append("}\n\n");
    }

    public void generateCodeTemplate(JavaGenData aData, StringBuilder source) {
        String className = this.getGenNameValue(aData, source);
        String classTemplateName = this.getGenNameTemplate(aData, source);
        IType elementType = this.getElementType();
        String ofValueType = elementType.getGenNameValue(aData, source);
        String ofTemplateType = elementType.getGenNameTemplate(aData, source);
        if (elementType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
            ((Array_Type)elementType).generateCodeTemplate(aData, source);
        }
        ArrayDimension dim = this.getDimension();
        aData.addBuiltinTypeImport("TitanTemplate_Array");
        aData.addBuiltinTypeImport("Base_Template.template_sel");
        aData.addBuiltinTypeImport("Optional");
        source.append(MessageFormat.format("public static class {0} extends TitanTemplate_Array<{1}, {2}> '{'\n", classTemplateName, ofValueType, ofTemplateType));
        source.append(MessageFormat.format("public {0}() '{'\n", classTemplateName));
        source.append(MessageFormat.format("super({0}.class, {1}.class, {2,number,#}, {3,number,#});\n", ofValueType, ofTemplateType, dim.getSize(), dim.getOffset()));
        source.append("}\n");
        source.append(MessageFormat.format("public {0}(final Class<{2}> classTemplate, final TitanValue_Array<{1}> otherValue) '{'\n", classTemplateName, ofValueType, ofTemplateType));
        source.append("super(classTemplate, otherValue);\n");
        source.append("}\n");
        source.append(MessageFormat.format("public {0}(final Optional<{1}> otherValue) '{'\n", classTemplateName, className));
        source.append(MessageFormat.format("super({0}.class, {1}.class, {2,number,#}, {3,number,#});\n", ofValueType, ofTemplateType, dim.getSize(), dim.getOffset()));
        source.append("switch (otherValue.get_selection()) {\n");
        source.append("case OPTIONAL_PRESENT:\n");
        source.append("set_selection(template_sel.SPECIFIC_VALUE);\n");
        source.append("copy_value(otherValue.constGet());\n");
        source.append("break;\n");
        source.append("case OPTIONAL_OMIT:\n");
        source.append("set_selection(template_sel.OMIT_VALUE);\n");
        source.append("break;\n");
        source.append("case OPTIONAL_UNBOUND:\n");
        source.append("throw new TtcnError(\"Creating an array template from an unbound optional field.\");\n");
        source.append("}\n");
        source.append("}\n\n");
        source.append("@Override\n");
        source.append(MessageFormat.format("public {0} valueof() '{'\n", className));
        source.append(MessageFormat.format("return ({0})super.valueof();\n", className));
        source.append("}\n");
        source.append("}\n");
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        boolean isLast;
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof ArraySubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        Type nextType = this.elementType;
        Value indexValue = ((ArraySubReference)subReference).getValue();
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = indexValue.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalIndexId = aData.getTemporaryVariableName();
        expression.expression.append(MessageFormat.format("final TitanInteger {0} = ", temporalIndexId));
        last.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(";\n");
        expression.expression.append(MessageFormat.format("{0} = {1}.is_greater_than_or_equal(0) && {1}.is_less_than({2}.{3});\n", globalId, temporalIndexId, externalId, isTemplate ? "n_elem()" : "size_of()"));
        expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
        closingBrackets.insert(0, "}\n");
        String temporalId = aData.getTemporaryVariableName();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet_at({3});\n", nextTypeGenName, temporalId, externalId, temporalIndexId));
        boolean bl = isLast = subReferenceIndex == subreferences.size() - 1;
        if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId));
        } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId));
        } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.{2}({3});\n", globalId, temporalId, !isLast ? "is_bound" : "is_present", isLast && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
        } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
            expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId, field));
                expression.expression.append("}\n");
            }
        }
        nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId, isTemplate, optype, field, targetScope);
        expression.expression.append((CharSequence)closingBrackets);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                TTCN3_Sequence_Type realFromType = (TTCN3_Sequence_Type)refdType;
                return this.generateConversionTTCNSeqToArray(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_ASN1_SEQUENCE: {
                ASN1_Sequence_Type realFromType = (ASN1_Sequence_Type)refdType;
                return this.generateConversionASNSeqToArray(aData, realFromType, fromName, forValue, expression);
            }
            case TYPE_SEQUENCE_OF: {
                IType fromOfType = ((SequenceOf_Type)refdType).getOfType();
                return this.generateConversionSeqOfToArray(aData, (SequenceOf_Type)refdType, fromName, fromOfType, forValue, expression);
            }
            case TYPE_ARRAY: {
                return this.generateConversionArrayToArray(aData, (Array_Type)refdType, fromName, forValue, expression);
            }
        }
        return "FATAL ERROR during converting to type " + this.getTypename();
    }

    private String generateConversionSeqOfToArray(JavaGenData aData, SequenceOf_Type fromType, String fromName, IType fromOfType, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            long to_offset = this.getDimension().getOffset();
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append(MessageFormat.format("\t\tif(!from.is_bound() || from.size_of().get_int() != {0}) '{'\n", this.getDimension().getSize()));
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n\n");
            int i = 0;
            while ((long)i < this.getDimension().getSize()) {
                String tempId2 = aData.getTemporaryVariableName();
                String fromOfTypeName = forValue ? fromOfType.getGenNameValue(aData, conversionFunctionBody) : fromOfType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_at({2});\n", fromOfTypeName, tempId2, i));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = this.elementType.generateConversion(aData, fromOfType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_at({0}).operator_assign({1});\n", to_offset + (long)i, tempId3));
                conversionFunctionBody.append("\t\t}\n");
                ++i;
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    private String generateConversionArrayToArray(JavaGenData aData, Array_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            IType fromOfType = fromType.getElementType();
            long from_offset = fromType.getDimension().getOffset();
            long to_offset = this.getDimension().getOffset();
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            int i = 0;
            while ((long)i < this.getDimension().getSize()) {
                String tempId2 = aData.getTemporaryVariableName();
                String fromOfTypeName = forValue ? fromOfType.getGenNameValue(aData, conversionFunctionBody) : fromOfType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_at({2});\n", fromOfTypeName, tempId2, from_offset + (long)i));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = this.elementType.generateConversion(aData, fromOfType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_at({0}).operator_assign({1});\n", to_offset + (long)i, tempId3));
                conversionFunctionBody.append("\t\t}\n");
                ++i;
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    private String generateConversionTTCNSeqToArray(JavaGenData aData, TTCN3_Sequence_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            int fromComponentCount = fromType.getNofComponents();
            long to_offset = this.getDimension().getOffset();
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append(MessageFormat.format("\t\tint index = {0};\n", to_offset));
            for (int i = 0; i < fromComponentCount; ++i) {
                String tempId2;
                String fromFieldTypeName;
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String string = fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                if (fromComp.isOptional()) {
                    tempId2 = MessageFormat.format("from.constGet_field_{0}()", FieldSubReference.getJavaGetterName(fromFieldName.getName()));
                    conversionFunctionBody.append(MessageFormat.format("\t\tif(from.constGet_field_{0}().is_bound()) '{'\n", FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                    conversionFunctionBody.append(MessageFormat.format("\t\tif (!from.constGet_field_{0}().operator_equals(template_sel.OMIT_VALUE)) '{'\n", FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                } else {
                    tempId2 = aData.getTemporaryVariableName();
                    conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                    conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                }
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = this.elementType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_at(index).operator_assign({0});\n", tempId3));
                if (fromComp.isOptional()) {
                    conversionFunctionBody.append("\t\t\tindex++;\n");
                    conversionFunctionBody.append("\t\t}\n");
                    conversionFunctionBody.append("\t\t} else {\n");
                    conversionFunctionBody.append("\t\t\tindex++;\n");
                    conversionFunctionBody.append("\t\t}\n");
                    continue;
                }
                conversionFunctionBody.append("\t\t}\n");
                conversionFunctionBody.append("\t\tindex++;\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    private String generateConversionASNSeqToArray(JavaGenData aData, ASN1_Sequence_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            int fromComponentCount = fromType.getNofComponents();
            long to_offset = this.getDimension().getOffset();
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            conversionFunctionBody.append(MessageFormat.format("\t\tint index = {0};\n", to_offset));
            for (int i = 0; i < fromComponentCount; ++i) {
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String tempId2 = aData.getTemporaryVariableName();
                String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = this.elementType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_at(index).operator_assign({0});\n", tempId3));
                conversionFunctionBody.append("\t\t}\n");
                conversionFunctionBody.append("\t\tindex++;\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }
}

