/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.Single_ValueRedirection;
import org.eclipse.titan.designer.AST.TTCN3.templates.DecodeMatch_template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Verdict_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Value_Redirection
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final ArrayList<Single_ValueRedirection> valueRedirections;
    private IType valueType = null;
    private boolean verdictOnly = false;
    private Location location = NULL_Location.INSTANCE;
    protected CompilationTimeStamp lastTimeChecked;

    public Value_Redirection() {
        this.valueRedirections = new ArrayList();
    }

    public void add(Single_ValueRedirection single_ValueRedirect) {
        if (single_ValueRedirect != null) {
            single_ValueRedirect.setFullNameParent(this);
            this.valueRedirections.add(single_ValueRedirect);
        }
    }

    public boolean hasDecodedModifier() {
        for (Single_ValueRedirection redirect : this.valueRedirections) {
            if (!redirect.isDecoded()) continue;
            return true;
        }
        return false;
    }

    public IType getType(CompilationTimeStamp timestamp) {
        IType returnValue = null;
        for (int i = 0; i < this.valueRedirections.size(); ++i) {
            IType variableType;
            Single_ValueRedirection redirect = this.valueRedirections.get(i);
            if (redirect.getSubreferences() != null || (variableType = redirect.getVariableReference().checkVariableReference(timestamp)) == null) continue;
            if (returnValue == null) {
                returnValue = variableType;
                continue;
            }
            if (returnValue.isIdentical(timestamp, variableType)) continue;
            this.getLocation().reportSemanticError("The variable references the whole value is redirected to should be of the same type");
            return null;
        }
        return this.valueType;
    }

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.valueRedirections.size(); ++i) {
            Single_ValueRedirection redirect = this.valueRedirections.get(i);
            if (redirect != child) continue;
            return builder.append(".redirect_").append(i + 1);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (Single_ValueRedirection redirect : this.valueRedirections) {
            redirect.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (Single_ValueRedirection redirect : this.valueRedirections) {
            redirect.getVariableReference().setCodeSection(codeSection);
        }
    }

    public void check(CompilationTimeStamp timestamp, IType type) {
        IType.Type_type tt;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.verdictOnly) {
            this.lastTimeChecked = timestamp;
            return;
        }
        boolean invalidType = type.getIsErroneous(timestamp);
        if (!invalidType && (tt = type.getTypeRefdLast(timestamp).getTypetypeTtcn3()) != IType.Type_type.TYPE_TTCN3_SEQUENCE && tt != IType.Type_type.TYPE_TTCN3_SET) {
            for (int i = 0; i < this.valueRedirections.size(); ++i) {
                Single_ValueRedirection redirect = this.valueRedirections.get(i);
                if (redirect.getSubreferences() == null) continue;
                invalidType = true;
                redirect.getLocation().reportSemanticError(MessageFormat.format("Cannot redirect fields of type `{0}'', because it is not a record or set", type.getTypename()));
            }
        }
        if (invalidType) {
            this.checkErroneous(timestamp);
            this.lastTimeChecked = timestamp;
            return;
        }
        this.valueType = type.getTypeRefdLast(timestamp);
        for (int i = 0; i < this.valueRedirections.size(); ++i) {
            Single_ValueRedirection redirect = this.valueRedirections.get(i);
            Reference variableReference = redirect.getVariableReference();
            IType varType = variableReference.checkVariableReference(timestamp);
            ArrayList<ISubReference> subreferences = redirect.getSubreferences();
            IType expectedType = null;
            if (subreferences == null) {
                expectedType = type;
            } else {
                Reference reference = new Reference(null);
                reference.addSubReference(new FieldSubReference(variableReference.getId()));
                for (int j = 0; j < subreferences.size(); ++j) {
                    reference.addSubReference(subreferences.get(j));
                }
                IType fieldType = type.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                if (fieldType != null) {
                    if (redirect.isDecoded()) {
                        Value stringEncoding = redirect.getStringEncoding();
                        boolean isErroneous = false;
                        IType refdLast = fieldType.getTypeRefdLast(timestamp);
                        switch (refdLast.getTypetypeTtcn3()) {
                            case TYPE_BITSTRING: 
                            case TYPE_HEXSTRING: 
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: {
                                if (stringEncoding == null) break;
                                stringEncoding.getLocation().reportSemanticError("The encoding format parameter for the '@decoded' modifier is only available to value redirects of universal charstrings");
                                isErroneous = true;
                                break;
                            }
                            case TYPE_UCHARSTRING: {
                                if (stringEncoding == null) break;
                                stringEncoding.checkStringEncoding(timestamp, null);
                                break;
                            }
                            default: {
                                redirect.getLocation().reportSemanticError("The '@decoded' modifier is only available to value redirects of string types.");
                                isErroneous = true;
                            }
                        }
                        if (!isErroneous && varType != null) {
                            IType declarationType = varType.getTypeRefdLast(timestamp);
                            redirect.setDeclarationType(declarationType);
                            varType.checkCoding(timestamp, false, variableReference.getMyScope().getModuleScope(), false, variableReference.getLocation());
                        }
                    } else {
                        expectedType = fieldType;
                    }
                }
            }
            if (expectedType == null || varType == null) continue;
            TypeCompatibilityInfo info = new TypeCompatibilityInfo(expectedType, varType, true);
            info.setStr2Elem(variableReference.refersToStringElement());
            if (expectedType.isCompatible(timestamp, varType, info, null, null)) continue;
            if (info.getSubtypeError() != null) {
                redirect.getLocation().reportSemanticError(info.getSubtypeError());
                continue;
            }
            if (info.getErrorStr() != null) {
                redirect.getLocation().reportSemanticError(info.getErrorStr());
                continue;
            }
            redirect.getLocation().reportSemanticError(MessageFormat.format("Type mismatch in value redirect: A variable of type `{0}'' was expected instead of `{1}''", expectedType.getTypename(), varType.getTypename()));
        }
        this.lastTimeChecked = timestamp;
    }

    public void checkErroneous(CompilationTimeStamp timestamp) {
        for (int i = 0; i < this.valueRedirections.size(); ++i) {
            Single_ValueRedirection redirect = this.valueRedirections.get(i);
            redirect.getVariableReference().checkVariableReference(timestamp);
            Value stringEncoding = redirect.getStringEncoding();
            if (stringEncoding == null) continue;
            stringEncoding.checkStringEncoding(timestamp, null);
        }
    }

    public void checkVerdictOnly(CompilationTimeStamp timestamp) {
        this.verdictOnly = true;
        this.check(timestamp, new Verdict_Type());
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (Single_ValueRedirection redirect : this.valueRedirections) {
            if (redirect == null) continue;
            redirect.updateSyntax(reparser, false);
            reparser.updateLocation(redirect.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.valueRedirections == null) {
            return;
        }
        for (Single_ValueRedirection redirect : this.valueRedirections) {
            redirect.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.valueRedirections != null) {
            for (Single_ValueRedirection redirect : this.valueRedirections) {
                if (redirect.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }

    public void generateCode(JavaGenData aData, ExpressionStruct expression, TemplateInstance matchedTi, String lastGenTIExpression) {
        if (this.verdictOnly) {
            if (this.valueRedirections.size() == 1) {
                this.valueRedirections.get(0).getVariableReference().generateCode(aData, expression);
            }
        } else {
            aData.addBuiltinTypeImport("Value_Redirect_Interface");
            Scope scope = this.valueRedirections.get(0).getVariableReference().getMyScope();
            StringBuilder membersString = new StringBuilder();
            StringBuilder constructorParameters = new StringBuilder();
            StringBuilder constructorInitializers = new StringBuilder();
            StringBuilder instanceParameterList = new StringBuilder();
            StringBuilder setValuesString = new StringBuilder();
            if (matchedTi != null && this.hasDecodedModifier()) {
                instanceParameterList.append(MessageFormat.format("{0}, ", lastGenTIExpression));
                String templateName = this.valueType.getGenNameTemplate(aData, expression.expression);
                membersString.append(MessageFormat.format("{0} ptr_matched_temp;\n", templateName));
                constructorParameters.append(MessageFormat.format("{0} par_matched_temp, ", templateName));
                constructorInitializers.append("ptr_matched_temp = par_matched_temp;\n");
            }
            boolean needPar = false;
            for (int i = 0; i < this.valueRedirections.size(); ++i) {
                String subrefsString;
                IType redirectionType;
                if (i > 0) {
                    constructorParameters.append(", ");
                    instanceParameterList.append(", ");
                }
                Single_ValueRedirection redirection = this.valueRedirections.get(i);
                ExpressionStruct variableReferenceExpression = new ExpressionStruct();
                Reference variableReference = redirection.getVariableReference();
                variableReference.generateCode(aData, variableReferenceExpression);
                Assignment assignment = variableReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                if (assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(variableReference.getSubreferences())) {
                    variableReferenceExpression.expression.append(".get()");
                }
                instanceParameterList.append((CharSequence)variableReferenceExpression.expression);
                if (variableReferenceExpression.preamble != null) {
                    expression.preamble.append((CharSequence)variableReferenceExpression.preamble);
                }
                if (variableReferenceExpression.postamble != null) {
                    expression.postamble.append((CharSequence)variableReferenceExpression.postamble);
                }
                if (redirection.getSubreferences() == null) {
                    redirectionType = this.valueType;
                } else {
                    ArrayList<ISubReference> subreferences = redirection.getSubreferences();
                    Reference reference = new Reference(null);
                    reference.addSubReference(new FieldSubReference(variableReference.getId()));
                    for (int j = 0; j < subreferences.size(); ++j) {
                        reference.addSubReference(subreferences.get(j));
                    }
                    redirectionType = this.valueType.getFieldType(CompilationTimeStamp.getBaseTimestamp(), reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                }
                redirectionType = redirectionType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType referenceType = variableReference.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
                referenceType = referenceType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType memberType = redirection.isDecoded() ? redirection.getDeclarationType() : referenceType;
                String typeName = memberType.getGenNameValue(aData, expression.expression);
                membersString.append(MessageFormat.format("{0} ptr_{1};\n", typeName, i));
                constructorParameters.append(MessageFormat.format("{0} par_{1}", typeName, i));
                constructorInitializers.append(MessageFormat.format("ptr_{0} = par_{0};\n", i));
                ExpressionStruct subrefExpression = new ExpressionStruct();
                String optionalSuffix = "";
                if (redirection.getSubreferences() != null) {
                    CompField cf;
                    ArrayList<ISubReference> subreferences = redirection.getSubreferences();
                    Reference.generateCode(aData, subrefExpression, subreferences, 0, false, true, this.valueType);
                    if (redirectionType.getOwnertype() == IType.TypeOwner_type.OT_COMP_FIELD && (cf = (CompField)redirectionType.getOwner()).isOptional()) {
                        optionalSuffix = ".get()";
                    }
                }
                if (subrefExpression.preamble.length() > 0) {
                    setValuesString.append((CharSequence)subrefExpression.preamble);
                }
                String string = subrefsString = subrefExpression.expression.length() > 0 ? subrefExpression.expression.toString() : "";
                if (redirection.isDecoded()) {
                    ITTCN3Template matchedTemplate = null;
                    if (matchedTi != null) {
                        ArrayList<ISubReference> subreferences = redirection.getSubreferences();
                        Reference reference = new Reference(null);
                        reference.addSubReference(new FieldSubReference(variableReference.getId()));
                        for (int j = 0; j < subreferences.size(); ++j) {
                            reference.addSubReference(subreferences.get(j));
                        }
                        matchedTemplate = matchedTi.getTemplateBody().getReferencedSubTemplate(CompilationTimeStamp.getBaseTimestamp(), reference, null, true);
                    }
                    if (matchedTemplate != null) {
                        matchedTemplate = matchedTemplate.getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
                    }
                    boolean useDecmatchResult = matchedTemplate != null && matchedTemplate.getTemplatetype() == ITTCN3Template.Template_type.DECODE_MATCH;
                    boolean needsDecode = true;
                    ExpressionStruct redirCodingExpression = new ExpressionStruct();
                    if (redirectionType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_UCHARSTRING) {
                        aData.addBuiltinTypeImport("TitanCharString.CharCoding");
                        IValue temp = redirection.getStringEncoding();
                        if (temp != null) {
                            temp = temp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                        }
                        if (temp == null || !temp.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                            Charstring_Value stringEncoding = (Charstring_Value)temp;
                            String redirCodingString = stringEncoding == null || "UTF-8".equals(stringEncoding.getValue()) ? "UTF_8" : ("UTF-16".equals(stringEncoding.getValue()) || "UTF-16BE".equals(stringEncoding.getValue()) ? "UTF16BE" : ("UTF-16LE".equals(stringEncoding.getValue()) ? "UTF16LE" : ("UTF-32LE".equals(stringEncoding.getValue()) ? "UTF32LE" : "UTF32BE")));
                            redirCodingExpression.expression.append(MessageFormat.format("CharCoding.{0}", redirCodingString));
                        } else {
                            redirCodingExpression.preamble.append(MessageFormat.format("CharCoding coding = TitanUniversalCharString.get_character_coding(enc_fmt_{0}.get_value().toString(), \"decoded parameter redirect\");\n", i));
                            redirCodingExpression.expression.append("coding");
                        }
                    }
                    if (useDecmatchResult) {
                        needsDecode = false;
                        TemplateInstance decodeTarget = ((DecodeMatch_template)matchedTemplate).getDecodeTarget();
                        IType targetGovernor = decodeTarget.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
                        IType decmatchType = targetGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                        if (redirection.getDeclarationType() != decmatchType) {
                            needsDecode = true;
                            useDecmatchResult = false;
                        } else if (redirectionType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3() == IType.Type_type.TYPE_UCHARSTRING) {
                            boolean differentUstrEncoding = false;
                            boolean unkonwnUstrEncodings = false;
                            if (redirection.getStringEncoding() == null) {
                                Value tempStringEncoding = ((DecodeMatch_template)matchedTemplate).getStringEncoding();
                                if (tempStringEncoding != null) {
                                    if (tempStringEncoding.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                        unkonwnUstrEncodings = true;
                                    } else {
                                        Charstring_Value stringEncoding = (Charstring_Value)tempStringEncoding.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                        if (!"UTF-8".equals(stringEncoding.getValue())) {
                                            differentUstrEncoding = true;
                                        }
                                    }
                                }
                            } else if (redirection.getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                unkonwnUstrEncodings = true;
                            } else if (((DecodeMatch_template)matchedTemplate).getStringEncoding() == null) {
                                IValue temp = redirection.getStringEncoding().getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                if ("UTF-8".equals(((Charstring_Value)temp).getValue())) {
                                    differentUstrEncoding = true;
                                }
                            } else if (((DecodeMatch_template)matchedTemplate).getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                unkonwnUstrEncodings = true;
                            } else {
                                IValue redirectionTemp = redirection.getStringEncoding().getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                Value templateTemp = ((DecodeMatch_template)matchedTemplate).getStringEncoding();
                                Charstring_Value tempStringEncoding = (Charstring_Value)templateTemp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                if (!((Charstring_Value)redirectionTemp).getValue().equals(tempStringEncoding.getValue())) {
                                    differentUstrEncoding = true;
                                }
                            }
                            if (unkonwnUstrEncodings) {
                                needsDecode = true;
                                setValuesString.append(MessageFormat.format("{0}if ( {1} == ptr_matched_temp{2}.get_decmatch_str_enc()) '{'\n", redirCodingExpression.preamble, redirCodingExpression.expression, subrefsString));
                            } else if (differentUstrEncoding) {
                                needsDecode = true;
                                useDecmatchResult = false;
                            }
                        }
                    } else {
                        boolean unfoldable;
                        boolean bl = unfoldable = matchedTemplate == null;
                        if (!unfoldable) {
                            switch (matchedTemplate.getTemplatetype()) {
                                case ANY_VALUE: 
                                case ANY_OR_OMIT: 
                                case BSTR_PATTERN: 
                                case CSTR_PATTERN: 
                                case HSTR_PATTERN: 
                                case OSTR_PATTERN: 
                                case USTR_PATTERN: 
                                case COMPLEMENTED_LIST: 
                                case VALUE_LIST: 
                                case VALUE_RANGE: {
                                    break;
                                }
                                default: {
                                    unfoldable = true;
                                }
                            }
                        }
                        if (unfoldable && matchedTi != null) {
                            useDecmatchResult = true;
                            if (redirCodingExpression.preamble.length() > 0) {
                                setValuesString.append((CharSequence)redirCodingExpression.preamble);
                            }
                            setValuesString.append("if (ptr_matched_temp.get_selection() == template_sel.SPECIFIC_VALUE && ");
                            StringBuilder currentRef = new StringBuilder("ptr_matched_temp");
                            int length = subrefsString.length();
                            int start = 0;
                            for (int j = 0; j < length; ++j) {
                                if (subrefsString.charAt(j) != '.' && subrefsString.charAt(j) != '[') continue;
                                currentRef.append(subrefsString.substring(start, j));
                                setValuesString.append(MessageFormat.format("{0}.get_selection() == template_sel.SPECIFIC_VALUE && ", currentRef));
                                start = j;
                            }
                            setValuesString.append(MessageFormat.format("ptr_matched_temp{0}.get_selection() == template_sel.DECODE_MATCH && ", subrefsString));
                            setValuesString.append(MessageFormat.format("{0}_descr_ == ptr_matched_temp{1}.get_decmatch_type_descr()", redirection.getDeclarationType().getGenNameTypeDescriptor(aData, setValuesString), subrefsString));
                            if (redirCodingExpression.expression.length() > 0) {
                                setValuesString.append(MessageFormat.format(" && {0} == ptr_matched_temp{1}.get_decmatch_str_enc()", redirCodingExpression.expression, subrefsString));
                            }
                            setValuesString.append(") {\n");
                        }
                    }
                    if (useDecmatchResult) {
                        setValuesString.append(MessageFormat.format("ptr_{0}.operator_assign(({1})ptr_matched_temp{2}.get_decmatch_dec_res());\n", i, typeName, subrefsString));
                    }
                    if (needsDecode) {
                        needPar = true;
                        if (useDecmatchResult) {
                            setValuesString.append("} else {\n");
                        }
                        IType.Type_type tt = redirectionType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetypeTtcn3();
                        aData.addBuiltinTypeImport("TitanOctetString");
                        aData.addBuiltinTypeImport("AdditionalFunctions");
                        setValuesString.append(MessageFormat.format("TitanOctetString buff_{0} = new TitanOctetString(", i));
                        switch (tt) {
                            case TYPE_BITSTRING: {
                                setValuesString.append(MessageFormat.format("AdditionalFunctions.bit2oct(par{0}{1})", subrefsString, optionalSuffix));
                                break;
                            }
                            case TYPE_HEXSTRING: {
                                setValuesString.append(MessageFormat.format("AdditionalFunctions.hex2oct(par{0}{1})", subrefsString, optionalSuffix));
                                break;
                            }
                            case TYPE_OCTETSTRING: {
                                setValuesString.append(MessageFormat.format("par{0}{1}", subrefsString, optionalSuffix));
                                break;
                            }
                            case TYPE_CHARSTRING: {
                                setValuesString.append(MessageFormat.format("AdditionalFunctions.char2oct(par{0}{1})", subrefsString, optionalSuffix));
                                break;
                            }
                            case TYPE_UCHARSTRING: {
                                setValuesString.append(MessageFormat.format("AdditionalFunctions.unichar2oct(par{0}{1}, ", subrefsString, optionalSuffix));
                                if (redirection.getStringEncoding() == null) {
                                    setValuesString.append("\"UTF-8\"");
                                } else if (!redirection.getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                    IValue temp = redirection.getStringEncoding();
                                    temp = temp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                    setValuesString.append(MessageFormat.format("\"{0}\"", ((Charstring_Value)temp).getValue()));
                                } else {
                                    instanceParameterList.append(", ");
                                    ExpressionStruct stringEncodingExpression = new ExpressionStruct();
                                    redirection.getStringEncoding().generateCodeExpression(aData, stringEncodingExpression, false);
                                    instanceParameterList.append((CharSequence)stringEncodingExpression.expression);
                                    if (stringEncodingExpression.preamble.length() > 0) {
                                        expression.preamble.append((CharSequence)stringEncodingExpression.preamble);
                                    }
                                    if (stringEncodingExpression.postamble.length() > 0) {
                                        expression.postamble.append((CharSequence)stringEncodingExpression.postamble);
                                    }
                                    membersString.append(MessageFormat.format("TitanCharString enc_fmt_{0};\n", i));
                                    constructorParameters.append(MessageFormat.format(", TitanCharString par_fmt_{0}", i));
                                    constructorInitializers.append(MessageFormat.format("enc_fmt_{0} = par_fmt_{0};\n", i));
                                    setValuesString.append(MessageFormat.format("enc_fmt_{0}", i));
                                }
                                setValuesString.append(')');
                                break;
                            }
                        }
                        setValuesString.append(");\n");
                        String coderName = memberType.getGenNameCoder(aData, setValuesString, scope);
                        String codingName = memberType.getGenNameDefaultCoding(aData, setValuesString, scope);
                        setValuesString.append(MessageFormat.format("if ({0}_decoder(buff_{1}, ptr_{1}, {2}_default_coding) != 0) '{'\n", coderName, i, codingName));
                        setValuesString.append(MessageFormat.format("throw new TtcnError(\"Decoding failed in value redirect #{0}.\");\n", i + 1));
                        setValuesString.append("}\n");
                        setValuesString.append(MessageFormat.format("if (buff_{0}.lengthof().operator_not_equals(0)) '{'\n", i));
                        setValuesString.append(MessageFormat.format("throw new TtcnError(MessageFormat.format(\"Value redirect #{0} failed, because the buffer was not empty after decoding. Remaining octets: '{'0'}'\", buff_{1}.lengthof().get_int()));\n", i + 1, i));
                        setValuesString.append("}\n");
                        if (useDecmatchResult) {
                            setValuesString.append("}\n");
                        }
                    }
                } else {
                    needPar = true;
                    if (referenceType.isIdentical(CompilationTimeStamp.getBaseTimestamp(), redirectionType)) {
                        setValuesString.append(MessageFormat.format("ptr_{0}.operator_assign(par{1}{2});\n", i, subrefsString, optionalSuffix));
                    } else {
                        ExpressionStruct localExpression = new ExpressionStruct();
                        String parname = MessageFormat.format("par{0}{1}", subrefsString, optionalSuffix);
                        String conversionResult = referenceType.generateConversion(aData, redirectionType, parname, true, localExpression);
                        if (localExpression.preamble.length() > 0) {
                            setValuesString.append((CharSequence)localExpression.preamble);
                        }
                        setValuesString.append(MessageFormat.format("ptr_{0}.operator_assign({1});\n", i, conversionResult));
                        if (localExpression.postamble.length() > 0) {
                            setValuesString.append((CharSequence)localExpression.postamble);
                        }
                    }
                }
                if (subrefExpression.postamble.length() <= 0) continue;
                setValuesString.append((CharSequence)subrefExpression.postamble);
            }
            String tempClassName = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("class Value_Redirect_{0} implements Value_Redirect_Interface '{'\n", tempClassName));
            expression.preamble.append((CharSequence)membersString);
            expression.preamble.append(MessageFormat.format("public Value_Redirect_{0}({1}) '{'\n", tempClassName, constructorParameters));
            expression.preamble.append((CharSequence)constructorInitializers);
            expression.preamble.append("}\n");
            expression.preamble.append("\t@Override\n");
            expression.preamble.append("\tpublic void set_values(final Base_Type values) {\n");
            if (needPar) {
                expression.preamble.append(MessageFormat.format("final {0} par = ({0})values;\n", this.valueType.getGenNameValue(aData, expression.preamble)));
            }
            expression.preamble.append((CharSequence)setValuesString);
            expression.preamble.append("\t}\n");
            expression.preamble.append("}\n");
            String tempVariableName = aData.getTemporaryVariableName();
            expression.preamble.append(MessageFormat.format("Value_Redirect_{0} {1} = new Value_Redirect_{0}({2});\n", tempClassName, tempVariableName, instanceParameterList));
            expression.expression.append(tempVariableName);
        }
    }
}

