/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.values.Named_Integer_Value;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueRange;
import org.eclipse.titan.designer.AST.TTCN3.templates.Value_Range_Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_Integer_Type
extends ASN1Type {
    private static final String INTEGERVALUEEXPECTED = "INTEGER value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `integer''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `integer''";
    private static final String INCORRECTBOUNDARIES = "The lower boundary is higher than the upper boundary";
    private static final String INCORRECTLOWERBOUNDARY = "The lower boundary cannot be infinity";
    private static final String INCORRECTUPPERBOUNDARY = "The upper boundary cannot be -infinity";
    private final Block mBlock;
    private NamedValues namedNumbers;

    public ASN1_Integer_Type() {
        this.mBlock = null;
    }

    public ASN1_Integer_Type(Block aBlock) {
        this.mBlock = aBlock;
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_Integer_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_INTEGER_A;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_INTEGER;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.namedNumbers) {
            this.namedNumbers.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (child == this.namedNumbers) {
            builder.append(".<namedvalues>");
        }
        return builder;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_INTEGER.equals((Object)temp.getTypetype()) || IType.Type_type.TYPE_INTEGER_A.equals((Object)temp.getTypetype());
    }

    @Override
    public String getTypename() {
        return "integer";
    }

    @Override
    public String getOutlineIcon() {
        return "integer.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("integer");
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.myScope && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            return;
        }
        this.isErroneous = false;
        if (null == this.namedNumbers) {
            this.parseBlockInt();
        }
        if (this.isErroneous || null == this.namedNumbers) {
            return;
        }
        HashMap<String, Identifier> nameMap = new HashMap<String, Identifier>();
        int size = this.namedNumbers.getSize();
        for (int i = 0; i < size; ++i) {
            NamedValue namedValue = this.namedNumbers.getNamedValueByIndex(i);
            Identifier identifier = namedValue.getName();
            if (nameMap.containsKey(identifier.getName())) {
                Location tempLocation = ((Identifier)nameMap.get(identifier.getName())).getLocation();
                tempLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                continue;
            }
            nameMap.put(identifier.getName(), identifier);
        }
        HashMap<Integer, NamedValue> valueMap = new HashMap<Integer, NamedValue>();
        int size2 = this.namedNumbers.getSize();
        block4: for (int i = 0; i < size2; ++i) {
            NamedValue namedValue = this.namedNumbers.getNamedValueByIndex(i);
            IValue value = namedValue.getValue();
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue last = value.getValueRefdLast(timestamp, referenceChain);
            referenceChain.release();
            if (last.getIsErroneous(timestamp)) continue;
            switch (last.getValuetype()) {
                case INTEGER_VALUE: {
                    Integer_Value integerValue = (Integer_Value)last;
                    if (integerValue.isNative()) {
                        Integer intValue = integerValue.intValue();
                        if (valueMap.containsKey(intValue)) {
                            value.getLocation().reportSemanticError(MessageFormat.format("Duplicate number {0} for name `{1}''", intValue, namedValue.getName().getDisplayName()));
                            NamedValue temp = (NamedValue)valueMap.get(intValue);
                            temp.getLocation().reportSemanticError(MessageFormat.format("Number {0} is already assigned to name `{1}''", intValue, temp.getName().getDisplayName()));
                            continue block4;
                        }
                        valueMap.put(intValue, namedValue);
                        continue block4;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format("Integer value `{0}'' is too big to be used as a named number", integerValue.getValueValue()));
                    value.setIsErroneous(true);
                    continue block4;
                }
                default: {
                    namedValue.getLocation().reportSemanticError(MessageFormat.format("INTEGER value was expected for named number `{0}''", namedValue.getName().getDisplayName()));
                    value.setIsErroneous(true);
                }
            }
        }
        nameMap.clear();
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype()) && value.isAsn()) {
            if (null == this.lastTimeChecked) {
                this.check(timestamp);
            }
            if (null != this.namedNumbers && this.namedNumbers.hasNamedValueWithName(((Undefined_LowerIdentifier_Value)value).getIdentifier())) {
                IValue tempValue = value.setValuetype(timestamp, IValue.Value_type.NAMED_INTEGER_VALUE);
                tempValue.setMyGovernor(this);
                return tempValue;
            }
        }
        return super.checkThisValueRef(timestamp, value);
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: {
                break;
            }
            case NAMED_INTEGER_VALUE: {
                if (null == this.namedNumbers) break;
                Identifier name = ((Named_Integer_Value)last).getIdentifier();
                NamedValue namedValue = this.namedNumbers.getNamedValueByName(name);
                IValue tempValue = namedValue.getValue();
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                tempValue = tempValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (tempValue.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype())) break;
                int temp = ((Integer_Value)tempValue).intValue();
                Integer_Value converted = new Integer_Value(temp);
                converted.copyGeneralProperties(value);
                ((Named_Integer_Value)last).setCalculatedValue(converted);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    public void checkThisValueLimit(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, null, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case INTEGER_VALUE: 
            case REAL_VALUE: {
                break;
            }
            case NAMED_INTEGER_VALUE: {
                if (null == this.namedNumbers) break;
                Identifier name = ((Named_Integer_Value)last).getIdentifier();
                NamedValue namedValue = this.namedNumbers.getNamedValueByName(name);
                IValue tempValue = namedValue.getValue();
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                tempValue = tempValue.getValueRefdLast(timestamp, referenceChain);
                referenceChain.release();
                if (tempValue.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype())) break;
                int temp = ((Integer_Value)tempValue).intValue();
                Integer_Value converted = new Integer_Value(temp);
                converted.copyGeneralProperties(value);
                ((Named_Integer_Value)last).setCalculatedValue(converted);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        if (ITTCN3Template.Template_type.VALUE_RANGE.equals((Object)template.getTemplatetype())) {
            ValueRange range = ((Value_Range_Template)template).getValueRange();
            IValue lower = this.checkBoundary(timestamp, range.getMin(), BOUNDARY_TYPE.LOWER);
            IValue upper = this.checkBoundary(timestamp, range.getMax(), BOUNDARY_TYPE.UPPER);
            range.setTypeType(this.getTypetypeTtcn3());
            if (lower != null && IValue.Value_type.INTEGER_VALUE.equals((Object)lower.getValuetype()) && upper != null && IValue.Value_type.INTEGER_VALUE.equals((Object)upper.getValuetype()) && !this.getIsErroneous(timestamp) && ((Integer_Value)lower).getValue() > ((Integer_Value)upper).getValue()) {
                template.getLocation().reportSemanticError(INCORRECTBOUNDARIES);
            }
            if (lower != null && range.getMax() == null) {
                this.checkBoundaryInfinity(timestamp, lower, true);
            }
            if (range.getMin() == null && upper != null) {
                this.checkBoundaryInfinity(timestamp, upper, false);
            }
            if (range.getMin() == null && range.isMinExclusive()) {
                template.getLocation().reportSemanticError("invalid lower boundary, -infinity cannot be excluded from an integer template range");
                template.setIsErroneous(true);
            }
            if (range.getMax() == null && range.isMaxExclusive()) {
                template.getLocation().reportSemanticError("invalid upper boundary, infinity cannot be excluded from an integer template range");
                template.setIsErroneous(true);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
        return false;
    }

    private IValue checkBoundary(CompilationTimeStamp timestamp, Value value, BOUNDARY_TYPE btype) {
        if (value == null) {
            return null;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValueLimit(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (IValue.Value_type.REAL_VALUE.equals((Object)temp.getValuetype())) {
            if (((Real_Value)temp).isNegativeInfinity()) {
                if (BOUNDARY_TYPE.UPPER.equals((Object)btype)) {
                    value.getLocation().reportSemanticError(INCORRECTUPPERBOUNDARY);
                    value.setIsErroneous(true);
                }
                return temp;
            }
            if (((Real_Value)temp).isPositiveInfinity()) {
                if (BOUNDARY_TYPE.LOWER.equals((Object)btype)) {
                    value.getLocation().reportSemanticError(INCORRECTLOWERBOUNDARY);
                    value.setIsErroneous(true);
                }
                return temp;
            }
            value.getLocation().reportSemanticError(INTEGERVALUEEXPECTED);
            value.setIsErroneous(true);
            return null;
        }
        switch (temp.getValuetype()) {
            case INTEGER_VALUE: {
                break;
            }
            default: {
                temp = null;
            }
        }
        return temp;
    }

    private void checkBoundaryInfinity(CompilationTimeStamp timestamp, IValue value, boolean isUpper) {
        if (value == null) {
            return;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValue(timestamp, temp, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_STATIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_STATIC_VALUE, null);
        if (temp.getValuetype() == IValue.Value_type.OMIT_VALUE) {
            value.getLocation().reportSemanticError("`omit' value is not allowed in this context");
            value.setIsErroneous(true);
            return;
        }
        if (this.subType != null) {
            // empty if block
        }
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    private void parseBlockInt() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.namedNumbers = parser.pr_special_NamedNumberList().namedValues;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.namedNumbers = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.namedNumbers != null) {
            this.namedNumbers.setFullNameParent(this);
            this.namedNumbers.setMyScope(this.getMyScope());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.namedNumbers != null) {
            this.namedNumbers.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.namedNumbers == null || this.namedNumbers.accept(v);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.hasRawAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return "INTEGER";
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanInteger");
        return "TitanInteger";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanInteger_template");
        return "TitanInteger_template";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp())) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanInteger");
        return "TitanInteger.TitanInteger";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("TitanInteger");
        return "TitanInteger.TitanInteger_json_";
    }

    private static enum BOUNDARY_TYPE {
        LOWER,
        UPPER;

    }
}

