/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanValue_Array<T extends Base_Type>
extends Base_Type {
    Base_Type[] array_elements;
    public Class<T> clazz;
    int array_size;
    int indexOffset;

    public TitanValue_Array(TitanValue_Array<T> otherValue) {
        this.clazz = otherValue.clazz;
        this.array_size = otherValue.array_size;
        this.indexOffset = otherValue.indexOffset;
        this.array_elements = new Base_Type[this.array_size];
        for (int i = 0; i < this.array_size; ++i) {
            try {
                Base_Type helper = (Base_Type)this.clazz.newInstance();
                helper.operator_assign(otherValue.array_elements[i]);
                this.array_elements[i] = helper;
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
    }

    public TitanValue_Array(Class<T> clazz, int size, int offset) {
        this.clazz = clazz;
        this.indexOffset = offset;
        this.array_size = size;
        this.array_elements = new Base_Type[size];
        for (int i = 0; i < size; ++i) {
            try {
                Base_Type emply;
                this.array_elements[i] = emply = (Base_Type)clazz.newInstance();
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", clazz, e));
            }
        }
    }

    public int get_offset() {
        return this.indexOffset;
    }

    public void set_offset(int offset) {
        this.indexOffset = offset;
    }

    @Override
    public void set_implicit_omit() {
        for (int i = 0; i < this.array_size; ++i) {
            if (!this.array_elements[i].is_bound()) continue;
            this.array_elements[i].set_implicit_omit();
        }
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    @Override
    public boolean is_bound() {
        for (int i = 0; i < this.array_size; ++i) {
            if (!this.array_elements[i].is_bound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clean_up() {
        for (int i = 0; i < this.array_size; ++i) {
            this.array_elements[i].clean_up();
        }
    }

    @Override
    public boolean is_value() {
        for (int i = 0; i < this.array_size; ++i) {
            if (this.array_elements[i].is_value()) continue;
            return false;
        }
        return true;
    }

    public TitanInteger lengthof() {
        for (int i = this.array_size - 1; i >= 0; --i) {
            if (!this.array_elements[i].is_bound()) continue;
            return new TitanInteger(i + 1);
        }
        return new TitanInteger(0);
    }

    @Override
    public TitanValue_Array<T> operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanValue_Array) {
            TitanValue_Array arrayOther = (TitanValue_Array)otherValue;
            return this.operator_assign(arrayOther);
        }
        try {
            this.array_size = 1;
            this.array_elements = new Base_Type[1];
            Base_Type value = (Base_Type)this.clazz.newInstance();
            value.operator_assign(otherValue);
            this.array_elements[0] = value;
        }
        catch (InstantiationException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
        }
        catch (IllegalAccessException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
        }
        return this;
    }

    public TitanValue_Array<T> operator_assign(TitanValue_Array<T> otherValue) {
        this.clean_up();
        this.array_size = otherValue.array_size;
        this.indexOffset = otherValue.indexOffset;
        this.array_elements = new Base_Type[this.array_size];
        for (int i = 0; i < otherValue.array_size; ++i) {
            try {
                Base_Type helper = (Base_Type)this.clazz.newInstance();
                helper.operator_assign((Base_Type)otherValue.array_element(i));
                this.array_elements[i] = helper;
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.clazz, e));
            }
        }
        return this;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanValue_Array) {
            TitanValue_Array arrayOther = (TitanValue_Array)otherValue;
            return this.operator_equals(arrayOther);
        }
        if (this.array_size == 1) {
            return this.array_elements[0].operator_equals(otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to array value", otherValue));
    }

    public boolean operator_equals(TitanValue_Array<T> otherValue) {
        if (this.array_size != otherValue.array_size) {
            return false;
        }
        for (int i = 0; i < this.array_size; ++i) {
            if (this.array_elements[i].operator_equals(otherValue.array_elements[i])) continue;
            return false;
        }
        return true;
    }

    public boolean operator_not_equals(Base_Type otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanValue_Array<T> otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanValue_Array<T> rotate_left(int rotateCount) {
        if (this.array_size == 0) {
            return this;
        }
        if (rotateCount >= 0) {
            int i;
            if ((rotateCount %= this.array_size) == 0) {
                return this;
            }
            TitanValue_Array<T> result = new TitanValue_Array<T>(this.clazz, this.array_size, this.indexOffset);
            if (rotateCount > this.array_size) {
                rotateCount = this.array_size;
            }
            for (i = 0; i < this.array_size - rotateCount; ++i) {
                result.array_elements[i] = this.array_elements[i + rotateCount];
            }
            for (i = this.array_size - rotateCount; i < this.array_size; ++i) {
                result.array_elements[i] = this.array_elements[i + rotateCount - this.array_size];
            }
            return result;
        }
        return this.rotate_left(-rotateCount);
    }

    public TitanValue_Array<T> rotate_left(TitanInteger rotateCount) {
        rotateCount.must_bound("Unbound integer operand of rotate left operator.");
        return this.rotate_left(rotateCount.get_int());
    }

    public TitanValue_Array<T> rotate_right(int rotateCount) {
        if (this.array_size == 0) {
            return this;
        }
        if (rotateCount >= 0) {
            int i;
            if ((rotateCount %= this.array_size) == 0) {
                return this;
            }
            TitanValue_Array<T> result = new TitanValue_Array<T>(this.clazz, this.array_size, this.indexOffset);
            if (rotateCount > this.array_size) {
                rotateCount = this.array_size;
            }
            for (i = 0; i < rotateCount; ++i) {
                result.array_elements[i] = this.array_elements[i - rotateCount + this.array_size];
            }
            for (i = rotateCount; i < this.array_size; ++i) {
                result.array_elements[i] = this.array_elements[i - rotateCount];
            }
            return result;
        }
        return this.rotate_left(-rotateCount);
    }

    public TitanValue_Array<T> rotate_right(TitanInteger rotateCount) {
        rotateCount.must_bound("Unbound integer operand of rotate right operator.");
        return this.rotate_right(rotateCount.get_int());
    }

    public T get_at(int index) {
        return (T)this.array_elements[TitanValue_Array.get_array_index(index, this.array_size, this.indexOffset)];
    }

    public T get_at(TitanInteger index) {
        return (T)this.array_elements[TitanValue_Array.get_array_index(index, this.array_size, this.indexOffset)];
    }

    public T constGet_at(int index) {
        return (T)this.array_elements[TitanValue_Array.get_array_index(index, this.array_size, this.indexOffset)];
    }

    public T constGet_at(TitanInteger index) {
        return (T)this.array_elements[TitanValue_Array.get_array_index(index, this.array_size, this.indexOffset)];
    }

    public T array_element(int index) {
        return (T)this.array_elements[index];
    }

    public T array_element(TitanInteger index) {
        index.must_bound("Accessing an element of an array using an unbound index.");
        return (T)this.array_elements[index.get_int()];
    }

    public int n_elem() {
        return this.array_size;
    }

    public TitanInteger size_of() {
        return new TitanInteger(this.array_size);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("{");
        for (int i = 0; i < this.array_size - 1; ++i) {
            str.append(this.array_elements[i].toString());
            str.append(" , ");
        }
        if (this.array_size > 0) {
            str.append(this.array_elements[this.array_size - 1].toString());
        }
        str.append('}');
        return str.toString();
    }

    public static int get_array_index(int index, int arraySize, int indexofset) {
        if (arraySize < 0) {
            throw new TtcnError("Invalid array size");
        }
        if (index < indexofset) {
            throw new TtcnError("Index underflow when accessing an element of an array. The index value should be between " + indexofset + " and " + (indexofset + arraySize - 1) + " instead of " + index + ".");
        }
        int result = index - indexofset;
        if (result >= arraySize) {
            throw new TtcnError("Index overflow when accessing an element of an array. The index value should be between " + indexofset + " and " + (indexofset + arraySize - 1) + " instead of " + index + ".");
        }
        return result;
    }

    public static int get_array_index(TitanInteger index, int arraySize, int indexofset) {
        index.must_bound("Accessing an element of an array using an unbound index.");
        return TitanValue_Array.get_array_index(index.get_int(), arraySize, indexofset);
    }

    @Override
    public void log() {
        TTCN_Logger.log_event_str("{ ");
        for (int elem_count = 0; elem_count < this.array_size; ++elem_count) {
            if (elem_count > 0) {
                TTCN_Logger.log_event_str(", ");
            }
            this.array_elements[elem_count].log();
        }
        TTCN_Logger.log_event_str(" }");
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        if (param.get_id() != null && param.get_id() instanceof Param_Types.Module_Param_Name && ((Param_Types.Module_Param_Name)param.get_id()).next_name()) {
            int param_index;
            String param_field = param.get_id().get_current_name();
            if (param_field.charAt(0) < '0' || param_field.charAt(0) > '9') {
                param.error("Unexpected record field name in module parameter, expected a valid array index", new Object[0]);
            }
            if ((param_index = Integer.parseInt(param_field)) >= this.array_size) {
                param.error("Invalid array index: %u. The array only has %u elements.", param_index, this.array_size);
            }
            this.array_elements[param_index].set_param(param);
            return;
        }
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "array value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Value_List: {
                if (param.get_size() != this.array_size) {
                    param.error("The array value has incorrect number of elements: %lu was expected instead of %lu.", param.get_size(), this.array_size);
                }
                for (int i = 0; i < param.get_size(); ++i) {
                    Param_Types.Module_Parameter curr = param.get_elem(i);
                    if (curr.get_type() == Param_Types.Module_Parameter.type_t.MP_NotUsed) continue;
                    this.array_elements[i].set_param(curr);
                }
                break;
            }
            case MP_Indexed_List: {
                for (int i = 0; i < param.get_size(); ++i) {
                    Param_Types.Module_Parameter curr = param.get_elem(i);
                    this.array_elements[curr.get_id().get_index()].set_param(curr);
                }
                break;
            }
            default: {
                param.type_error("array value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        if (param_name.next_name()) {
            String param_field = param_name.get_current_name();
            if (param_field.charAt(0) < '0' || param_field.charAt(0) > '9') {
                throw new TtcnError("Unexpected record field name in module parameter reference, expected a valid array index");
            }
            int param_index = Integer.parseInt(param_field);
            if (param_index >= this.array_size) {
                throw new TtcnError(MessageFormat.format("Invalid array index: {0}. The array only has {1} elements.", param_index, this.array_size));
            }
            return this.array_elements[param_index].get_param(param_name);
        }
        ArrayList<Param_Types.Module_Parameter> values = new ArrayList<Param_Types.Module_Parameter>();
        for (int i = 0; i < this.array_size; ++i) {
            values.add(this.array_elements[i].get_param(param_name));
        }
        Param_Types.Module_Param_Value_List mp = new Param_Types.Module_Param_Value_List();
        mp.add_list_with_implicit_ids(values);
        values.clear();
        return mp;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        for (int i = 0; i < this.array_size; ++i) {
            this.array_elements[i].encode_text(text_buf);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        for (int i = 0; i < this.array_size; ++i) {
            this.array_elements[i].decode_text(text_buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok, false);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type {0}", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type {0}", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!(this.is_bound() || null != p_td.json && p_td.json.isMetainfo_unbound())) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound array value.", new Object[0]);
            return -1;
        }
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_START, null);
        for (int i = 0; i < this.array_size; ++i) {
            if (null != p_td.json && p_td.json.isMetainfo_unbound() && !this.array_elements[i].is_bound()) {
                enc_len += p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START, null);
                enc_len += p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME, "metainfo []");
                enc_len += p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, "\"unbound\"");
                enc_len += p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END, null);
                continue;
            }
            int ret_val = this.array_elements[i].JSON_encode(this.get_elem_descr(), p_tok, false);
            if (0 > ret_val) break;
            enc_len += ret_val;
        }
        return enc_len += p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END, null);
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        int dec_len = p_tok.get_next_token(token, null, null);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_START != token.get()) {
            return -1;
        }
        for (int i = 0; i < this.array_size; ++i) {
            int ret_val2;
            int buf_pos = p_tok.get_buf_pos();
            if (null != p_td.json && p_td.json.isMetainfo_unbound()) {
                int ret_val = p_tok.get_next_token(token, null, null);
                if (JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_START == token.get()) {
                    StringBuilder value = new StringBuilder();
                    AtomicInteger value_len = new AtomicInteger(0);
                    ret_val += p_tok.get_next_token(token, value, value_len);
                    if (JSON_Tokenizer.json_token_t.JSON_TOKEN_NAME == token.get() && 11 == value_len.get() && "metainfo []".equals(value.toString())) {
                        ret_val += p_tok.get_next_token(token, value, value_len);
                        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get() && 9 == value_len.get() && "\"unbound\"".equals(value.toString())) {
                            ret_val = p_tok.get_next_token(token, null, null);
                            if (JSON_Tokenizer.json_token_t.JSON_TOKEN_OBJECT_END == token.get()) {
                                dec_len += ret_val;
                                continue;
                            }
                        }
                    }
                }
                p_tok.set_buf_pos(buf_pos);
            }
            if (-1 == (ret_val2 = this.array_elements[i].JSON_decode(this.get_elem_descr(), p_tok, p_silent, false))) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON token, expecting %d more JSON value%s", this.array_size - i, this.array_size - i > 1 ? "s" : "");
                return -2;
            }
            if (-2 == ret_val2) {
                if (p_silent) {
                    this.clean_up();
                }
                return -2;
            }
            dec_len += ret_val2;
        }
        dec_len += p_tok.get_next_token(token, null, null);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ARRAY_END != token.get()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON token, expecting JSON array end mark%s", "");
            if (p_silent) {
                this.clean_up();
            }
            return -2;
        }
        return dec_len;
    }

    protected Base_Type.TTCN_Typedescriptor get_elem_descr() {
        throw new TtcnError("TitanValue_Array.get_elem_descr() must be overriden");
    }

    public TitanAlt_Status done(TitanVerdictType value_redirect, Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status returnValue = ((TitanComponent)this.array_elements[i]).done(value_redirect, index_redirect);
            if (returnValue == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexOffset);
                }
                result = returnValue;
                break;
            }
            if (returnValue != TitanAlt_Status.ALT_REPEAT && (returnValue != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = returnValue;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    public TitanAlt_Status killed(Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        TitanAlt_Status result = TitanAlt_Status.ALT_NO;
        for (int i = 0; i < this.array_size; ++i) {
            TitanAlt_Status returnValue = ((TitanComponent)this.array_elements[i]).killed(index_redirect);
            if (returnValue == TitanAlt_Status.ALT_YES) {
                if (index_redirect != null) {
                    index_redirect.add_index(i + this.indexOffset);
                }
                result = returnValue;
                break;
            }
            if (returnValue != TitanAlt_Status.ALT_REPEAT && (returnValue != TitanAlt_Status.ALT_MAYBE || result != TitanAlt_Status.ALT_NO)) continue;
            result = returnValue;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return result;
    }

    public boolean running(Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        boolean returnValue = false;
        for (int i = 0; i < this.array_size; ++i) {
            returnValue = ((TitanComponent)this.array_elements[i]).alive(index_redirect);
            if (!returnValue) continue;
            if (index_redirect == null) break;
            index_redirect.add_index(i + this.indexOffset);
            break;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return returnValue;
    }

    public boolean alive(Index_Redirect index_redirect) {
        if (index_redirect != null) {
            index_redirect.incr_pos();
        }
        boolean returnValue = false;
        for (int i = 0; i < this.array_size; ++i) {
            returnValue = ((TitanComponent)this.array_elements[i]).alive(index_redirect);
            if (!returnValue) continue;
            if (index_redirect == null) break;
            index_redirect.add_index(i + this.indexOffset);
            break;
        }
        if (index_redirect != null) {
            index_redirect.decr_pos();
        }
        return returnValue;
    }
}

