/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public abstract class BaseMessage
extends MSCNode {
    private Lifeline startLifeline = null;
    private Lifeline endLifeline = null;
    protected static final int LEFT = -1;
    protected static final int RIGHT = 1;

    protected BaseMessage(int eventOccurrence) {
        super(eventOccurrence);
    }

    public int getLineStyle() {
        return 1;
    }

    @Override
    public int getX() {
        if (this.startLifeline == null) {
            return -1;
        }
        return this.startLifeline.getX();
    }

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.getStartOccurrence() + 5;
    }

    @Override
    public int getWidth() {
        if (this.startLifeline == null) {
            return -1;
        }
        int width = 0;
        width = this.startLifeline == this.endLifeline ? MSCConstants.COLUMN_WIDTH : this.endLifeline.getX() - this.startLifeline.getX();
        return width;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 10;
    }

    @Override
    public boolean isVisible(int vx, int vy, int vwidth, int vheight) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        if (width < 0) {
            width = -width;
            x -= width;
        }
        int height = this.getHeight();
        return x + width >= vx && x <= vx + vwidth && y + height >= vy && y <= vy + vheight;
    }

    public void setStartLifeline(Lifeline lifeline) {
        this.startLifeline = lifeline;
        if (this.getEndLifeline() == null) {
            this.eventOccurrence = this.getStartLifeline().getEventOccurrence();
        }
    }

    public Lifeline getStartLifeline() {
        return this.startLifeline;
    }

    public void setEndLifeline(Lifeline lifeline) {
        this.endLifeline = lifeline;
        if (this.getStartLifeline() == null) {
            this.eventOccurrence = this.getEndLifeline().getEventOccurrence();
        }
    }

    public Lifeline getEndLifeline() {
        return this.endLifeline;
    }

    @Override
    public boolean contains(int oldX, int oldY) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        return MSCNode.contains(x, y, width, height, oldX, oldY);
    }

    @Override
    public void draw(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        context.setLineWidth(1);
        context.setLineStyle(this.getLineStyle());
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline) {
            context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
            int xLeft = x;
            int xRight = x + 20;
            int yTop = y + (height - 20) / 2;
            int yBottom = y + 20 + (height - 20) / 2;
            context.drawLine(xLeft, yTop, xRight, yTop);
            context.drawLine(xRight, yTop, xRight, yBottom);
            context.drawLine(xRight, yBottom, xLeft, yBottom);
            this.drawSymbol(context, xLeft, xRight, yTop, yBottom, -1);
            context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
            context.setFont((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"));
            context.drawTextTruncatedCentred(this.getName(), x + 20 + 5, y, width - 20 - 10, height, true);
        } else if (this.startLifeline != null && this.endLifeline != null) {
            context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_SOFT_BLUE"));
            context.drawLine(x, y + height, x + width, y + height);
            int spaceBTWStartEnd = this.endLifeline.getX() - this.startLifeline.getX();
            int direction = 1;
            if (spaceBTWStartEnd < 0) {
                direction = -1;
            }
            this.drawSymbol(context, x + width, y + height, direction);
            context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
            context.setFont((Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"));
            if (spaceBTWStartEnd > 0) {
                context.drawTextTruncatedCentred(this.getName(), x, y, width, height, true);
            } else {
                context.drawTextTruncatedCentred(this.getName(), x + width, y, -width, height, true);
            }
        }
    }

    public abstract void drawSymbol(IGC var1, int var2, int var3, int var4);

    public abstract void drawSymbol(IGC var1, int var2, int var3, int var4, int var5, int var6);

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return true;
    }
}

