/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.ProjectMetric;
import org.eclipse.titanium.metrics.Risks;
import org.eclipse.titanium.metrics.Statistics;
import org.eclipse.titanium.metrics.TestcaseMetric;
import org.eclipse.titanium.metrics.implementation.Metrics;
import org.eclipse.titanium.metrics.utils.RiskLevel;

public class MetricData {
    final IProject project;
    final MutableMetricData data;

    private MetricData(IProject project, MutableMetricData data) {
        this.project = project;
        this.data = data;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<Module> getModules() {
        return this.data.modules;
    }

    public Map<Module, List<Def_Function>> getFunctions() {
        return this.data.functions;
    }

    public Map<Module, List<Def_Testcase>> getTestcases() {
        return this.data.testcases;
    }

    public Map<Module, List<Def_Altstep>> getAltsteps() {
        return this.data.altsteps;
    }

    public Risks getRisks() {
        return this.data.risks;
    }

    public Number get(AltstepMetric metric, Def_Altstep altstep) {
        return this.data.altstepMetrics.get(metric).get(altstep);
    }

    public Number get(FunctionMetric metric, Def_Function function) {
        return this.data.functionMetrics.get(metric).get(function);
    }

    public Number get(TestcaseMetric metric, Def_Testcase testcase) {
        return this.data.testcaseMetrics.get(metric).get(testcase);
    }

    public double getRiskValue(AltstepMetric metric, Def_Altstep altstep) {
        return this.data.risks.getRisk(metric).getRiskValue(this.get(metric, altstep));
    }

    public double getRiskValue(FunctionMetric metric, Def_Function function) {
        return this.data.risks.getRisk(metric).getRiskValue(this.get(metric, function));
    }

    public double getRiskValue(TestcaseMetric metric, Def_Testcase testcase) {
        return this.data.risks.getRisk(metric).getRiskValue(this.get(metric, testcase));
    }

    public RiskLevel getRisk(AltstepMetric metric, Def_Altstep altstep) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.get(metric, altstep));
    }

    public RiskLevel getRisk(FunctionMetric metric, Def_Function function) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.get(metric, function));
    }

    public RiskLevel getRisk(TestcaseMetric metric, Def_Testcase testcase) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.get(metric, testcase));
    }

    public Number get(ModuleMetric metric, Module module) {
        return this.data.moduleMetrics.get(metric).get(module);
    }

    public Number getHighestRiskCauser(AltstepMetric metric, Module module) {
        return this.data.altstepModuleStats.get(metric).get(module).getHighestRisk();
    }

    public Number getHighestRiskCauser(FunctionMetric metric, Module module) {
        return this.data.functionModuleStats.get(metric).get(module).getHighestRisk();
    }

    public Number getHighestRiskCauser(TestcaseMetric metric, Module module) {
        return this.data.testcaseModuleStats.get(metric).get(module).getHighestRisk();
    }

    public double getRiskValue(ModuleMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskValue(this.get(metric, module));
    }

    public double getRiskValue(AltstepMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric, module));
    }

    public double getRiskValue(FunctionMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric, module));
    }

    public double getRiskValue(TestcaseMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric, module));
    }

    public RiskLevel getRisk(ModuleMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.get(metric, module));
    }

    public RiskLevel getRisk(AltstepMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric, module));
    }

    public RiskLevel getRisk(FunctionMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric, module));
    }

    public RiskLevel getRisk(TestcaseMetric metric, Module module) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric, module));
    }

    public Number get(ProjectMetric metric) {
        return this.data.projectMetrics.get(metric);
    }

    public Number getHighestRiskCauser(ModuleMetric metric) {
        return this.data.moduleProjectStats.get(metric).getHighestRisk();
    }

    public Number getHighestRiskCauser(AltstepMetric metric) {
        return this.data.altstepProjectStats.get(metric).getHighestRisk();
    }

    public Number getHighestRiskCauser(FunctionMetric metric) {
        return this.data.functionProjectStats.get(metric).getHighestRisk();
    }

    public Number getHighestRiskCauser(TestcaseMetric metric) {
        return this.data.testcaseProjectStats.get(metric).getHighestRisk();
    }

    public double getRiskValue(ProjectMetric metric) {
        return this.data.risks.getRisk(metric).getRiskValue(this.get(metric));
    }

    public double getRiskValue(ModuleMetric metric) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric));
    }

    public double getRiskValue(AltstepMetric metric) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric));
    }

    public double getRiskValue(FunctionMetric metric) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric));
    }

    public double getRiskValue(TestcaseMetric metric) {
        return this.data.risks.getRisk(metric).getRiskValue(this.getHighestRiskCauser(metric));
    }

    public RiskLevel getRisk(ProjectMetric metric) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.get(metric));
    }

    public RiskLevel getRisk(ModuleMetric metric) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric));
    }

    public RiskLevel getRisk(AltstepMetric metric) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric));
    }

    public RiskLevel getRisk(FunctionMetric metric) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric));
    }

    public RiskLevel getRisk(TestcaseMetric metric) {
        return this.data.risks.getRisk(metric).getRiskLevel(this.getHighestRiskCauser(metric));
    }

    public Statistics getStatistics(AltstepMetric metric, Module module) {
        return this.data.altstepModuleStats.get(metric).get(module);
    }

    public Statistics getStatistics(FunctionMetric metric, Module module) {
        return this.data.functionModuleStats.get(metric).get(module);
    }

    public Statistics getStatistics(TestcaseMetric metric, Module module) {
        return this.data.testcaseModuleStats.get(metric).get(module);
    }

    public Statistics getStatistics(AltstepMetric metric) {
        return this.data.altstepProjectStats.get(metric);
    }

    public Statistics getStatistics(FunctionMetric metric) {
        return this.data.functionProjectStats.get(metric);
    }

    public Statistics getStatistics(TestcaseMetric metric) {
        return this.data.testcaseProjectStats.get(metric);
    }

    public Statistics getStatistics(ModuleMetric metric) {
        return this.data.moduleProjectStats.get(metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricData measure(IProject project) {
        IProject iProject = project;
        synchronized (iProject) {
            Statistics projectStats;
            ProjectSourceParser parser = GlobalParser.getProjectSourceParser((IProject)project);
            Risks risks = new Risks();
            MutableMetricData data = new MutableMetricData(risks);
            ArrayList<Module> modules = new ArrayList<Module>();
            HashMap<Module, ArrayList<Def_Function>> functions = new HashMap<Module, ArrayList<Def_Function>>();
            HashMap<Module, ArrayList<Def_Testcase>> testcases = new HashMap<Module, ArrayList<Def_Testcase>>();
            HashMap<Module, ArrayList<Def_Altstep>> altsteps = new HashMap<Module, ArrayList<Def_Altstep>>();
            for (String modName : parser.getKnownModuleNames()) {
                Module module = parser.getModuleByName(modName);
                modules.add(module);
            }
            for (Module module : modules) {
                ArrayList<Def_Function> funs = new ArrayList<Def_Function>();
                ArrayList<Def_Testcase> tcs = new ArrayList<Def_Testcase>();
                ArrayList<Def_Altstep> als = new ArrayList<Def_Altstep>();
                module.accept((ASTVisitor)new DefinitionCollector(funs, tcs, als));
                functions.put(module, funs);
                testcases.put(module, tcs);
                altsteps.put(module, als);
            }
            data.modules = Collections.unmodifiableList(modules);
            data.functions = Collections.unmodifiableMap(functions);
            data.testcases = Collections.unmodifiableMap(testcases);
            data.altsteps = Collections.unmodifiableMap(altsteps);
            MetricData immutableData = new MetricData(project, data);
            Metrics metrics = new Metrics();
            for (AltstepMetric altstepMetric : AltstepMetric.values()) {
                metrics.get(altstepMetric).init(immutableData);
            }
            for (Enum enum_ : FunctionMetric.values()) {
                metrics.get((FunctionMetric)enum_).init(immutableData);
            }
            for (Enum enum_ : TestcaseMetric.values()) {
                metrics.get((TestcaseMetric)enum_).init(immutableData);
            }
            for (Enum enum_ : ModuleMetric.values()) {
                metrics.get((ModuleMetric)enum_).init(immutableData);
            }
            for (Enum enum_ : ProjectMetric.values()) {
                metrics.get((ProjectMetric)enum_).init(immutableData);
            }
            for (Enum enum_ : AltstepMetric.values()) {
                projectStats = MetricData.measureEntities(data.altsteps, metrics.get((AltstepMetric)enum_), immutableData, data.altstepMetrics, data.altstepModuleStats);
                data.altstepProjectStats.put((AltstepMetric)enum_, projectStats);
                immutableData = new MetricData(project, data);
            }
            for (Enum enum_ : FunctionMetric.values()) {
                projectStats = MetricData.measureEntities(data.functions, metrics.get((FunctionMetric)enum_), immutableData, data.functionMetrics, data.functionModuleStats);
                data.functionProjectStats.put((FunctionMetric)enum_, projectStats);
                immutableData = new MetricData(project, data);
            }
            for (Enum enum_ : TestcaseMetric.values()) {
                projectStats = MetricData.measureEntities(data.testcases, metrics.get((TestcaseMetric)enum_), immutableData, data.testcaseMetrics, data.testcaseModuleStats);
                data.testcaseProjectStats.put((TestcaseMetric)enum_, projectStats);
                immutableData = new MetricData(project, data);
            }
            for (Enum enum_ : ModuleMetric.values()) {
                HashMap<Module, Number> metricResults = new HashMap<Module, Number>();
                int numberOfModules = data.modules.size();
                double[] projectLevelResults = new double[numberOfModules];
                int projectLevelCounter = 0;
                for (Module module : data.modules) {
                    Number result = metrics.get((ModuleMetric)enum_).measure(immutableData, module);
                    projectLevelResults[projectLevelCounter++] = result.doubleValue();
                    metricResults.put(module, result);
                }
                data.moduleMetrics.put((ModuleMetric)enum_, metricResults);
                data.moduleProjectStats.put((ModuleMetric)enum_, new Statistics(projectLevelResults, (IMetricEnum)((Object)enum_), risks.getRisk((IMetricEnum)((Object)enum_))));
            }
            for (Enum enum_ : ProjectMetric.values()) {
                Number result = metrics.get((ProjectMetric)enum_).measure(immutableData, project);
                data.projectMetrics.put((ProjectMetric)enum_, result);
            }
            return immutableData;
        }
    }

    static <ENTITY, METRIC extends IMetricEnum> Statistics measureEntities(Map<Module, List<ENTITY>> entities, IMetric<ENTITY, METRIC> metric, MetricData currentData, Map<METRIC, Map<ENTITY, Number>> metricResults, Map<METRIC, Map<Module, Statistics>> moduleStats) {
        int numberOfEntities = 0;
        for (List<ENTITY> entitylist : entities.values()) {
            numberOfEntities += entitylist.size();
        }
        HashMap<ENTITY, Number> myMetricResults = new HashMap<ENTITY, Number>();
        HashMap<Module, Statistics> myModuleStats = new HashMap<Module, Statistics>();
        double[] projectLevelResults = new double[numberOfEntities];
        int projectLevelCounter = 0;
        for (Map.Entry<Module, List<ENTITY>> entry : entities.entrySet()) {
            Module module = entry.getKey();
            List<ENTITY> entitiesOfModule = entry.getValue();
            int moduleLevelCounter = 0;
            double[] moduleLevelResults = new double[entitiesOfModule.size()];
            for (ENTITY entity : entitiesOfModule) {
                Number result = metric.measure(currentData, entity);
                moduleLevelResults[moduleLevelCounter++] = result.doubleValue();
                projectLevelResults[projectLevelCounter++] = result.doubleValue();
                myMetricResults.put(entity, result);
            }
            myModuleStats.put(module, new Statistics(moduleLevelResults, (IMetricEnum)metric.getMetric(), currentData.getRisks().getRisk((IMetricEnum)metric.getMetric())));
        }
        metricResults.put(metric.getMetric(), myMetricResults);
        moduleStats.put(metric.getMetric(), myModuleStats);
        return new Statistics(projectLevelResults, (IMetricEnum)metric.getMetric(), currentData.getRisks().getRisk((IMetricEnum)metric.getMetric()));
    }

    private static class DefinitionCollector
    extends ASTVisitor {
        private final List<Def_Function> funs;
        private final List<Def_Testcase> tcs;
        private final List<Def_Altstep> als;

        public DefinitionCollector(List<Def_Function> functions, List<Def_Testcase> testcases, List<Def_Altstep> altsteps) {
            this.tcs = testcases;
            this.funs = functions;
            this.als = altsteps;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_Function) {
                this.funs.add((Def_Function)node);
                return 1;
            }
            if (node instanceof Def_Testcase) {
                this.tcs.add((Def_Testcase)node);
                return 1;
            }
            if (node instanceof Def_Altstep) {
                this.als.add((Def_Altstep)node);
                return 1;
            }
            return 3;
        }
    }

    private static class MutableMetricData {
        List<Module> modules = null;
        Map<Module, List<Def_Function>> functions = null;
        Map<Module, List<Def_Testcase>> testcases = null;
        Map<Module, List<Def_Altstep>> altsteps = null;
        Map<AltstepMetric, Map<Def_Altstep, Number>> altstepMetrics = new HashMap<AltstepMetric, Map<Def_Altstep, Number>>();
        Map<AltstepMetric, Map<Module, Statistics>> altstepModuleStats = new HashMap<AltstepMetric, Map<Module, Statistics>>();
        Map<AltstepMetric, Statistics> altstepProjectStats = new HashMap<AltstepMetric, Statistics>();
        Map<FunctionMetric, Map<Def_Function, Number>> functionMetrics = new HashMap<FunctionMetric, Map<Def_Function, Number>>();
        Map<FunctionMetric, Map<Module, Statistics>> functionModuleStats = new HashMap<FunctionMetric, Map<Module, Statistics>>();
        Map<FunctionMetric, Statistics> functionProjectStats = new HashMap<FunctionMetric, Statistics>();
        Map<TestcaseMetric, Map<Def_Testcase, Number>> testcaseMetrics = new HashMap<TestcaseMetric, Map<Def_Testcase, Number>>();
        Map<TestcaseMetric, Map<Module, Statistics>> testcaseModuleStats = new HashMap<TestcaseMetric, Map<Module, Statistics>>();
        Map<TestcaseMetric, Statistics> testcaseProjectStats = new HashMap<TestcaseMetric, Statistics>();
        Map<ModuleMetric, Map<Module, Number>> moduleMetrics = new HashMap<ModuleMetric, Map<Module, Number>>();
        Map<ModuleMetric, Statistics> moduleProjectStats = new HashMap<ModuleMetric, Statistics>();
        Map<ProjectMetric, Number> projectMetrics = new HashMap<ProjectMetric, Number>();
        Risks risks;

        public MutableMetricData(Risks risks) {
            this.risks = risks;
        }
    }
}

