/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.path;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.Cygwin;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.ui.PlatformUI;

public final class PathConverter {
    private static final String EXECUTION_FAILED = " execution failed";
    private static final String INTERRUPTION = " execution failed beacuse of interrupion";
    private static final ConcurrentHashMap<String, String> CYGWINPATHMAP = new ConcurrentHashMap();
    private static boolean inHeadLessMode = !PlatformUI.isWorkbenchRunning();

    private PathConverter() {
    }

    public static String convert(String path, boolean reportDebugInformation, StringBuilder output) {
        Process proc;
        if ("".equals(path.trim())) {
            ErrorReporter.logWarning("The empty path could not be converted");
            return path;
        }
        if (!"win32".equals(Platform.getOS())) {
            return path;
        }
        if (!Cygwin.isInstalled()) {
            return path;
        }
        if (CYGWINPATHMAP.containsKey(path)) {
            return CYGWINPATHMAP.get(path);
        }
        List<String> finalCommand = Arrays.asList("sh", "-c", "cygpath -u '" + path + '\'');
        PathConverter.printCommandToDebugConsole(reportDebugInformation, output, finalCommand);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(finalCommand);
        try {
            proc = pb.start();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("The process could not be started due to I/O exception", e);
            return path;
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace("The process could not be started due to other reason", e);
            return path;
        }
        return PathConverter.processOutput(path, output, proc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processOutput(String path, StringBuilder output, Process proc) {
        BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));
        try {
            StringBuilder solution = new StringBuilder();
            String line = stdout.readLine();
            while (line != null) {
                PathConverter.printDebug(output, line);
                solution.append(line);
                line = stdout.readLine();
            }
            int exitValue = proc.waitFor();
            if (exitValue != 0) {
                ErrorReporter.logError("The path:`" + path + "' could not be converted");
                String string = path;
                return string;
            }
            String temp = solution.toString();
            CYGWINPATHMAP.put(path, temp);
            String string = temp;
            return string;
        }
        catch (IOException e) {
            PathConverter.printDebug(output, EXECUTION_FAILED);
            ErrorReporter.logExceptionStackTrace("Cygwin conversion result could not be read", e);
        }
        catch (InterruptedException e) {
            PathConverter.printDebug(output, INTERRUPTION);
            ErrorReporter.logExceptionStackTrace("Conversion of " + path + " interrupted", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stdout);
        }
        return path;
    }

    private static void printDebug(StringBuilder output, String line) {
        if (inHeadLessMode) {
            return;
        }
        output.append(line);
    }

    public static String getAbsolutePath(String baseFile, String file) {
        Path filePath = new Path(file);
        if (filePath.isAbsolute()) {
            return file;
        }
        Path baseFilePath = new Path(baseFile);
        IPath baseDirPath = baseFilePath.makeAbsolute().removeLastSegments(1);
        return baseDirPath.append((IPath)filePath).makeAbsolute().toOSString();
    }

    public static IPath getProjectRelativePath(IFile aBaseFile, String aFile) {
        Path filePath = new Path(aFile);
        IPath baseFilePath = aBaseFile.getProjectRelativePath();
        IPath baseDirPath = baseFilePath.removeLastSegments(1);
        return baseDirPath.append((IPath)filePath);
    }

    private static void printCommandToDebugConsole(boolean reportDebugInformation, StringBuilder output, List<String> command) {
        if (inHeadLessMode) {
            return;
        }
        if (reportDebugInformation) {
            StringBuilder builder = new StringBuilder();
            for (String c : command) {
                builder.append(c).append(' ');
            }
            output.append((CharSequence)builder);
        }
    }
}

