/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.SelectionUtils;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ResourceListener
implements IResourceChangeListener {
    private void closeMSCWindows(final IResource resource) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench == null) {
                    return;
                }
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage != null) {
                    IViewReference[] viewReferences = activePage.getViewReferences();
                    ActionUtils.closeAssociatedViews(activePage, viewReferences, resource);
                }
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.handlePostChange(event);
                break;
            }
            case 4: {
                IResource delResource = event.getResource();
                this.handlePreDeleteProject(delResource);
                break;
            }
            case 2: {
                IResource closeResource = event.getResource();
                this.handlePreCloseProject(closeResource);
                break;
            }
        }
    }

    private boolean changeInLogViewerProject(IResource resource) {
        try {
            if (resource != null && resource.getProject().hasNature("org.eclipse.titan.log.viewer.TitanLogProject")) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private void handlePreDeleteProject(IResource resource) {
        if (!this.changeInLogViewerProject(resource)) {
            return;
        }
        IProject project = resource.getProject();
        this.closeMSCWindows((IResource)project);
    }

    private void handlePreCloseProject(IResource resource) {
        if (!this.changeInLogViewerProject(resource)) {
            return;
        }
        IProject project = resource.getProject();
        this.closeMSCWindows((IResource)project);
    }

    private void handlePostChange(IResourceChangeEvent event) {
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta == null) {
            return;
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getKind() != 2) {
                    return true;
                }
                IResource resource = delta.getResource();
                if (!ResourceListener.this.changeInLogViewerProject(resource)) {
                    return true;
                }
                switch (resource.getType()) {
                    case 1: {
                        IFile file = (IFile)resource;
                        if (SelectionUtils.hasLogFileExtension(file)) {
                            ResourceListener.this.closeMSCWindows((IResource)file);
                        }
                        return false;
                    }
                    case 2: {
                        IFolder folder = (IFolder)resource;
                        ResourceListener.this.closeMSCWindows((IResource)folder);
                        return false;
                    }
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            String messageText = Messages.getString("ResourceListener.0") + ' ' + e.getMessage();
            TitanLogExceptionHandler.handleException(new TechnicalException(messageText));
        }
    }
}

