/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PortScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Value_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Receive_Port_Statement
extends Statement {
    private static final String MESSAGEBASEOPERATIONONPROCEDUREPORT = "Massage-based operation `{0}'' is not applicable to a procedure-based port of type `{1}''";
    private static final String NOINCOMINGMESSAGETYPES = "Port type `{0}'' does not have any incoming message types";
    private static final String VALUEREDIRECTWITHOUTRECEIVEPARAMETER = "Value redirect cannot be used without receive parameter";
    private static final String RECEIVEONPORT = "Message-based operation `{0}'' is not applicable to a procedure-based port of type `{1}''";
    private static final String UNKNOWNINCOMINGMESSAGE = "Cannot determine the type of the incoming message";
    private static final String TYPENOTPRESENT = "Message type `{0}'' is not present on the incoming list of port of type `{1}''";
    private static final String TYPEISAMBIGUOUS = "The type of the message is ambiguous: `{0}'' is compatible with more than one incoming message types of port type `{1}''";
    private static final String ANYPORTWITHPARAMETER = "Operation `any port.{0}'' cannot have parameter";
    private static final String RECEIVEWITHVALUEREDIRECT = "Operation `any port.{0}'' cannot have value redirect";
    private static final String RECEIVEWITHINDEXREDIRECT = "Operation `any port.{0}'' cannot have index redirect";
    private static final String ANYOROMITWITHOUTMATCHINGTAMPLE = "''*'' cannot be used as a matching template for a `{0}'' operation";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".receiveparameter";
    private static final String FULLNAMEPART3 = ".from";
    private static final String FULLNAMEPART4 = ".redirectvalue";
    private static final String FULLNAMEPART5 = ".redirectsender";
    private static final String FULLNAMEPART6 = ".redirectIndex";
    private static final String FULLNAMEPART7 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "receive";
    private final Reference portReference;
    private final boolean anyFrom;
    private final boolean translate;
    private final TemplateInstance receiveParameter;
    private final TemplateInstance fromClause;
    private final Value_Redirection redirectValue;
    private final Reference redirectSender;
    private final Reference redirectIndex;
    private final Reference redirectTimestamp;

    public Receive_Port_Statement(Reference portReference, boolean anyFrom, TemplateInstance receiveParameter, TemplateInstance fromClause, Value_Redirection redirectValue, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp, boolean translate) {
        this.portReference = portReference;
        this.anyFrom = anyFrom;
        this.translate = translate;
        this.receiveParameter = receiveParameter;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectSender = redirectSender;
        this.redirectIndex = redirectIndex;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (receiveParameter != null) {
            receiveParameter.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    public Reference getPort() {
        return this.portReference;
    }

    public Port_Type getPortType() {
        return Port_Utility.checkPortReference(CompilationTimeStamp.getBaseTimestamp(), this, this.portReference, this.anyFrom);
    }

    public Value_Redirection getRedirectValue() {
        return this.redirectValue;
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_RECEIVE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.receiveParameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.redirectIndex == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.redirectTimestamp == child) {
            return builder.append(FULLNAMEPART7);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null && !this.translate) {
            this.portReference.setMyScope(scope);
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null && !this.translate) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.setCodeSection(codeSection);
        }
        if (this.fromClause != null) {
            this.fromClause.setCodeSection(codeSection);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setCodeSection(codeSection);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Receive_Port_Statement.checkReceivingStatement(timestamp, this, STATEMENT_NAME, this.portReference, this.anyFrom, this.translate, this.receiveParameter, this.fromClause, this.redirectValue, this.redirectSender, this.redirectIndex, this.redirectTimestamp);
        if (this.redirectValue != null) {
            // empty if block
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkReceivingStatement(CompilationTimeStamp timestamp, Statement origin, String statementName, Reference portReference, boolean anyFrom, boolean translate, TemplateInstance receiveParameter, TemplateInstance fromClause, Value_Redirection redirectValue, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp) {
        Port_Type portType;
        block31: {
            boolean messageTypeDetermined;
            IType messageType;
            block29: {
                block32: {
                    block30: {
                        if (translate) {
                            PortScope ps = origin.getMyStatementBlock().getScopePort();
                            if (ps == null) {
                                origin.getLocation().reportSemanticError("Cannot determine the type of the port: Missing port clause on the function.");
                                return;
                            }
                            portType = ps.getPortType();
                        } else {
                            portType = Port_Utility.checkPortReference(timestamp, origin, portReference, anyFrom);
                        }
                        if (receiveParameter != null) break block30;
                        if (portType != null && IType.Type_type.TYPE_PORT.equals((Object)portType.getTypetype())) {
                            PortTypeBody body = portType.getPortBody();
                            if (PortTypeBody.OperationModes.OP_Procedure.equals((Object)body.getOperationMode())) {
                                portReference.getLocation().reportSemanticError(MessageFormat.format(MESSAGEBASEOPERATIONONPROCEDUREPORT, statementName, portType.getTypename()));
                            } else if (body.getInMessages() == null) {
                                portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGMESSAGETYPES, portType.getTypename()));
                            }
                        }
                        if (redirectValue != null) {
                            redirectValue.getLocation().reportSemanticError(VALUEREDIRECTWITHOUTRECEIVEPARAMETER);
                            redirectValue.checkErroneous(timestamp);
                        }
                        break block31;
                    }
                    messageType = null;
                    messageTypeDetermined = false;
                    if (portType == null) break block32;
                    PortTypeBody portTypeBody = portType.getPortBody();
                    TypeSet inMessages = portTypeBody.getInMessages();
                    if (PortTypeBody.OperationModes.OP_Procedure.equals((Object)portTypeBody.getOperationMode())) {
                        portReference.getLocation().reportSemanticError(MessageFormat.format(RECEIVEONPORT, statementName, portType.getTypename()));
                        break block29;
                    } else if (inMessages != null) {
                        if (inMessages.getNofTypes() == 1) {
                            messageType = inMessages.getTypeByIndex(0);
                        } else {
                            messageType = Port_Utility.getMessageSignatureType(timestamp, receiveParameter);
                            if (messageType == null) {
                                receiveParameter.getLocation().reportSemanticError(UNKNOWNINCOMINGMESSAGE);
                            } else {
                                int nofCompatibleTypes = inMessages.getNofCompatibleTypes(timestamp, messageType);
                                if (nofCompatibleTypes == 0) {
                                    receiveParameter.getLocation().reportSemanticError(MessageFormat.format(TYPENOTPRESENT, messageType.getTypename(), portType.getTypename()));
                                } else if (nofCompatibleTypes > 1) {
                                    receiveParameter.getLocation().reportSemanticError(MessageFormat.format(TYPEISAMBIGUOUS, messageType.getTypename(), portType.getTypename()));
                                }
                            }
                        }
                        messageTypeDetermined = true;
                        break block29;
                    } else {
                        portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGMESSAGETYPES, portType.getTypename()));
                    }
                    break block29;
                }
                if (portReference == null && !translate) {
                    receiveParameter.getLocation().reportSemanticError(MessageFormat.format(ANYPORTWITHPARAMETER, statementName));
                    if (redirectValue != null) {
                        redirectValue.getLocation().reportSemanticError(MessageFormat.format(RECEIVEWITHVALUEREDIRECT, statementName));
                    }
                    if (redirectIndex != null) {
                        redirectIndex.getLocation().reportSemanticError(MessageFormat.format(RECEIVEWITHINDEXREDIRECT, statementName));
                    }
                }
            }
            if (!messageTypeDetermined) {
                messageType = Port_Utility.getMessageSignatureType(timestamp, receiveParameter);
            }
            if (messageType == null) {
                if (redirectValue != null) {
                    redirectValue.checkErroneous(timestamp);
                }
            } else {
                receiveParameter.check(timestamp, messageType);
                if (redirectValue != null) {
                    redirectValue.check(timestamp, messageType);
                }
            }
            if (receiveParameter.getTemplateBody().getTemplateReferencedLast(timestamp).getTemplatetype() == ITTCN3Template.Template_type.ANY_OR_OMIT) {
                receiveParameter.getLocation().reportSemanticError(MessageFormat.format(ANYOROMITWITHOUTMATCHINGTAMPLE, statementName));
            }
        }
        Port_Utility.checkFromClause(timestamp, origin, portType, fromClause, redirectSender);
        if (redirectIndex != null && portReference != null) {
            Assignment assignment = portReference.getRefdAssignment(timestamp, false);
            Receive_Port_Statement.checkIndexRedirection(timestamp, redirectIndex, assignment == null ? null : ((Def_Port)assignment).getDimensions(), anyFrom, "port");
        }
        Port_Utility.checkTimestampRedirect(timestamp, portType, redirectTimestamp);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(145);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(253);
        if (this.fromClause != null) {
            return result;
        }
        result.add(62);
        if (this.receiveParameter != null) {
            return result;
        }
        result.add(297);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.receiveParameter.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.receiveParameter != null) {
            this.receiveParameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.receiveParameter != null && !this.receiveParameter.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        if (this.redirectSender != null && !this.redirectSender.accept(v)) {
            return false;
        }
        if (this.redirectIndex != null && !this.redirectIndex.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        if (this.portReference != null || this.translate) {
            if (this.translate) {
                expression.expression.append("receive(");
            } else {
                this.portReference.generateCode(aData, expression);
                expression.expression.append(".receive(");
            }
            if (this.receiveParameter != null) {
                boolean hasDecodedRedirect = this.redirectValue != null && this.redirectValue.hasDecodedModifier();
                int expressionStart = expression.expression.length();
                this.receiveParameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE, hasDecodedRedirect);
                String lastGenExpression = expression.expression.substring(expressionStart);
                expression.expression.append(", ");
                if (this.redirectValue == null) {
                    expression.expression.append("null");
                } else {
                    this.redirectValue.generateCode(aData, expression, this.receiveParameter, lastGenExpression);
                }
                expression.expression.append(", ");
            }
        } else {
            aData.addBuiltinTypeImport("TitanPort");
            expression.expression.append("TitanPort.any_receive(");
        }
        if (this.fromClause != null) {
            this.fromClause.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        } else if (this.redirectSender != null) {
            IType varType = this.redirectSender.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
            if (varType == null) {
                ErrorReporter.INTERNAL_ERROR((String)("Encountered a redirection with unknown type `" + this.getFullName() + "''"));
            }
            if (varType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_COMPONENT) {
                aData.addBuiltinTypeImport("TitanComponent_template");
                expression.expression.append("TitanComponent_template.any_compref");
            } else {
                expression.expression.append(MessageFormat.format("new {0}(template_sel.ANY_VALUE)", varType.getGenNameTemplate(aData, expression.expression)));
            }
        } else {
            aData.addBuiltinTypeImport("TitanComponent_template");
            expression.expression.append("TitanComponent_template.any_compref");
        }
        expression.expression.append(", ");
        if (this.redirectSender == null) {
            expression.expression.append("null");
        } else {
            this.redirectSender.generateCode(aData, expression);
        }
        expression.expression.append(", ");
        if (this.redirectTimestamp == null) {
            expression.expression.append("null");
        } else {
            this.redirectTimestamp.generateCode(aData, expression);
        }
        if (this.portReference != null || this.translate) {
            expression.expression.append(",");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Receive_Port_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
        }
        expression.expression.append(')');
    }
}

