/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.ObjectClass;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectClass_Assignment
extends ASN1Assignment {
    public static final String PARAMETERISEDOBJECTCLASS = "`{0}'' is a parameterized objectclass assignment";
    private final ObjectClass objectClass;

    public ObjectClass_Assignment(Identifier id, Ass_pard assPard, ObjectClass objectClass) {
        super(id, assPard);
        this.objectClass = objectClass;
        if (null != objectClass) {
            objectClass.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_OC;
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new ObjectClass_Assignment(identifier, null, this.objectClass.newInstance());
    }

    @Override
    public void setRightScope(Scope rightScope) {
        if (null != this.objectClass) {
            this.objectClass.setMyScope(rightScope);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.objectClass) {
            this.objectClass.setMyScope(scope);
        }
    }

    public ObjectClass getObjectClass(CompilationTimeStamp timestamp) {
        if (null != this.assPard) {
            this.location.reportSemanticError(MessageFormat.format(PARAMETERISEDOBJECTCLASS, this.getFullName()));
            return null;
        }
        this.check(timestamp);
        return this.objectClass;
    }

    @Override
    public ObjectClass getSetting(CompilationTimeStamp timestamp) {
        return this.getObjectClass(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        if (null != this.objectClass) {
            this.objectClass.setGenName(this.getGenName());
            this.objectClass.check(timestamp);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() >= index + 1 && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && null != this.objectClass) {
                this.objectClass.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            propCollector.addProposal(this.identifier, " - ObjectClass assignment", ImageCache.getImage(this.getOutlineIcon()), "ObjectClass assignment");
        } else if (subrefs.size() > index + 1 && null != this.objectClass && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.objectClass.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "information object class";
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.objectClass != null) {
            this.objectClass.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.assPard != null) {
            return true;
        }
        return this.objectClass == null || this.objectClass.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        if (this.assPard != null || this.dontGenerate) {
            return;
        }
        this.objectClass.generateCode(aData);
    }
}

