/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Bit2HexExpression
extends Expression_Value {
    private static final String OPERANDERROR = "The operand of the `bit2hex' operation should be a bitstring value";
    private final Value value;

    public Bit2HexExpression(Value value) {
        this.value = value;
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.BIT2HEX_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("bit2hex(").append(this.value.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_HEXSTRING;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType.Type_type tempType = this.value.getExpressionReturntype(timestamp, expectedValue);
        switch (tempType) {
            case TYPE_BITSTRING: {
                this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
                return;
            }
            case TYPE_UNDEFINED: {
                this.setIsErroneous(true);
                return;
            }
        }
        if (!this.isErroneous) {
            this.location.reportSemanticError(OPERANDERROR);
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        if (last.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        switch (last.getValuetype()) {
            case BITSTRING_VALUE: {
                String tempBitstring = ((Bitstring_Value)last).getValue();
                this.lastValue = new Hexstring_Value(Bit2HexExpression.bit2hex(tempBitstring));
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    public static String bit2hex(String bitString) {
        byte[] zeros = new byte[]{48, 48, 48, 48};
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String bitString1 = bitString.replaceAll(" ", "");
        int hexLength = (bitString1.length() + 3) / 4;
        StringBuilder builder = new StringBuilder(hexLength);
        byte[] bytes = bitString1.getBytes();
        int subindex = 0;
        byte[] bytes4 = new byte[hexLength * 4];
        System.arraycopy(zeros, 0, bytes4, 0, hexLength * 4 - bitString1.length());
        System.arraycopy(bytes, 0, bytes4, hexLength * 4 - bitString1.length(), bytes.length);
        for (int i = 0; i < hexLength; ++i) {
            int index = 0;
            if (bytes4.length > subindex) {
                int n = index = 49 == bytes4[subindex] ? 8 : 0;
            }
            if (bytes4.length > ++subindex) {
                index += 49 == bytes4[subindex] ? 4 : 0;
            }
            if (bytes4.length > ++subindex) {
                index += 49 == bytes4[subindex] ? 2 : 0;
            }
            if (bytes4.length > ++subindex) {
                index += 49 == bytes4[subindex] ? 1 : 0;
            }
            ++subindex;
            builder.append(digits[index]);
        }
        return builder.toString();
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this) && this.value != null) {
            referenceChain.markState();
            this.value.checkRecursions(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value == null) {
            return;
        }
        this.value.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.value == null || this.value.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("AdditionalFunctions");
        expression.expression.append("AdditionalFunctions.bit2hex( ");
        this.value.generateCodeExpressionMandatory(aData, expression, true);
        expression.expression.append(" )");
    }
}

