/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Function_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ApplyExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Invoke_Template
extends TTCN3Template {
    private static final String FUNCTIONEXPECTED = "A value of type function expected instead of `{0}''";
    private static final String TYPEMISSMATCHERROR = "Type mismatch: a value or template of type `{0}'' was expected instead of `{1}''";
    private static final String VALUEXPECTED1 = "A value of type function was expected";
    private static final String VALUEXPECTED2 = "Reference to a value was expected, but functions of type `{0}'' return a template of type `{1}''";
    private final Value value;
    private final ParsedActualParameters actualParameterList;
    private ActualParameterList actualParameter_list;

    Invoke_Template(CompilationTimeStamp timestamp, SpecificValue_Template original) {
        this.copyGeneralProperties(original);
        IValue v = original.getValue();
        if (v == null || !IValue.Value_type.EXPRESSION_VALUE.equals((Object)v.getValuetype())) {
            this.value = null;
            this.actualParameterList = null;
            return;
        }
        Expression_Value expressionValue = (Expression_Value)v;
        if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expressionValue.getOperationType())) {
            this.value = null;
            this.actualParameterList = null;
            return;
        }
        ApplyExpression expression = (ApplyExpression)expressionValue;
        this.value = expression.getValue();
        this.actualParameterList = expression.getParameters();
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_INVOKE;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous template returning invoke";
        }
        return "template returning invoke";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value.createStringRepresentation());
        builder.append(".invoke(");
        if (this.actualParameterList != null) {
            builder.append("...");
        }
        builder.append(')');
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.value == null) {
            this.setIsErroneous(true);
            return null;
        }
        IType type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type == null) {
            if (!this.value.getIsErroneous(timestamp)) {
                this.value.getLocation().reportSemanticError(VALUEXPECTED1);
            }
            this.setIsErroneous(true);
            return null;
        }
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                Type result = ((Function_Type)type).getReturnType();
                if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) && ((Function_Type)type).returnsTemplate()) {
                    this.location.reportSemanticError(MessageFormat.format(VALUEXPECTED2, type.getTypename(), result.getTypename()));
                }
                return result;
            }
            case TYPE_ALTSTEP: {
                this.setIsErroneous(true);
                return null;
            }
        }
        this.value.getLocation().reportSemanticError(MessageFormat.format(FUNCTIONEXPECTED, type.getTypename()));
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp) || this.value == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType type = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return type.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.checkInvoke(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public boolean checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit, Assignment lhs) {
        this.checkInvoke(timestamp);
        IType governor = this.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (governor == null) {
            this.setIsErroneous(true);
        } else if (!type.isCompatible(timestamp, governor, null, null, null)) {
            this.location.reportSemanticError(MessageFormat.format(TYPEMISSMATCHERROR, type.getTypename(), governor.getTypename()));
            this.setIsErroneous(true);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
        return false;
    }

    public void checkInvoke(CompilationTimeStamp timestamp) {
        if (this.getIsErroneous(timestamp) || this.actualParameterList == null || this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null) {
            if (!this.value.getIsErroneous(timestamp)) {
                this.value.getLocation().reportSemanticError("A value of type function was expected in the argument");
            }
            this.setIsErroneous(true);
            return;
        }
        if (!IType.Type_type.TYPE_FUNCTION.equals((Object)type.getTypetype())) {
            this.value.getLocation().reportSemanticError(MessageFormat.format("A value of type function was expected in the argument instead of `{0}''", type.getTypename()));
            this.setIsErroneous(true);
            return;
        }
        if (this.myScope == null) {
            return;
        }
        this.myScope.checkRunsOnScope(timestamp, type, (ILocateableNode)this, "call");
        FormalParameterList formalParameterList = ((Function_Type)type).getFormalParameters();
        this.actualParameter_list = new ActualParameterList();
        if (!formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, this.actualParameter_list)) {
            this.actualParameter_list.setFullNameParent(this);
            this.actualParameter_list.setMyScope(this.getMyScope());
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        if (this.value != null && !this.value.canGenerateSingleExpression()) {
            return false;
        }
        if (this.actualParameter_list != null) {
            FormalParameterList formalParameterList = null;
            if (this.value.getValuetype() == IValue.Value_type.FUNCTION_REFERENCE_VALUE) {
                Definition definition = ((Function_Reference_Value)this.value).getReferredFunction();
                switch (definition.getAssignmentType()) {
                    case A_FUNCTION: 
                    case A_FUNCTION_RVAL: 
                    case A_FUNCTION_RTEMP: {
                        formalParameterList = ((Def_Function)definition).getFormalParameterList();
                        break;
                    }
                    case A_EXT_FUNCTION: 
                    case A_EXT_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION_RTEMP: {
                        formalParameterList = ((Def_Extfunction)definition).getFormalParameterList();
                        break;
                    }
                }
            }
            for (int i = 0; i < this.actualParameter_list.getNofParameters(); ++i) {
                FormalParameter formalPar;
                FormalParameter formalParameter = formalPar = formalParameterList == null ? null : formalParameterList.getParameterByIndex(i);
                if (this.actualParameter_list.getParameter(i).hasSingleExpression(formalPar)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpressionInvoke(aData, expression);
        return expression.expression;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        if (this.lengthRestriction == null && !this.isIfpresent && templateRestriction == TemplateRestriction.Restriction_type.TR_NONE) {
            if (this.hasSingleExpression()) {
                String genName = governor.getGenNameTemplate(aData, expression.expression);
                expression.expression.append(MessageFormat.format("new {0}(", genName));
                if (governor.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                    Array_Type array_type = (Array_Type)governor;
                    expression.expression.append(MessageFormat.format(" {0}.class, ", array_type.getElementType().getGenNameTemplate(aData, expression.expression)));
                }
                expression.expression.append((CharSequence)this.getSingleExpression(aData, true));
                expression.expression.append(')');
                return;
            }
            this.generateCodeExpressionInvoke(aData, expression);
            return;
        }
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", governor.getGenNameTemplate(aData, expression.expression), tempId));
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    private void generateCodeExpressionInvoke(JavaGenData aData, ExpressionStruct expression) {
        if (this.value == null || this.actualParameter_list == null) {
            return;
        }
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = this.value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
        referenceChain.release();
        if (last.getValuetype() == IValue.Value_type.FUNCTION_REFERENCE_VALUE) {
            Definition function = ((Function_Reference_Value)last).getReferredFunction();
            expression.expression.append(MessageFormat.format("{0}(", function.getGenNameFromScope(aData, expression.expression, "")));
            this.actualParameter_list.generateCodeAlias(aData, expression, null);
        } else {
            this.value.generateCodeExpressionMandatory(aData, expression, true);
            expression.expression.append(".invoke(");
            IType governor = this.value.getMyGovernor();
            if (governor == null) {
                governor = this.value.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
            }
            if (governor == null) {
                return;
            }
            this.actualParameter_list.generateCodeAlias(aData, expression, null);
        }
        expression.expression.append(')');
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.actualParameter_list != null) {
            this.actualParameter_list.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
            this.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
        }
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append(MessageFormat.format("{0}.operator_assign(", name));
        this.generateCodeExpressionInvoke(aData, expression);
        expression.expression.append(')');
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
    }
}

