/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.utils;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.implementation.StaticData;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.utils.Analyzer;
import org.eclipse.titanium.preferences.ProblemTypePreference;

public class AnalyzerBuilder {
    private final Map<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>> actions = new HashMap<Class<? extends IVisitableNode>, Set<BaseModuleCodeSmellSpotter>>();
    private final Set<BaseProjectCodeSmellSpotter> projectActions = new HashSet<BaseProjectCodeSmellSpotter>();
    private final Map<CodeSmellType, BaseModuleCodeSmellSpotter[]> spotters = StaticData.newSpotters();
    private final Map<CodeSmellType, BaseProjectCodeSmellSpotter[]> projectSpotters = StaticData.newProjectSpotters();
    private Boolean exhausted = false;

    AnalyzerBuilder() {
    }

    public Analyzer build() {
        if (this.exhausted.booleanValue()) {
            throw new IllegalStateException("One must not use the builder after build() method is called");
        }
        this.exhausted = true;
        return new Analyzer(this.actions, this.projectActions);
    }

    public AnalyzerBuilder adaptPreferences() {
        if (this.exhausted.booleanValue()) {
            throw new IllegalStateException("One must not use the builder after build() method is called");
        }
        this.actions.clear();
        this.projectActions.clear();
        IPreferencesService prefs = Platform.getPreferencesService();
        for (ProblemTypePreference prefType : ProblemTypePreference.values()) {
            String prefName = prefType.getPreferenceName();
            String warnLevel = prefs.getString("org.eclipse.titanium", prefName, "ignore", null);
            if ("ignore".equals(warnLevel)) continue;
            this.addPreferenceProblem(prefType);
        }
        return this;
    }

    public AnalyzerBuilder addPreferenceProblem(ProblemTypePreference preferenceProblem) {
        if (this.exhausted.booleanValue()) {
            throw new IllegalStateException("One must not use the builder after build() method is called");
        }
        for (CodeSmellType problemType : preferenceProblem.getRelatedProblems()) {
            this.addProblem(problemType);
        }
        return this;
    }

    public AnalyzerBuilder addProblem(CodeSmellType problemType) {
        block7: {
            block6: {
                if (this.exhausted.booleanValue()) {
                    throw new IllegalStateException("One must not use the builder after build() method is called");
                }
                if (this.spotters.get(problemType) == null) break block6;
                for (BaseModuleCodeSmellSpotter spotter : this.spotters.get(problemType)) {
                    ArrayDeque<Class<? extends IVisitableNode>> subtypes = new ArrayDeque<Class<? extends IVisitableNode>>();
                    subtypes.addAll(spotter.getStartNode());
                    while (!subtypes.isEmpty()) {
                        Class sub = (Class)subtypes.poll();
                        if (StaticData.TYPE_HIERARCHY.get(sub) != null) {
                            Collections.addAll(subtypes, StaticData.TYPE_HIERARCHY.get(sub));
                        }
                        if (this.actions.get(sub) == null) {
                            this.actions.put(sub, new HashSet());
                        }
                        this.actions.get(sub).add(spotter);
                    }
                }
                break block7;
            }
            if (this.projectSpotters.get(problemType) == null) break block7;
            for (BaseProjectCodeSmellSpotter spotter : this.projectSpotters.get(problemType)) {
                this.projectActions.add(spotter);
            }
        }
        return this;
    }
}

