/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.commons;

public enum StatusCode {
    SUCCESSFUL_OPERATION((short)10000, "Successful DNS Operation"),
    CONFIGURATION_ERROR((short)10001, "Inconsistent secured DNS settings"),
    NETWORK_ERROR((short)10002, "Unreachable DNS or timeout expired"),
    ILLEGAL_FQDN((short)10003, "Provided an illegal FQDN"),
    RESOURCE_LOOKUP_ERROR((short)9003, "DNS Resolution error"),
    RESOURCE_INSECURE_ERROR((short)9505, "Insecure DNS packet"),
    RESOURCE_UNEXPECTED((short)9506, "Unexpected Resource Record Type"),
    DNSSEC_STATUS_ERROR((short)9507, "DNSSEC validation error"),
    SIGNATURE_ERROR((short)9016, "DNS failed to verify"),
    SERVER_ERROR((short)9002, "DNS server error: refuses to serve the query"),
    RESOLUTION_NAME_ERROR((short)9001, "DNS name does not exist"),
    RESOLUTION_RR_TYPE_ERROR((short)9007, "RR Type does not exist");

    private final Short code;
    private final String label;

    private StatusCode(Short code, String label) {
        this.code = code;
        this.label = label;
    }

    public Short statusCode() {
        return this.code;
    }

    public String statusLabel() {
        return this.label;
    }

    public String toString() {
        return String.format("%d: %s: ", this.code, this.label);
    }
}

