/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.commons;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.iot.tiaki.exceptions.ConfigurationException;
import org.xbill.DNS.ResolverConfig;

public abstract class Configurable {
    protected List<InetAddress> dnsServers;
    protected String dnsSecDomain;
    protected String trustAnchorDefault;
    protected File trustAnchorFile;
    protected boolean introspected = false;
    protected boolean checked = false;
    protected Notifier notifier = new Notifier();

    protected Configurable() {
        this.dnsServers = new ArrayList<InetAddress>();
    }

    public final Configurable dnsServer(InetAddress host) {
        this.dnsServers.add(host);
        this.checked = false;
        return this;
    }

    public final Configurable dnsSecDomain(String domain) {
        this.dnsSecDomain = domain;
        this.checked = false;
        return this;
    }

    public final Configurable trustAnchorDefault(String anchor) {
        this.trustAnchorDefault = anchor;
        this.checked = false;
        return this;
    }

    public final Configurable trustAnchorFile(File anchorContainer) {
        this.trustAnchorFile = anchorContainer;
        this.checked = false;
        return this;
    }

    public final Configurable introspected(boolean isIt) {
        this.introspected = isIt;
        this.checked = false;
        return this;
    }

    public final Configurable observer(Observer handler) {
        if (handler != null) {
            this.notifier.addObserver(handler);
            this.checked = false;
        }
        return this;
    }

    public void checkConfiguration(boolean reloadConfig) throws ConfigurationException {
        if (!reloadConfig && this.checked) {
            return;
        }
        if (this.dnsServers.isEmpty()) {
            String[] resolvers;
            for (String resolver : resolvers = ResolverConfig.getCurrentConfig().servers()) {
                try {
                    this.dnsServers.add(InetAddress.getByName(resolver));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.dnsServers.isEmpty()) {
                throw new ConfigurationException("Unable to retrieve default DNS resolvers");
            }
        }
        if (this.trustAnchorFile != null) {
            try {
                this.trustAnchorDefault = new String(Files.readAllBytes(this.trustAnchorFile.toPath()));
            }
            catch (IOException ex) {
                throw new ConfigurationException("Unable to read the Trust Anchor from " + this.trustAnchorFile.getName());
            }
        }
        try {
            File defaultTrustAnchorLocation = new File("/var/lib/unbound/root.key");
            this.trustAnchorDefault = defaultTrustAnchorLocation.exists() ? new String(Files.readAllBytes(defaultTrustAnchorLocation.toPath())) : ". IN DS 19036 8 2 49AAC11D7B6F6446702E54A1607371607A1A41855200FD2CE1CDDE32F24E8FB5";
        }
        catch (IOException ex) {
            throw new ConfigurationException("Unable to read the Trust Anchor from " + this.trustAnchorFile.getName());
        }
        this.checked = true;
    }

    protected void validatedConf() throws ConfigurationException {
        this.checkConfiguration(false);
    }

    protected void statusChange(String what) {
        if (what == null || what.isEmpty()) {
            this.notifier.notifyObservers();
        } else {
            this.notifier.notifyObservers(what);
        }
    }

    protected void statusChange(Object what) {
        if (what != null) {
            this.notifier.notifyObservers(what);
        }
    }

    private class Notifier
    extends Observable {
        private Notifier() {
        }

        @Override
        public final void notifyObservers() {
            this.setChanged();
            if (Configurable.this.introspected) {
                super.notifyObservers();
            }
        }

        @Override
        public final void notifyObservers(Object arg) {
            this.setChanged();
            if (Configurable.this.introspected) {
                super.notifyObservers(arg);
            }
        }
    }
}

