/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.command;

import java.util.Set;
import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.ConsoleWriter;
import org.eclipse.iot.tiaki.cli.command.DnsSdAbstractCommand;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.util.DisplayUtil;
import org.eclipse.iot.tiaki.cli.util.OptionUtil;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.domain.Fqdn;
import org.eclipse.iot.tiaki.exceptions.DnsServiceException;
import org.eclipse.iot.tiaki.exceptions.LookupException;

public class ListServiceTypesCommand
extends DnsSdAbstractCommand {
    private Fqdn domain;

    @Override
    public void initialize(OptionSet optionSet) throws ExecutionException, OptionsNotValidException {
        super.initialize(optionSet);
        String domainStr = OptionUtil.getOptionValue(optionSet, "domain", true);
        try {
            this.domain = new Fqdn(domainStr);
        }
        catch (IllegalArgumentException iae) {
            throw new ExecutionException(DisplayUtil.map(StatusCode.ILLEGAL_FQDN), ExitCodes.INVALID_FQDN.getExitCode());
        }
    }

    @Override
    public void doExecute(ConsoleWriter consoleWriter) throws DnsServiceException {
        Set<String> serviceTypes = null;
        try {
            serviceTypes = this.dnsSd.listServiceTypes(this.domain, !this.insecureMode);
        }
        catch (LookupException le) {
            throw new DnsServiceException(le.dnsError(), String.format(DisplayUtil.map(le.dnsError()), this.domain), true);
        }
        for (String serviceType : serviceTypes) {
            consoleWriter.log(serviceType);
        }
    }
}

