/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli;

import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.Command;
import org.eclipse.iot.tiaki.cli.command.CheckDnsSecCommand;
import org.eclipse.iot.tiaki.cli.command.ListServiceInstanceCommand;
import org.eclipse.iot.tiaki.cli.command.ListServiceTypesCommand;
import org.eclipse.iot.tiaki.cli.command.ListTextRecordCommand;
import org.eclipse.iot.tiaki.cli.command.ListTlsaRecordsCommand;
import org.eclipse.iot.tiaki.cli.command.ShowHelpCommand;
import org.eclipse.iot.tiaki.cli.exception.CommandNotFoundException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;

public class CommandFactory {
    public static Command buildCommand(OptionSet optionSet) throws CommandNotFoundException, OptionsNotValidException {
        String[] argsCommandOption = new String[]{"list-services", "list-instances", "text-record", "dnssec-status", "help", "tlsa"};
        Command command = null;
        for (String cmdOption : argsCommandOption) {
            if (!optionSet.has(cmdOption)) continue;
            if (command != null) {
                throw new OptionsNotValidException("Conflicting mutually exclusive arguments detected");
            }
            command = CommandFactory.buildCommand(cmdOption);
        }
        if (command == null) {
            throw new OptionsNotValidException("Missing command");
        }
        return command;
    }

    private static Command buildCommand(String commandOption) throws CommandNotFoundException {
        if ("list-services".equals(commandOption)) {
            return new ListServiceTypesCommand();
        }
        if ("list-instances".equals(commandOption)) {
            return new ListServiceInstanceCommand();
        }
        if ("text-record".equals(commandOption)) {
            return new ListTextRecordCommand();
        }
        if ("dnssec-status".equals(commandOption)) {
            return new CheckDnsSecCommand();
        }
        if ("tlsa".equals(commandOption)) {
            return new ListTlsaRecordsCommand();
        }
        if ("help".equals(commandOption)) {
            return new ShowHelpCommand();
        }
        throw new CommandNotFoundException(String.format("No command registered for the argument: %s", commandOption));
    }
}

