/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.structures;

import java.io.File;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.TapsetParser;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.TreeSettings;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.structures.listeners.IUpdateListener;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.PreferenceConstants;
import org.eclipse.ui.PlatformUI;

public final class TapsetLibrary {
    private static final IUpdateListener completionListener = new IUpdateListener(){

        public void handleUpdateEvent() {
            functionTree = stpp.getFunctions();
            probeTree = stpp.getProbes();
            if (stpp.isFinishSuccessful()) {
                TreeSettings.setTrees(functionTree, probeTree);
            }
        }
    };
    private static TreeNode functionTree = null;
    private static TreeNode probeTree = null;
    private static TapsetParser stpp = null;

    public static TreeNode getProbes() {
        return probeTree;
    }

    public static TreeNode getFunctions() {
        return functionTree;
    }

    public static void init() {
        if (stpp != null && stpp.isRunning()) {
            return;
        }
        if (IDEPlugin.getDefault().getPreferenceStore().getBoolean("UseStoredTreePreference") && TapsetLibrary.isTreeFileCurrent()) {
            TapsetLibrary.readTreeFile();
        } else {
            TapsetLibrary.runStapParser();
        }
    }

    private static void runStapParser() {
        String[] tapsets = IDEPlugin.getDefault().getPreferenceStore().getString("TapsetPreference").split(File.pathSeparator);
        stpp = new TapsetParser(tapsets);
        stpp.start();
        stpp.addListener(completionListener);
        functionTree = stpp.getFunctions();
        probeTree = stpp.getProbes();
    }

    private static void readTreeFile() {
        functionTree = TreeSettings.getFunctionTree();
        probeTree = TreeSettings.getProbeTree();
    }

    private static boolean isTreeFileCurrent() {
        long treesDate = TreeSettings.getTreeFileDate();
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = p.getString("TapsetPreference").split(File.pathSeparator);
        File f = TapsetLibrary.getTapsetLocation(p);
        if (!TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
            return false;
        }
        if (tapsets != null) {
            int i = 0;
            while (i < tapsets.length) {
                f = new File(tapsets[i]);
                if (f.lastModified() > treesDate) {
                    return false;
                }
                if (f.canRead() && !TapsetLibrary.checkIsCurrentFolder(treesDate, f)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static File getTapsetLocation(IPreferenceStore p) {
        File f;
        String path = p.getString(PreferenceConstants.P_ENV[2][0]);
        if (path.trim().equals("")) {
            f = new File("/usr/share/systemtap/tapset");
            if (!f.exists() && !(f = new File("/usr/local/share/systemtap/tapset")).exists()) {
                InputDialog i = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Localization.getString("TapsetBrowserView.TapsetLocation"), Localization.getString("TapsetBrowserView.WhereDefaultTapset"), "", null);
                i.open();
                p.setValue(PreferenceConstants.P_ENV[2][0], i.getValue());
                f = new File(i.getValue());
            }
        } else {
            f = new File(p.getString(path));
        }
        IDESessionSettings.tapsetLocation = f.getAbsolutePath();
        return f;
    }

    private static boolean checkIsCurrentFolder(long time, File folder) {
        File[] fs = folder.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].lastModified() > time) {
                return false;
            }
            if (fs[i].isDirectory() && fs[i].canRead() && !TapsetLibrary.checkIsCurrentFolder(time, fs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean addListener(IUpdateListener listener) {
        if (stpp == null) {
            return false;
        }
        stpp.addListener(listener);
        return true;
    }

    public static void removeUpdateListener(IUpdateListener listener) {
        stpp.removeListener(listener);
    }
}

