/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c;

import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c.CConfiguration;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c.CDocumentProvider;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c.CScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.editor.actions.file.NewFileAction;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CEditor
extends AbstractDecoratedTextEditor {
    private ColorManager colorManager;
    private RulerDoubleClickHandler handler = new RulerDoubleClickHandler();
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c.CEditor";
    private final Preferences.IPropertyChangeListener cColorPropertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            LogManager.logDebug((String)("Start propertyChange: event-" + event), (Object)this);
            if (event.getProperty().equals("cCommentColorPreference") || event.getProperty().equals("cDefaultColorPreference") || event.getProperty().equals("cKeywordColorPreference") || event.getProperty().equals("cPreprocessorColorPreference") || event.getProperty().equals("cStringColorPreference") || event.getProperty().equals("cTypeColorPreference")) {
                CEditor.this.notifyColorPrefsChanged();
            }
            LogManager.logDebug((String)("End propertyChange: event-" + event), (Object)this);
        }
    };

    public CEditor() {
        LogManager.logDebug((String)"Start CEditor:", (Object)((Object)this));
        this.internal_init();
        IDEPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.cColorPropertyChangeListener);
        LogManager.logDebug((String)"End CEditor:", (Object)((Object)this));
    }

    protected void internal_init() {
        LogManager.logDebug((String)"Start internal_init:", (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        this.configureInsertMode(SMART_INSERT, false);
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new CConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new CDocumentProvider());
        LogManager.logDebug((String)"End internal_init", (Object)((Object)this));
    }

    public void dispose() {
        LogManager.logDebug((String)"Start dispose:", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        IDEPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.cColorPropertyChangeListener);
        this.colorManager.dispose();
        super.dispose();
        LogManager.logDebug((String)"End dispose:", (Object)((Object)this));
    }

    protected CompositeRuler createCompositeRuler() {
        LogManager.logDebug((String)"Start createCompositeRuler:", (Object)((Object)this));
        CompositeRuler ruler = new CompositeRuler();
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        ruler.addDecorator(0, (IVerticalRulerColumn)column);
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        } else if (this.isPrefQuickDiffAlwaysOn()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        LogManager.logDebug((String)("End createCompositeRuler: returnVal-" + ruler), (Object)((Object)this));
        return ruler;
    }

    public void createPartControl(Composite parent) {
        LogManager.logDebug((String)("Start createPartControl: parent-" + parent), (Object)((Object)this));
        super.createPartControl(parent);
        IVerticalRuler ruler = this.getVerticalRuler();
        Control control = ruler.getControl();
        try {
            control.addMouseListener((MouseListener)this.handler);
        }
        catch (Exception e) {
            LogManager.logCritical((String)("Exception createPartControl: " + e.getMessage()), (Object)((Object)this));
        }
        LogManager.logDebug((String)"End createPartControl:", (Object)((Object)this));
    }

    private void notifyColorPrefsChanged() {
        LogManager.logDebug((String)"Start notifyColorPrefsChanged:", (Object)((Object)this));
        SourceViewerConfiguration svc = this.getSourceViewerConfiguration();
        if (!(svc instanceof CConfiguration)) {
            LogManager.logDebug((String)"End notifyColorPrefsChanged:", (Object)((Object)this));
            return;
        }
        CConfiguration config = (CConfiguration)svc;
        CScanner scanner = config.getCScanner();
        scanner.initializeScanner();
        SourceViewer viewer = (SourceViewer)this.getSourceViewer();
        viewer.unconfigure();
        viewer.configure(svc);
        viewer.invalidateTextPresentation();
        viewer.refresh();
        LogManager.logDebug((String)"End notifyColorPrefsChanged:", (Object)((Object)this));
    }

    private class RulerDoubleClickHandler
    implements MouseListener {
        private RulerDoubleClickHandler() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            LogManager.logDebug((String)("Start mouseDoubleClick: e-" + e), (Object)this);
            CEditor.this.getSite().getShell().setCursor(new Cursor((Device)CEditor.this.getSite().getShell().getDisplay(), 1));
            int lineno = CEditor.this.getVerticalRuler().getLineOfLastMouseButtonActivity();
            String s = CEditor.this.getSourceViewer().getDocument().get();
            String[] lines = s.split("\n");
            String line = lines[lineno].trim();
            boolean die = false;
            if ("".equals(line)) {
                die = true;
            }
            if (line.startsWith("#")) {
                die = true;
            }
            if (line.startsWith("//")) {
                die = true;
            }
            if (line.startsWith("/*") && !line.contains("*/") && !line.endsWith("*/")) {
                die = true;
            }
            try {
                ArrayList<Integer> commentChunks = new ArrayList<Integer>();
                char[] chars = s.toCharArray();
                int needle = 1;
                int offset = CEditor.this.getSourceViewer().getDocument().getLineOffset(lineno);
                while (needle < chars.length) {
                    if (chars[needle - 1] == '/' && chars[needle] == '*') {
                        commentChunks.add(new Integer(needle));
                        while (needle < chars.length) {
                            if (chars[needle - 1] == '*' && chars[needle] == '/') {
                                commentChunks.add(new Integer(needle));
                                ++needle;
                                break;
                            }
                            ++needle;
                        }
                    }
                    ++needle;
                }
                int i = 0;
                while (i < commentChunks.size()) {
                    if ((Integer)commentChunks.get(i) >= offset) {
                        int pair = i - i % 2;
                        int start = (Integer)commentChunks.get(pair);
                        int end = (Integer)commentChunks.get(pair + 1);
                        if (offset >= start && offset <= end) {
                            die = true;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception excp) {
                LogManager.logCritical((String)("Exception mouseDoubleClick: " + excp.getMessage()), (Object)this);
            }
            if (die) {
                LogManager.logInfo((String)"Initializing", MessageDialog.class);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("CEditor.ProbeInsertFailed"), (String)Localization.getString("CEditor.CanNotProbeLine"));
                LogManager.logInfo((String)"Disposing", MessageDialog.class);
            } else {
                IEditorInput in = CEditor.this.getEditorInput();
                if (in instanceof PathEditorInput) {
                    STPEditor editor;
                    PathEditorInput input = (PathEditorInput)in;
                    IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
                    String kernroot = p.getString("KernelSourcePreference");
                    String filepath = input.getPath().toOSString();
                    String kernrelative = filepath.substring(kernroot.length() + 1, filepath.length());
                    StringBuffer sb = new StringBuffer();
                    sb.append("probe kernel.statement(\"*@" + kernrelative + ":" + (lineno + 1) + "\")");
                    sb.append("\n{\n\t\n}\n");
                    if (IDESessionSettings.activeSTPEditor == null) {
                        NewFileAction action = new NewFileAction();
                        action.run();
                        IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (ed instanceof STPEditor) {
                            IDESessionSettings.activeSTPEditor = (STPEditor)ed;
                        }
                    }
                    if ((editor = IDESessionSettings.activeSTPEditor) != null) {
                        editor.insertText(sb.toString());
                    }
                }
            }
            CEditor.this.getSite().getShell().setCursor(null);
            LogManager.logDebug((String)"End mouseDoubleClick:", (Object)this);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

