/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs;

import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.ScrollAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.DataPoint;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.NumberType;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.AGraph;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.IScrollGraph;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class ScatterGraph
extends AGraph
implements IScrollGraph {
    private ScrollAdapter adapter;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.scattergraph";
    private static final int DIAMETER = 5;

    public ScatterGraph(GraphComposite parent, int style, String title, ScrollAdapter adapter) {
        super(parent, style, title, (IAdapter)adapter);
        this.adapter = adapter;
        this.handleUpdateEvent();
    }

    public void paintElementList(GC gc) {
        DataPoint[] points = new DataPoint[]{};
        Color temp = gc.getForeground();
        Color temp1 = gc.getBackground();
        double xSize = super.getSize().x - (super.getXPadding() << 1);
        xSize /= (double)super.getLocalWidth();
        double ySize = super.getSize().y - (super.getYPadding() << 1);
        ySize /= (double)super.getLocalHeight();
        int j = 0;
        while (j < this.elementList.length) {
            points = this.elementList[j].toArray(points);
            Color c = new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[j]);
            gc.setForeground(c);
            gc.setBackground(c);
            int i = 0;
            while (i < points.length) {
                double px = points[i].x - (double)super.getLocalXMin();
                px *= xSize;
                double py = (double)super.getLocalYMax() - points[i].y;
                py *= ySize;
                gc.fillOval((int)(px += (double)(super.getXPadding() - 2)), (int)(py += (double)(super.getYPadding() - 2)), 5, 5);
                ++i;
            }
            ++j;
        }
        gc.setForeground(temp);
        gc.setBackground(temp1);
    }

    public boolean isMultiGraph() {
        return this.adapter.getSeriesCount() > 0;
    }

    public void handleUpdateEvent() {
        if (this.adapter == null) {
            return;
        }
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Object[][] data = ScatterGraph.this.adapter.getData(ScatterGraph.this.removedItems, ScatterGraph.this.adapter.getRecordCount());
                if (ScatterGraph.this.normalize) {
                    int i = 0;
                    while (i < ScatterGraph.this.adapter.getSeriesCount()) {
                        ScatterGraph.this.elementList[i].clear();
                        double max = ScatterGraph.this.adapter.getYSeriesMax(i, ScatterGraph.this.removedItems, ScatterGraph.this.adapter.getRecordCount()).doubleValue() / 100.0;
                        int j = 0;
                        while (j < data.length) {
                            ScatterGraph.this.elementList[i].add(new DataPoint(NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue() / max));
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < ScatterGraph.this.adapter.getSeriesCount()) {
                        ScatterGraph.this.elementList[i].clear();
                        int j = 0;
                        while (j < data.length) {
                            ScatterGraph.this.elementList[i].add(new DataPoint(NumberType.obj2num((Object)data[j][0]).doubleValue(), NumberType.obj2num((Object)data[j][i + 1]).doubleValue()));
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        });
        this.repaint();
    }
}

