/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.util.Iterator;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.GNUAutomakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefileDocumentProvider;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileDocumentSetupParticipant;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileStorageDocumentProvider;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class MakefileDocumentProvider
extends TextFileDocumentProvider
implements IMakefileDocumentProvider {
    IMakefile fMakefile;

    public MakefileDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider((IDocumentProvider)new MakefileStorageDocumentProvider());
        provider = new ForwardingDocumentProvider("___makefile_partitioning", (IDocumentSetupParticipant)new MakefileDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
    }

    private IMakefile createMakefile(IFile file) throws CoreException {
        if (file.exists()) {
            return GNUAutomakefile.createMakefile(file);
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new MakefileAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        IMakefile original = this.createMakefile(input.getFile());
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof MakefileFileInfo)) {
            return null;
        }
        MakefileFileInfo makefileInfo = (MakefileFileInfo)info;
        this.setUpSynchronization(makefileInfo);
        makefileInfo.fCopy = original;
        if (makefileInfo.fModel instanceof MakefileAnnotationModel) {
            MakefileAnnotationModel model = (MakefileAnnotationModel)makefileInfo.fModel;
            model.setMakefile(makefileInfo.fCopy);
        }
        return makefileInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof MakefileFileInfo) {
            MakefileFileInfo makefileInfo = (MakefileFileInfo)info;
            if (makefileInfo.fCopy != null) {
                makefileInfo.fCopy = null;
            }
        }
        super.disposeFileInfo(element, info);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new MakefileFileInfo();
    }

    public IMakefile getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof MakefileFileInfo) {
            MakefileFileInfo info = (MakefileFileInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    protected class MakefileAnnotationModel
    extends AnnotationModel {
        public MakefileAnnotationModel(IResource resource) {
        }

        public void setMakefile(IMakefile makefile) {
            MakefileDocumentProvider.this.fMakefile = makefile;
        }
    }

    protected class MakefileFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public IMakefile fCopy;

        protected MakefileFileInfo() {
        }
    }
}

