/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddLibraryAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.CopyAction;
import org.eclipse.jdt.internal.debug.ui.actions.EditClasspathEntryAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RestoreDefaultEntriesAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.BootpathFilter;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JavaClasspathTab
extends AbstractJavaClasspathTab {
    protected RuntimeClasspathViewer fClasspathViewer;
    private ClasspathModel fModel;
    protected static final String DIALOG_SETTINGS_PREFIX = "JavaClasspathTab";
    protected ILaunchConfiguration fLaunchConfiguration;
    private Button fExcludeTestCodeButton;
    private Button fUseClasspathOnlyJarButton;

    public JavaClasspathTab() {
        this.setHelpContextId(IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        Label label = new Label(comp, 0);
        label.setText(LauncherMessages.JavaClasspathTab_0);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fClasspathViewer = new RuntimeClasspathViewer(comp);
        this.fClasspathViewer.addEntriesChangedListener(this);
        this.fClasspathViewer.getTreeViewer().getControl().setFont(font);
        this.fClasspathViewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.fClasspathViewer.getTreeViewer().setContentProvider((IContentProvider)new ClasspathContentProvider(this));
        if (!this.isShowBootpath()) {
            this.fClasspathViewer.getTreeViewer().addFilter((ViewerFilter)new BootpathFilter());
        }
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createPathButtons(pathButtonComp);
        SWTFactory.createVerticalSpacer((Composite)comp, (int)2);
        this.fExcludeTestCodeButton = SWTFactory.createCheckButton((Composite)comp, (String)LauncherMessages.JavaClasspathTab_Exclude_Test_Code, null, (boolean)false, (int)2);
        this.fExcludeTestCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaClasspathTab.this.setDirty(true);
                JavaClasspathTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fUseClasspathOnlyJarButton = SWTFactory.createCheckButton((Composite)comp, (String)LauncherMessages.VMArgumentsBlock_1, null, (boolean)false, (int)1);
        this.fUseClasspathOnlyJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaClasspathTab.this.setDirty(true);
                JavaClasspathTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createPathButtons(Composite pathButtonComp) {
        ArrayList<AddFolderAction> advancedActions = new ArrayList<AddFolderAction>(5);
        this.createButton(pathButtonComp, new MoveUpAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new MoveDownAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new RemoveAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new CopyAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new AddProjectAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new AddJarAction(this.fClasspathViewer));
        this.createButton(pathButtonComp, new AddExternalJarAction(this.fClasspathViewer, DIALOG_SETTINGS_PREFIX));
        RuntimeClasspathAction action = new AddFolderAction(null);
        advancedActions.add((AddFolderAction)action);
        action = new AddExternalFolderAction(null, DIALOG_SETTINGS_PREFIX);
        advancedActions.add((AddFolderAction)action);
        action = new AddVariableAction(null);
        advancedActions.add((AddFolderAction)action);
        action = new AddLibraryAction(null);
        advancedActions.add((AddFolderAction)action);
        action = new AttachSourceAction(null, 16);
        advancedActions.add((AddFolderAction)action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        this.createButton(pathButtonComp, new AddAdvancedAction(this.fClasspathViewer, adv));
        action = new EditClasspathEntryAction(this.fClasspathViewer, this.getLaunchConfiguration());
        this.createButton(pathButtonComp, action);
        action = new RestoreDefaultEntriesAction(this.fClasspathViewer, this);
        this.createButton(pathButtonComp, action);
        action.setEnabled(true);
    }

    protected Button createButton(Composite pathButtonComp, RuntimeClasspathAction action) {
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        this.refresh(configuration);
        this.fClasspathViewer.getTreeViewer().expandToLevel(2);
        try {
            this.fExcludeTestCodeButton.setSelection(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, false));
            this.fUseClasspathOnlyJarButton.setSelection(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_CLASSPATH_ONLY_JAR, false));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            boolean useDefault = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (useDefault && !this.isDefaultClasspath(this.getCurrentClasspath(), (ILaunchConfiguration)workingCopy)) {
                this.initializeFrom((ILaunchConfiguration)workingCopy);
                return;
            }
            this.fClasspathViewer.getTreeViewer().refresh();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void refresh(ILaunchConfiguration configuration) {
        this.setErrorMessage(null);
        this.setLaunchConfiguration(configuration);
        try {
            this.createClasspathModel(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fClasspathViewer.getTreeViewer().setInput((Object)this.fModel);
        this.setDirty(false);
    }

    private void createClasspathModel(ILaunchConfiguration configuration) throws CoreException {
        this.fModel = new ClasspathModel();
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    this.fModel.addEntry(1, entry);
                    break;
                }
                default: {
                    this.fModel.addEntry(0, entry);
                }
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            IRuntimeClasspathEntry[] classpath = this.getCurrentClasspath();
            boolean def = this.isDefaultClasspath(classpath, (ILaunchConfiguration)configuration);
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.statusDialog(LauncherMessages.JavaClasspathTab_Unable_to_save_classpath_1, e.getStatus());
                }
            }
            try {
                boolean previousExcludeTestCode = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, false);
                if (previousExcludeTestCode != this.fExcludeTestCodeButton.getSelection()) {
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, this.fExcludeTestCodeButton.getSelection());
                    this.fClasspathViewer.setEntries(JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration));
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.statusDialog(LauncherMessages.JavaClasspathTab_Unable_to_save_classpath_1, e.getStatus());
            }
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_CLASSPATH_ONLY_JAR, this.fUseClasspathOnlyJarButton.getSelection());
        }
    }

    private IRuntimeClasspathEntry[] getCurrentClasspath() {
        IRuntimeClasspathEntry entry;
        IClasspathEntry[] boot = this.fModel.getEntries(0);
        IClasspathEntry[] user = this.fModel.getEntries(1);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(boot.length + user.length);
        int i = 0;
        while (i < boot.length) {
            IClasspathEntry bootEntry = boot[i];
            entry = null;
            if (bootEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)bootEntry).getDelegate();
            } else if (bootEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)boot[i];
            }
            if (entry != null) {
                if (entry.getClasspathProperty() == 3) {
                    entry.setClasspathProperty(2);
                }
                entries.add(entry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length) {
            IClasspathEntry userEntry = user[i2];
            entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i2];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i2;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDefaultClasspath(IRuntimeClasspathEntry[] classpath, ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            if (classpath.length != entries.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return true;
                }
                IRuntimeClasspathEntry entry = entries[i];
                if (!entry.equals(classpath[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            return false;
        }
    }

    public String getName() {
        return LauncherMessages.JavaClasspathTab_Cla_ss_path_3;
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.javaClasspathTab";
    }

    public static Image getClasspathImage() {
        return JavaDebugImages.get("IMG_OBJS_CLASSPATH");
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    public void dispose() {
        if (this.fClasspathViewer != null) {
            this.fClasspathViewer.removeEntriesChangedListener(this);
        }
        super.dispose();
    }

    public Image getImage() {
        return JavaClasspathTab.getClasspathImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = null;
        try {
            projectName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException e) {
            return false;
        }
        if (projectName.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(projectName, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    this.setErrorMessage(NLS.bind((String)LauncherMessages.JavaMainTab_20, (Object[])new String[]{projectName}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(NLS.bind((String)LauncherMessages.JavaMainTab_21, (Object[])new String[]{projectName}));
                    return false;
                }
            } else {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.JavaMainTab_19, (Object[])new String[]{status.getMessage()}));
                return false;
            }
        }
        IRuntimeClasspathEntry[] entries = this.fModel.getAllEntries();
        int type = -1;
        int i = 0;
        while (i < entries.length) {
            IResource res;
            type = entries[i].getType();
            if (type == 2 && !entries[i].getPath().isAbsolute()) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.JavaClasspathTab_Invalid_runtime_classpath_1, (Object[])new String[]{entries[i].getPath().toString()}));
                return false;
            }
            if (type == 1 && (res = entries[i].getResource()) != null && !res.isAccessible()) {
                this.setErrorMessage(NLS.bind((String)LauncherMessages.JavaClasspathTab_1, (Object[])new String[]{res.getName()}));
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isShowBootpath() {
        return true;
    }

    protected ClasspathModel getModel() {
        return this.fModel;
    }

    @Override
    protected void initializeAttributes() {
        super.initializeAttributes();
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, LauncherMessages.JavaClasspathTab_AttributeLabel_DefaultClasspath);
        this.getAttributesLabelsForPrototype().put(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, LauncherMessages.JavaClasspathTab_AttributeLabel_Classpath);
    }
}

