/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.MergeTargetSelectionDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MergeActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        Shell shell = this.getShell(event);
        if (repository == null || !MergeActionHandler.checkMergeIsPossible(repository, shell) || LaunchFinder.shouldCancelBecauseOfRunningLaunches(repository, null)) {
            return null;
        }
        BasicConfigurationDialog.show(repository);
        MergeTargetSelectionDialog mergeTargetSelectionDialog = new MergeTargetSelectionDialog(shell, repository);
        if (mergeTargetSelectionDialog.open() == 0) {
            String refName = mergeTargetSelectionDialog.getRefName();
            MergeOperation op = new MergeOperation(repository, refName);
            op.setSquash(mergeTargetSelectionDialog.isMergeSquash());
            op.setFastForwardMode(mergeTargetSelectionDialog.getFastForwardMode());
            op.setCommit(mergeTargetSelectionDialog.isCommit());
            MergeActionHandler.doMerge(repository, op, refName);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repo = this.getRepository();
        return repo != null && RepositoryState.SAFE.equals((Object)SelectionRepositoryStateCache.INSTANCE.getRepositoryState(repo)) && this.isLocalBranchCheckedout(repo);
    }

    public static boolean checkMergeIsPossible(Repository repository, Shell shell) {
        String message = null;
        try {
            Ref head = repository.exactRef("HEAD");
            if (head == null || !head.isSymbolic()) {
                message = UIText.MergeAction_HeadIsNoBranch;
            } else if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                message = NLS.bind((String)UIText.MergeAction_WrongRepositoryState, (Object)repository.getRepositoryState());
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            message = e.getMessage();
        }
        if (message != null) {
            MessageDialog.openError((Shell)shell, (String)UIText.MergeAction_CannotMerge, (String)message);
        }
        return message == null;
    }

    public static void doMerge(final Repository repository, final MergeOperation op, String refName) {
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)op, (String)NLS.bind((String)UIText.MergeAction_JobNameMerge, (Object)refName), (Object)JobFamilies.MERGE, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getJob().getResult();
                if (result.getSeverity() == 8) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        MessageDialog.openInformation((Shell)shell, (String)UIText.MergeAction_MergeCanceledTitle, (String)UIText.MergeAction_MergeCanceledMessage);
                    });
                } else if (!result.isOK()) {
                    Activator.handleError(result.getMessage(), result.getException(), true);
                } else {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        MergeResultDialog.getDialog(shell, repository, op.getResult()).open();
                    });
                }
            }
        });
    }
}

