/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import org.eclipse.oomph.util.ObjectUtil;

public class Pair<T1, T2> {
    private T1 element1;
    private T2 element2;

    public Pair() {
    }

    public Pair(T1 element1, T2 element2) {
        this.element1 = element1;
        this.element2 = element2;
    }

    public Pair(Pair<T1, T2> source) {
        this.element1 = source.element1;
        this.element2 = source.element2;
    }

    public final T1 getElement1() {
        return this.element1;
    }

    public void setElement1(T1 element1) {
        this.element1 = element1;
    }

    public final T2 getElement2() {
        return this.element2;
    }

    public void setElement2(T2 element2) {
        this.element2 = element2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair that = (Pair)obj;
            return ObjectUtil.equals(this.element1, that.getElement1()) && ObjectUtil.equals(this.element2, that.getElement2());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.element1) ^ ObjectUtil.hashCode(this.element2);
    }

    public String toString() {
        return "Pair[" + String.valueOf(this.element1) + ", " + String.valueOf(this.element2) + "]";
    }

    public Pair<T1, T2> copy() {
        return new Pair<T1, T2>(this);
    }

    public static <T1, T2> Pair<T1, T2> create() {
        return new Pair<T1, T2>();
    }

    public static <T1, T2> Pair<T1, T2> create(T1 element1, T2 element2) {
        return new Pair<T1, T2>(element1, element2);
    }
}

