/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginDetailsSection
extends PDESection
implements IPartSelectionListener {
    protected IFeaturePlugin fInput;
    private FormEntry fNameText;
    private FormEntry fVersionText;

    public PluginDetailsSection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.SiteEditor_PluginDetailsSection_title, PDEUIMessages.SiteEditor_PluginDetailsSection_desc, 0);
    }

    public PluginDetailsSection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    public void cancelEdit() {
        this.fVersionText.cancelEdit();
        super.cancelEdit();
    }

    public void commit(boolean onSave) {
        this.fVersionText.commit();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(770);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        this.fNameText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PluginDetailsSection_pluginLabel, null, false);
        this.limitTextWidth(this.fNameText);
        this.fNameText.setEditable(false);
        this.fNameText.getText().setEnabled(false);
        this.fVersionText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_SpecSection_version, null, false);
        this.fVersionText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry text) {
                if (PluginDetailsSection.this.fInput != null) {
                    try {
                        PluginDetailsSection.this.fInput.setVersion(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.limitTextWidth(this.fVersionText);
        this.fVersionText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    protected void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }

    /*
     * Unable to fully structure code
     */
    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) ** GOTO lbl-1000
        s = (IStructuredSelection)selection;
        if (((IStructuredSelection)selection).size() == 1) {
            o = s.getFirstElement();
            this.fInput = o instanceof IFeaturePlugin ? (IFeaturePlugin)o : null;
        } else lbl-1000:
        // 2 sources

        {
            this.fInput = null;
        }
        this.update();
    }

    private void update() {
        if (this.fInput != null) {
            this.fNameText.setValue(this.fInput.getLabel());
            this.fVersionText.setValue(this.fInput.getVersion(), true);
        } else {
            this.fNameText.setValue(null);
            this.fVersionText.setValue(null, true);
        }
        boolean editable = this.fInput != null && this.isEditable();
        this.fVersionText.setEditable(editable);
    }
}

