/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;

class RemoveAllSearchesAction
extends Action {
    public RemoveAllSearchesAction() {
        super(SearchMessages.RemoveAllSearchesAction_label);
        this.setToolTipText(SearchMessages.RemoveAllSearchesAction_tooltip);
    }

    private boolean promptForConfirmation() {
        MessageDialog dialog = new MessageDialog(SearchPlugin.getActiveWorkbenchShell(), SearchMessages.RemoveAllSearchesAction_tooltip, null, SearchMessages.RemoveAllSearchesAction_confirm_message, 5, new String[]{SearchMessages.RemoveAllSearchesAction_confirm_label, IDialogConstants.CANCEL_LABEL}, 0);
        dialog.open();
        return dialog.getReturnCode() == 0;
    }

    public void run() {
        ISearchQuery[] queries = NewSearchUI.getQueries();
        if (this.promptForConfirmation()) {
            ISearchQuery[] iSearchQueryArray = queries;
            int n = queries.length;
            int n2 = 0;
            while (n2 < n) {
                ISearchQuery querie = iSearchQueryArray[n2];
                if (!NewSearchUI.isQueryRunning(querie)) {
                    InternalSearchUI.getInstance().removeQuery(querie);
                }
                ++n2;
            }
        }
    }
}

