/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Namespace;
import de.pdark.decentxml.Namespaces;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.Parent;
import de.pdark.decentxml.ProcessingInstruction;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.TreeIterator;
import de.pdark.decentxml.XMLDeclaration;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.XMLWriter;
import de.pdark.decentxml.dtd.DocType;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends NodeWithChildren
implements Parent {
    private Element rootNode;
    private XMLDeclaration xmlDeclaration;
    private DocType docType;
    private Namespaces namespaces;

    public Document() {
    }

    public Document(Node ... nodes) {
        this.addNodes(nodes);
    }

    @Override
    public Document addNode(Node node) {
        super.addNode(node);
        return this;
    }

    @Override
    public Document addNode(int index, Node node) {
        ProcessingInstruction pi;
        if (node instanceof Element) {
            Element e = (Element)node;
            if (this.rootNode != null) {
                Token startToken = e.getStartToken();
                if (startToken == null) {
                    throw new XMLParseException("Only one root element allowed per document", this.rootNode);
                }
                throw new XMLParseException("Only one root element allowed per document", startToken);
            }
            this.rootNode = e;
        } else if (node instanceof DocType) {
            this.setDocType((DocType)node);
        } else if (node == null) {
            throw new NullPointerException("node is null");
        }
        if (index == 0 && this.xmlDeclaration != null) {
            throw new XMLParseException("It is not allowed to have content before the XML declaration", this, this.xmlDeclaration);
        }
        switch (node.getType()) {
            case COMMENT: 
            case ELEMENT: 
            case PROCESSING_INSTRUCTION: 
            case CUSTOM_ELEMENT: 
            case DOCTYPE: {
                break;
            }
            case TEXT: {
                Text t = (Text)node;
                if (t.isWhitespace()) break;
            }
            default: {
                Node sibling = null;
                if (this.nodeCount() > 0) {
                    if (index == this.nodeCount()) {
                        --index;
                    }
                    sibling = this.getNode(index);
                }
                if (node instanceof BasicNode && ((BasicNode)node).getToken() != null) {
                    throw new XMLParseException((Object)((Object)node.getType()) + " node is not allowed here", ((BasicNode)node).getToken());
                }
                throw new XMLParseException((Object)((Object)node.getType()) + " node is not allowed here", this, sibling);
            }
        }
        super.addNode(index, node);
        if (node.getType() == XMLTokenizer.Type.PROCESSING_INSTRUCTION && XMLDeclaration.isXMLDeclaration(pi = (ProcessingInstruction)node)) {
            if (index == 0) {
                this.parseXMLDeclaration();
            } else {
                String msg = "An XML declaration is only allowed as the first node in the document";
                if (pi.getToken() != null) {
                    throw new XMLParseException(msg, pi.getToken());
                }
                throw new XMLParseException(msg, this, pi);
            }
        }
        return this;
    }

    @Override
    public Document addNodes(Collection<? extends Node> nodes) {
        super.addNodes((Collection)nodes);
        return this;
    }

    @Override
    public Document addNodes(int index, Collection<? extends Node> nodes) {
        super.addNodes(index, (Collection)nodes);
        return this;
    }

    @Override
    public Document addNodes(Node ... nodes) {
        super.addNodes(nodes);
        return this;
    }

    @Override
    public Document addNodes(int index, Node ... nodes) {
        super.addNodes(index, nodes);
        return this;
    }

    @Override
    public Node removeNode(int index) {
        Node n = this.getNode(index);
        if (n.equals(this.xmlDeclaration)) {
            this.clearXMLDeclaration();
        } else if (n.equals(this.rootNode)) {
            this.rootNode = null;
        }
        return super.removeNode(index);
    }

    @Override
    public boolean removeNode(Node n) {
        if (n != null) {
            if (n.equals(this.xmlDeclaration)) {
                this.clearXMLDeclaration();
            } else if (n.equals(this.rootNode)) {
                this.rootNode = null;
            }
        }
        return super.removeNode(n);
    }

    @Override
    public Element getChild(String path) {
        return this.getChild(path, null);
    }

    public Element getChild(String path, Namespace ns) {
        int pos;
        if (this.getRootElement() == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((pos = path.indexOf(47)) == -1) {
            if (ns == null) {
                pos = path.indexOf(58);
            }
            if (path.equals(this.getRootElement().getName()) && (ns == null || ns.equals(this.getRootElement().getNamespace()))) {
                return this.getRootElement();
            }
            return null;
        }
        String name = path.substring(0, pos);
        int pos2 = name.indexOf(58);
        Namespace ns2 = null;
        if (pos2 != -1) {
            String prefix = name.substring(0, pos2);
            name = name.substring(pos2 + 1);
            ns2 = this.getNamespaces().getNamespace(prefix);
            if (ns2 == null) {
                throw new XMLParseException("Namespace prefix '" + prefix + "' is not defined");
            }
        }
        if (!name.equals(this.getRootElement().getName()) || ns2 != null && !ns2.equals(this.getRootElement().getNamespace())) {
            return null;
        }
        return this.getRootElement().getChild(path.substring(pos + 1), ns);
    }

    @Override
    public XMLTokenizer.Type getType() {
        return XMLTokenizer.Type.DOCUMENT;
    }

    public Element getRootElement() {
        return this.rootNode;
    }

    public Document setRootNode(Element rootNode) {
        if (this.rootNode != null) {
            this.removeNode(this.rootNode);
        }
        this.rootNode = null;
        if (rootNode.getParent() != null) {
            rootNode.getParent().removeNode(rootNode);
        }
        super.addNode(rootNode);
        return this;
    }

    public XMLDeclaration getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    public void setXmlDeclaration(XMLDeclaration xmlDeclaration) {
        this.xmlDeclaration = xmlDeclaration;
    }

    public String getVersion() {
        return this.xmlDeclaration == null ? null : this.xmlDeclaration.getVersion();
    }

    public Document setVersion(String version) {
        this.createXMLDeclaration().setVersion(version == null ? "1.0" : version);
        return this;
    }

    protected XMLDeclaration createXMLDeclaration() {
        if (this.xmlDeclaration == null) {
            this.addNode(0, new XMLDeclaration("1.0"));
            this.addNode(1, new Text("\n"));
        }
        return this.xmlDeclaration;
    }

    public String getEncoding() {
        return this.xmlDeclaration == null ? null : this.xmlDeclaration.getEncoding();
    }

    public Document setEncoding(String encoding) {
        this.createXMLDeclaration().setEncoding(encoding);
        return this;
    }

    public boolean isStandalone() {
        return this.xmlDeclaration == null ? false : this.xmlDeclaration.isStandalone();
    }

    public void setStandalone(boolean standalone) {
        this.createXMLDeclaration().setStandalone(standalone);
    }

    @Override
    public Document toXML(XMLWriter writer) throws IOException {
        super.toXML(writer);
        return this;
    }

    public void parseXMLDeclaration() {
        if (this.getNodes().isEmpty()) {
            return;
        }
        Node n = this.getNode(0);
        if (n.getType() != XMLTokenizer.Type.PROCESSING_INSTRUCTION || n == this.xmlDeclaration) {
            return;
        }
        ProcessingInstruction pi = (ProcessingInstruction)n;
        if (this.xmlDeclaration != null) {
            this.xmlDeclaration.parseXMLDeclaration(pi.getValue());
        } else {
            try {
                this.xmlDeclaration = XMLDeclaration.parseXMLDeclaration(pi);
            }
            catch (XMLParseException e) {
                XMLParseException ex = new XMLParseException(e.getMessageWithoutLocation(), e);
                if (pi.getToken() == null) {
                    ex.setNode(this, pi);
                } else {
                    ex.setSource(pi.getToken().getSource(), pi.getStartOffset() + e.getOffset());
                }
                throw ex;
            }
            this.getNodes().set(0, this.xmlDeclaration);
        }
    }

    protected void clearXMLDeclaration() {
        this.xmlDeclaration = null;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public void setDocType(DocType docType) {
        this.docType = docType;
    }

    public Namespaces getNamespaces() {
        if (this.namespaces == null) {
            this.namespaces = new Namespaces();
        }
        return this.namespaces;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public Namespace getNamespace(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return Namespace.NO_NAMESPACE;
        }
        if ("xml".equals(prefix)) {
            return Namespace.XML_NAMESPACE;
        }
        return this.getNamespaces().getNamespace(prefix);
    }

    @Override
    public Document createClone() {
        return new Document();
    }

    @Override
    public Document copy(Node orig) {
        super.copy(orig);
        Document other = (Document)orig;
        this.xmlDeclaration = other.xmlDeclaration.copy();
        this.docType = other.docType;
        if (other.namespaces != null) {
            this.namespaces = other.namespaces.copy();
        }
        return this;
    }

    @Override
    public Document copy() {
        return (Document)super.copy();
    }

    public TreeIterator iterator() {
        return new TreeIterator(this);
    }
}

