/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.InputStream;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryInputStream;

public class MessageBody
implements IMessageBody {
    private final InputStream fMessageBody;
    private final SocketTimeoutRetryInputStream fMessageBodySocketTimeoutRetry;
    private int fContentLength;
    private boolean isChunkedEncoding;

    public MessageBody(InputStream inputStream, int n) {
        this.fMessageBody = inputStream;
        this.fMessageBodySocketTimeoutRetry = new SocketTimeoutRetryInputStream(inputStream);
        this.fContentLength = n;
        this.isChunkedEncoding = false;
    }

    public MessageBody(InputStream inputStream) {
        this.fMessageBody = inputStream;
        this.fMessageBodySocketTimeoutRetry = new SocketTimeoutRetryInputStream(inputStream);
        this.fContentLength = -1;
        this.isChunkedEncoding = true;
    }

    public int getContentLength() {
        return this.fContentLength;
    }

    public boolean isChunkedEncoding() {
        return this.isChunkedEncoding;
    }

    public InputStream getMessageBodyTimeoutInputStream() {
        return this.fMessageBody;
    }

    public InputStream getMessageBodyInputStream() {
        return this.fMessageBodySocketTimeoutRetry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MessageBody[");
        if (this.isChunkedEncoding) {
            stringBuffer.append("chunked");
        } else {
            stringBuffer.append("ContentLength=").append(this.fContentLength);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

