/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.BackgroundTask;
import org.eclipse.tea.core.TaskLazyChainWrapper;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.annotations.TaskChainSuppressLifecycle;
import org.eclipse.tea.core.annotations.lifecycle.BeginTask;
import org.eclipse.tea.core.annotations.lifecycle.BeginTaskChain;
import org.eclipse.tea.core.annotations.lifecycle.CreateContext;
import org.eclipse.tea.core.annotations.lifecycle.DisposeContext;
import org.eclipse.tea.core.annotations.lifecycle.FinishTask;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.internal.OutputRedirector;
import org.eclipse.tea.core.internal.TaskProgressEstimationService;
import org.eclipse.tea.core.internal.TaskProgressExtendedTracker;
import org.eclipse.tea.core.internal.TaskProgressTrackerImpl;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.eclipse.tea.core.services.TaskingLog;

public class TaskExecutionContext {
    public static final String FATAL_FAILURE_WHILE_EXECUTING = "Fatal failure while executing ";
    private final TaskChain chain;
    private final IEclipseContext context;
    private final List<Object> tasks = new ArrayList<Object>();
    private final List<TaskingLifeCycleListener> listeners = new ArrayList<TaskingLifeCycleListener>();

    @Inject
    public TaskExecutionContext(IEclipseContext context, TaskChain chain, @Service List<TaskingLifeCycleListener> listeners) throws Exception {
        this.chain = chain;
        this.context = context;
        for (TaskingLifeCycleListener listener : listeners) {
            TaskingLifeCycleListener l = (TaskingLifeCycleListener)listener.getClass().newInstance();
            this.listeners.add(l);
            context.set(l.getClass().getName(), (Object)l);
        }
        this.listeners.sort((a, b) -> {
            int x;
            int prioA = 10;
            int prioB = 10;
            TaskingLifeCycleListener.TaskingLifeCyclePriority pA = a.getClass().getAnnotation(TaskingLifeCycleListener.TaskingLifeCyclePriority.class);
            TaskingLifeCycleListener.TaskingLifeCyclePriority pB = b.getClass().getAnnotation(TaskingLifeCycleListener.TaskingLifeCyclePriority.class);
            if (pA != null) {
                prioA = pA.value();
            }
            if (pB != null) {
                prioB = pB.value();
            }
            if ((x = prioB - prioA) != 0) {
                return x;
            }
            return a.getClass().getName().compareTo(b.getClass().getName());
        });
        context.set(TaskExecutionContext.class, (Object)this);
        ContextInjectionFactory.invoke((Object)chain, TaskChainContextInit.class, (IEclipseContext)context);
        Object barrierTask = BackgroundTask.allBarrier(this.tasks);
        if (barrierTask != null) {
            this.addTask(barrierTask);
        }
        if (!this.isEmpty()) {
            this.notifyAll(CreateContext.class, context);
        }
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public int getRetries() {
        TaskChain.TaskChainId id = this.chain.getClass().getAnnotation(TaskChain.TaskChainId.class);
        if (id == null) {
            return 1;
        }
        return id.retries();
    }

    public TaskChain getUnderlyingChain() {
        return this.chain;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public void addTask(Object o) {
        if (o instanceof TaskChain) {
            ContextInjectionFactory.invoke((Object)o, TaskChainContextInit.class, (IEclipseContext)this.context);
        } else if (o instanceof Class && TaskChain.class.isAssignableFrom((Class)o)) {
            Object tc = ContextInjectionFactory.make((Class)((Class)o), (IEclipseContext)this.context);
            ContextInjectionFactory.invoke((Object)tc, TaskChainContextInit.class, (IEclipseContext)this.context);
        } else {
            this.tasks.add(o);
        }
    }

    public void addTaskAt(int index, Object o) {
        this.tasks.add(index, o);
    }

    public void addLazyChain(TaskChain chain) {
        this.tasks.add(new TaskLazyChainWrapper(this, chain));
    }

    @Execute
    public void execute(TaskingLog log, @Optional @Service TaskProgressEstimationService progressService, @Optional IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.tea.core", 0, "Tasking Execution Context Status", null);
        this.context.set(IWorkspace.class, (Object)ResourcesPlugin.getWorkspace());
        this.context.set(MultiStatus.class, (Object)status);
        this.context.activate();
        LinkedHashMap<Object, IEclipseContext> taskContexts = new LinkedHashMap<Object, IEclipseContext>();
        int totalAmount = this.prepareTaskProgressTracking(log, progressService, taskContexts);
        this.context.set("org.eclipse.tea.core.prepared_task_contexts", taskContexts);
        this.notifyAll(BeginTaskChain.class, this.context);
        SubMonitor rootMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(monitor != null ? "" : TaskingModel.getTaskChainName(this.chain)), (int)totalAmount);
        try {
            try {
                for (Map.Entry ctx : taskContexts.entrySet()) {
                    String estimationId;
                    Object task = ctx.getKey();
                    IEclipseContext taskCtx = (IEclipseContext)ctx.getValue();
                    Integer amount = (Integer)taskCtx.get("org.eclipse.tea.core.task_work");
                    String taskName = TaskingModel.getTaskName(task);
                    SubMonitor taskMonitor = rootMonitor.split(amount.intValue()).setWorkRemaining(amount.intValue());
                    taskMonitor.setTaskName(taskName);
                    TaskProgressTracker tracker = new TaskProgressTrackerImpl(task, taskMonitor);
                    taskCtx.set(TaskProgressExtendedTracker.class, (Object)tracker);
                    this.notifyAll(BeginTask.class, taskCtx);
                    String string = estimationId = progressService == null ? null : progressService.calculateId(task);
                    if (estimationId != null) {
                        progressService.begin(estimationId, tracker);
                        tracker = new TaskProgressTrackerImpl.RestrictedProgressTrackerImpl(tracker);
                    }
                    taskCtx.set(TaskProgressTracker.class, (Object)tracker);
                    try {
                        TaskExecutionContext.executeSingleTask(log, task, taskCtx);
                    }
                    finally {
                        if (rootMonitor.isCanceled()) {
                            taskCtx.set(IStatus.class, (Object)Status.CANCEL_STATUS);
                        }
                        IStatus taskStatus = (IStatus)taskCtx.get(IStatus.class);
                        status.add(taskStatus);
                        if (estimationId != null && progressService != null) {
                            progressService.finish(estimationId, taskStatus);
                        }
                        this.notifyAll(FinishTask.class, taskCtx);
                    }
                    IStatus taskStatus = (IStatus)taskCtx.get(IStatus.class);
                    if (taskStatus.getSeverity() < 4) continue;
                    log.error("Task aborted with status " + taskStatus);
                    break;
                }
            }
            catch (Throwable t) {
                status.add((IStatus)new Status(4, "org.eclipse.tea.core", "Failed to texecute " + this.toString(), t));
                throw t;
            }
        }
        finally {
            this.notifyAll(FinishTaskChain.class, this.context);
            this.notifyAll(DisposeContext.class, this.context);
            this.context.deactivate();
        }
    }

    private static void executeSingleTask(TaskingLog log, Object task, IEclipseContext taskCtx) {
        OutputRedirector redir = new OutputRedirector(task, log);
        taskCtx.set(IStatus.class, (Object)new Status(0, "org.eclipse.tea.core", "Task: " + TaskingModel.getTaskName(task)));
        try {
            try {
                redir.begin();
                taskCtx.activate();
                Object result = ContextInjectionFactory.invoke((Object)task, Execute.class, (IEclipseContext)taskCtx);
                if (result instanceof IStatus) {
                    taskCtx.set(IStatus.class, (Object)((IStatus)result));
                }
            }
            catch (Throwable t) {
                if (t instanceof InjectionException && t.getCause() instanceof OperationCanceledException) {
                    OperationCanceledException oce = (OperationCanceledException)t.getCause();
                    taskCtx.set(IStatus.class, (Object)new Status(8, "org.eclipse.tea.core", "Cancelled: " + TaskingModel.getTaskName(task), (Throwable)oce));
                } else {
                    taskCtx.set(IStatus.class, (Object)new Status(4, "org.eclipse.tea.core", FATAL_FAILURE_WHILE_EXECUTING + TaskingModel.getTaskName(task), t));
                }
                redir.finish();
                taskCtx.deactivate();
            }
        }
        finally {
            redir.finish();
            taskCtx.deactivate();
        }
    }

    private int prepareTaskProgressTracking(TaskingLog log, TaskProgressEstimationService progressService, Map<Object, IEclipseContext> taskContexts) {
        List<Object> instances = this.prepareTaskInstances();
        this.context.set("org.eclipse.tea.core.prepared_tasks", instances);
        int totalAmount = 0;
        for (Object o : instances) {
            totalAmount += this.prepareSingleTaskProgressTracking(log, progressService, taskContexts, o);
        }
        return totalAmount;
    }

    private int prepareSingleTaskProgressTracking(TaskingLog log, TaskProgressEstimationService progressService, Map<Object, IEclipseContext> taskContexts, Object o) {
        Integer amount = this.getTaskWorkAmount(log, o, progressService);
        IEclipseContext taskContext = this.context.createChild(o.getClass().getName());
        taskContext.set("org.eclipse.tea.core.task_work", (Object)amount);
        taskContext.set("org.eclipse.tea.core.task", o);
        taskContexts.put(o, taskContext);
        return amount;
    }

    private Integer getTaskWorkAmount(TaskingLog log, Object o, TaskProgressEstimationService service) {
        String id;
        String string = id = service == null ? null : service.calculateId(o);
        if (id != null) {
            return service.getEstimatedTicks(id);
        }
        try {
            return (Integer)ContextInjectionFactory.invoke((Object)o, TaskProgressTracker.TaskProgressProvider.class, (IEclipseContext)this.context, (Object)1);
        }
        catch (Exception e) {
            log.debug("Failed to determine amount of work for " + TaskingModel.getTaskName(o), e);
            return 1;
        }
    }

    private List<Object> prepareTaskInstances() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : this.tasks) {
            if (o instanceof Class) {
                o = ContextInjectionFactory.make((Class)((Class)o), (IEclipseContext)this.context);
            }
            result.add(o);
        }
        return result;
    }

    private boolean isSuppressed(Class<? extends TaskChain> tcClass) {
        TaskChainSuppressLifecycle ann = tcClass.getAnnotation(TaskChainSuppressLifecycle.class);
        return ann != null && ann.value();
    }

    private void notifyAll(Class<? extends Annotation> event, IEclipseContext ctx) {
        if (this.isSuppressed(this.chain.getClass())) {
            return;
        }
        for (TaskingLifeCycleListener l : this.listeners) {
            ContextInjectionFactory.invoke((Object)l, event, (IEclipseContext)ctx, null);
        }
    }

    public String toString() {
        return "ExecutionContext[" + this.chain.getClass().getName() + "]";
    }
}

