/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.geographic.preferences.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GeographicPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID_STEM_GEOGRAPHIC_VIEW_PREFERENCE_PAGE = "org.eclipse.stem.ui.views.geographic.preferences.GeographicViewPreferencePage";
    private static final int FIELD_WIDTH = 11;
    private BooleanFieldEditor drawPolygonBordersFieldEditor;
    private ColorFieldEditor borderColorFieldEditor;
    private BooleanFieldEditor logScaleFieldEditor;
    private StringFieldEditor gainFactorFieldEditor;

    public GeographicPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("GeoPPage.Viz"));
    }

    protected void createFieldEditors() {
        this.drawPolygonBordersFieldEditor = new BooleanFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.polygonborders", Messages.getString("GeoPPage.drawpolyborders"), this.getFieldEditorParent());
        this.borderColorFieldEditor = new ColorFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.bordercolor", Messages.getString("GeoPPage.bc"), this.getFieldEditorParent());
        this.logScaleFieldEditor = new BooleanFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.logscale", Messages.getString("GeoPPage.logscale"), this.getFieldEditorParent());
        this.gainFactorFieldEditor = new StringFieldEditor("org.eclipse.stem.ui.views.geographic.map.preferences.gainfactor", Messages.getString("GeoPPage.gainf"), 11, this.getFieldEditorParent());
        this.gainFactorFieldEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.drawPolygonBordersFieldEditor);
        this.addField((FieldEditor)this.borderColorFieldEditor);
        this.addField((FieldEditor)this.logScaleFieldEditor);
        this.addField((FieldEditor)this.gainFactorFieldEditor);
    }

    protected void checkState() {
        super.checkState();
        if (this.isValid()) {
            try {
                double factor = Double.parseDouble(this.gainFactorFieldEditor.getStringValue());
                if (factor <= 0.0) {
                    this.setErrorMessage(Messages.getString("GFactor.negErr"));
                    this.setValid(false);
                }
            }
            catch (Exception exception) {
                this.setErrorMessage(Messages.getString("GeoPPage.numErr"));
                this.setValid(false);
            }
        }
    }

    public void init(IWorkbench workbench) {
    }
}

