/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.graphgenerators.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.graphgenerators.GraphGenerator;
import org.eclipse.stem.graphgenerators.PajekNetGraphGenerator;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.graphgenerators.wizards.GraphGeneratorPropertyComposite;
import org.eclipse.stem.ui.graphgenerators.wizards.Messages;
import org.eclipse.stem.ui.graphgenerators.wizards.NewGraphWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class GraphGeneratorDefinitionControl
extends Composite {
    private static GraphGenerator[] graphGenerators = null;
    private final Combo combo;
    private final GraphGeneratorPropertyComposite graphGeneratorPropertyComposite;
    private NewGraphWizard newGraphWizard = null;
    private ModifyListener projectValidator;

    public GraphGeneratorDefinitionControl(Composite parent, int style, ModifyListener projectValidator, IProject project, NewGraphWizard ngw) {
        super(parent, style);
        this.projectValidator = projectValidator;
        this.newGraphWizard = ngw;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label graphGeneratorLabel = new Label((Composite)this, 0);
        GridData gd_graphGeneratorLabel = new GridData(4, 0x1000000, true, false);
        gd_graphGeneratorLabel.widthHint = 100;
        graphGeneratorLabel.setLayoutData((Object)gd_graphGeneratorLabel);
        graphGeneratorLabel.setText(Messages.getString("GGDC.0"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(Messages.getString("GGDC.1"));
        this.combo.setItems(this.getGraphGeneratorNames(this.getGraphGenerators()));
        this.combo.select(0);
        this.graphGeneratorPropertyComposite = new GraphGeneratorPropertyComposite(this, 0, this.getGraphGenerators(), projectValidator, project);
        GridData gd_graphGeneratorPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.graphGeneratorPropertyComposite.setLayoutData(gd_graphGeneratorPropertyControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphGeneratorDefinitionControl.this.graphGeneratorPropertyComposite.displayGraphGenerator(GraphGeneratorDefinitionControl.this.getGraphGenerators()[GraphGeneratorDefinitionControl.this.combo.getSelectionIndex()]);
                ((GraphGeneratorDefinitionControl)GraphGeneratorDefinitionControl.this).newGraphWizard.newDublinCorePage.updateDublinCorePage(GraphGeneratorDefinitionControl.this.getSelectedGraphGenerator().getDublinCore());
                GraphGeneratorDefinitionControl.this.projectValidator.modifyText(null);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newgraph_contextid");
    }

    private GraphGenerator[] getGraphGenerators() {
        if (graphGenerators == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] graphGeneratorConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.graphgenerators.graphgenerator");
            ArrayList<GraphGenerator> temp = new ArrayList<GraphGenerator>();
            graphGenerators = new GraphGenerator[graphGeneratorConfigElements.length];
            int i = 0;
            while (i < graphGeneratorConfigElements.length) {
                IConfigurationElement element = graphGeneratorConfigElements[i];
                if (element.getName().equals("classdef")) {
                    try {
                        temp.add((GraphGenerator)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Activator.logError((String)Messages.getString("GGDC.3"), (Throwable)e);
                    }
                }
                ++i;
            }
            graphGenerators = temp.toArray(new GraphGenerator[0]);
        }
        GraphGenerator[] graphGeneratorArray = graphGenerators;
        int n = graphGenerators.length;
        int n2 = 0;
        while (n2 < n) {
            DublinCore dublinCore;
            GraphGenerator graphGenerator = graphGeneratorArray[n2];
            if (graphGenerator != null && (dublinCore = org.eclipse.stem.graphgenerators.Activator.getPluginDublinCore((GraphGenerator)graphGenerator)) != null) {
                graphGenerator.setDublinCore(dublinCore);
            }
            ++n2;
        }
        return graphGenerators;
    }

    private String[] getGraphGeneratorNames(GraphGenerator[] graphGenerators) {
        String[] retValue = new String[graphGenerators.length];
        int i = 0;
        while (i < graphGenerators.length) {
            String name = graphGenerators[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = graphGenerators[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    GraphGenerator getSelectedGraphGenerator() {
        GraphGenerator retValue = (GraphGenerator)EcoreUtil.copy((EObject)this.getGraphGenerators()[this.combo.getSelectionIndex()]);
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.graphGeneratorPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.graphGeneratorPropertyComposite.getErrorMessage();
    }

    public Graph getGraph(String fileName) {
        GraphGenerator gg = (GraphGenerator)EcoreUtil.copy((EObject)this.getGraphGenerators()[this.combo.getSelectionIndex()]);
        if (gg instanceof PajekNetGraphGenerator) {
            ((PajekNetGraphGenerator)gg).setGraphFileName(fileName);
        }
        Graph retValue = this.graphGeneratorPropertyComposite.getGraph(gg);
        return retValue;
    }
}

