/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;

public abstract class ApiElement
implements IApiElement {
    private int fType = 0;
    private String fName = null;
    private IApiElement fParent = null;

    protected ApiElement(IApiElement parent, int type, String name) {
        this.fParent = parent;
        this.fType = type;
        this.fName = name;
    }

    public IApiElement getAncestor(int ancestorType) {
        IApiElement parent = this.fParent;
        while (parent != null && parent.getType() != ancestorType) {
            parent = parent.getParent();
        }
        return parent;
    }

    public String getName() {
        return this.fName;
    }

    public IApiElement getParent() {
        return this.fParent;
    }

    public int getType() {
        return this.fType;
    }

    protected void setName(String newname) {
        if (newname != null) {
            this.fName = newname;
        }
    }

    protected void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    public IApiComponent getApiComponent() {
        return (IApiComponent)this.getAncestor(1);
    }
}

