/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.ModelGenerator;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.stem.model.ui.wizards.GeneratorOptionsPage;
import org.eclipse.stem.model.ui.wizards.PackagePropertiesPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ModelGeneratorWizard
extends Wizard {
    protected IStatus status;
    protected PackagePropertiesPage packagePage;
    protected GeneratorOptionsPage advancedOptionsPage;
    protected Package modelPackage;

    public ModelGeneratorWizard(Package pkg) {
        this.setNeedsProgressMonitor(true);
        this.modelPackage = pkg;
    }

    public void setPackage(Package pkg) {
        this.modelPackage = pkg;
        if (this.packagePage != null) {
            this.packagePage.setPackage(this.modelPackage);
        }
        if (this.advancedOptionsPage != null) {
            this.advancedOptionsPage.setPackage(this.modelPackage);
        }
    }

    public void addPages() {
        this.packagePage = new PackagePropertiesPage(this.modelPackage);
        this.advancedOptionsPage = new GeneratorOptionsPage(this.modelPackage);
        this.addPage((IWizardPage)this.packagePage);
        this.addPage((IWizardPage)this.advancedOptionsPage);
    }

    public boolean performFinish() {
        this.packagePage.applyChanges();
        boolean done = true;
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        ModelGeneratorWizard.this.status = Status.OK_STATUS;
                        monitor.beginTask("Generating Models ", 100);
                        try {
                            try {
                                ModelGenerator generator = new ModelGenerator(ModelGeneratorWizard.this.modelPackage);
                                generator.transform((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                generator.generate((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                            }
                            catch (Throwable e) {
                                ModelGeneratorWizard.this.status = new Status(4, "org.eclipse.stem.model.ui", e.getMessage(), e);
                                MetamodelEditorPlugin.log(ModelGeneratorWizard.this.status);
                                throw new CoreException(ModelGeneratorWizard.this.status);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception exception) {
                if (this.status != null && this.status != Status.OK_STATUS) {
                    done = false;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error generating models", null, (IStatus)this.status);
                }
            }
        }
        finally {
            if (this.status != null && this.status != Status.OK_STATUS) {
                done = false;
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error generating models", null, (IStatus)this.status);
            }
        }
        return done;
    }
}

