/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.model.ctdl.ui.embed.EmbeddedExpressionEditorComposite;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.wizards.TransitionEditorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModelTransitionsPage
extends WizardPage {
    protected EmbeddedExpressionEditorComposite editor;
    protected Composite container;
    protected ComboViewer transitionsComboViewer;
    protected Button addTransitionButton;
    protected Button editTransitionButton;
    protected Button removeTransitionButton;
    protected Label transitionsInformationLabel;
    protected Model model;

    public ModelTransitionsPage(Model model) {
        super("Model Transitions");
        this.setTitle("Model Compartment Transitions");
        this.setDescription("Define the transitions between compartments for your model");
        this.model = model;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.transitionsInformationLabel = new Label(this.container, 0);
        this.transitionsInformationLabel.setText("Define the transitions and expressions for the model compartments");
        GridData labelGridData = new GridData(4);
        labelGridData.horizontalSpan = 3;
        this.transitionsInformationLabel.setLayoutData((Object)labelGridData);
        this.createTransitionViewer(this.container);
        this.createExpressionEditor(this.container);
        this.setControl((Control)this.container);
    }

    protected void createTransitionViewer(Composite parent) {
        Label dataTypeLabel = new Label(parent, 0);
        dataTypeLabel.setText("Transition");
        this.transitionsComboViewer = new ComboViewer(parent, 8);
        this.transitionsComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.transitionsComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.transitionsComboViewer.setLabelProvider((IBaseLabelProvider)new TransitionsNameLabelProvider());
        this.transitionsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelTransitionsPage.this.selectTransition();
            }
        });
        this.transitionsComboViewer.setInput((Object)this.model.getTransitions());
        Composite transitionsButtonComposite = new Composite(parent, 0);
        GridLayout transitionButtonCompositeLayout = new GridLayout(3, false);
        transitionButtonCompositeLayout.horizontalSpacing = 2;
        transitionsButtonComposite.setLayout((Layout)transitionButtonCompositeLayout);
        this.addTransitionButton = new Button(transitionsButtonComposite, 8);
        this.addTransitionButton.setText("Add");
        this.addTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelTransitionsPage.this.addTransition();
            }
        });
        this.editTransitionButton = new Button(transitionsButtonComposite, 8);
        this.editTransitionButton.setText("Edit");
        this.editTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelTransitionsPage.this.editTransition();
            }
        });
        this.removeTransitionButton = new Button(transitionsButtonComposite, 8);
        this.removeTransitionButton.setText("Remove");
        this.removeTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelTransitionsPage.this.removeTransition();
            }
        });
        transitionsButtonComposite.pack();
    }

    private Transition openTransitionEditorDialog(Transition previousTransition) {
        Transition transitionToUse = null;
        transitionToUse = previousTransition == null ? MetamodelFactory.eINSTANCE.createTransition() : (Transition)EcoreUtil.copy((EObject)previousTransition);
        TransitionEditorDialog editorDialog = new TransitionEditorDialog(this.getShell(), 0, this.model, transitionToUse, previousTransition);
        if (editorDialog.open() == 0) {
            return transitionToUse;
        }
        return null;
    }

    private void addTransition() {
        Transition transition = this.openTransitionEditorDialog(null);
        if (transition != null) {
            this.model.getTransitions().add((Object)transition);
            this.transitionsComboViewer.refresh();
            this.setSelectedTransition(transition);
        }
    }

    private void editTransition() {
        Transition previous;
        Transition edited;
        Transition selected = this.getSelectedTransition();
        if (selected != null && (edited = this.openTransitionEditorDialog(previous = selected)) != null) {
            Collections.replaceAll(this.model.getTransitions(), previous, edited);
            this.transitionsComboViewer.refresh();
            this.setSelectedTransition(edited);
        }
    }

    private void removeTransition() {
        Transition selected = this.getSelectedTransition();
        if (selected != null) {
            this.model.getTransitions().remove((Object)selected);
            this.transitionsComboViewer.refresh();
        }
    }

    protected void selectTransition() {
        this.editor.setTransition(this.getSelectedTransition());
    }

    private void setSelectedTransition(Transition transition) {
        this.transitionsComboViewer.setSelection((ISelection)new StructuredSelection((Object)transition));
    }

    private Transition getSelectedTransition() {
        return (Transition)((StructuredSelection)this.transitionsComboViewer.getSelection()).getFirstElement();
    }

    protected void createExpressionEditor(Composite parent) {
        this.editor = new EmbeddedExpressionEditorComposite(parent, 0);
        GridData editorData = new GridData(1808);
        editorData.horizontalSpan = 3;
        this.editor.setLayoutData((Object)editorData);
    }

    boolean validatePage() {
        this.editor.verifySaveChanges();
        return true;
    }

    private static class TransitionsNameLabelProvider
    extends LabelProvider {
        private TransitionsNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Transition) {
                Transition t = (Transition)element;
                return String.valueOf(t.getSource().getName()) + " -> " + t.getTarget().getName();
            }
            return "";
        }
    }
}

