/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.modifier.DoubleModifier;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.modifier.ModifierFactory;
import org.eclipse.stem.core.predicate.And;
import org.eclipse.stem.core.predicate.ElapsedTimeTest;
import org.eclipse.stem.core.predicate.IdentifiablePredicateExpression;
import org.eclipse.stem.core.predicate.Not;
import org.eclipse.stem.core.predicate.Predicate;
import org.eclipse.stem.core.predicate.PredicateFactory;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.trigger.TriggerFactory;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.EdgesPackage;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.PajekNetGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;
import org.eclipse.stem.graphgenerators.impl.PajekNetGraphGeneratorImplOld;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PajekNetGraphGeneratorImpl
extends GraphGeneratorImpl
implements PajekNetGraphGenerator {
    private IProject project;
    private String fileName;
    protected static final String DATA_FILE_EDEFAULT = "";
    protected String dataFile = "";
    protected static final double SCALING_FACTOR_EDEFAULT = 1.0;
    protected double scalingFactor = 1.0;
    protected static final double NODE_SIZE_EDEFAULT = 0.1;
    protected double nodeSize = 0.1;
    protected static final boolean USE_REGION_URI_EDEFAULT = false;
    protected boolean useRegionURI = false;
    protected static final boolean MOVE_NODES_TO_CONTAINERS_EDEFAULT = false;
    protected boolean moveNodesToContainers = false;
    protected static final boolean USE_ABSOLUTE_RATES_EDEFAULT = true;
    protected boolean useAbsoluteRates = true;

    @Override
    protected EClass eStaticClass() {
        return GraphgeneratorsPackage.Literals.PAJEK_NET_GRAPH_GENERATOR;
    }

    @Override
    public String getDataFile() {
        return this.dataFile;
    }

    @Override
    public void setDataFile(String newDataFile) {
        String oldDataFile = this.dataFile;
        this.dataFile = newDataFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDataFile, (Object)this.dataFile));
        }
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void setScalingFactor(double newScalingFactor) {
        double oldScalingFactor = this.scalingFactor;
        this.scalingFactor = newScalingFactor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldScalingFactor, this.scalingFactor));
        }
    }

    @Override
    public double getNodeSize() {
        return this.nodeSize;
    }

    @Override
    public void setNodeSize(double newNodeSize) {
        double oldNodeSize = this.nodeSize;
        this.nodeSize = newNodeSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldNodeSize, this.nodeSize));
        }
    }

    @Override
    public boolean isUseRegionURI() {
        return this.useRegionURI;
    }

    @Override
    public void setUseRegionURI(boolean newUseRegionURI) {
        boolean oldUseRegionURI = this.useRegionURI;
        this.useRegionURI = newUseRegionURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldUseRegionURI, this.useRegionURI));
        }
    }

    @Override
    public boolean isMoveNodesToContainers() {
        return this.moveNodesToContainers;
    }

    @Override
    public void setMoveNodesToContainers(boolean newMoveNodesToContainers) {
        boolean oldMoveNodesToContainers = this.moveNodesToContainers;
        this.moveNodesToContainers = newMoveNodesToContainers;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldMoveNodesToContainers, this.moveNodesToContainers));
        }
    }

    @Override
    public boolean isUseAbsoluteRates() {
        return this.useAbsoluteRates;
    }

    @Override
    public void setUseAbsoluteRates(boolean newUseAbsoluteRates) {
        boolean oldUseAbsoluteRates = this.useAbsoluteRates;
        this.useAbsoluteRates = newUseAbsoluteRates;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldUseAbsoluteRates, this.useAbsoluteRates));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getDataFile();
            }
            case 4: {
                return this.getScalingFactor();
            }
            case 5: {
                return this.getNodeSize();
            }
            case 6: {
                return this.isUseRegionURI();
            }
            case 7: {
                return this.isMoveNodesToContainers();
            }
            case 8: {
                return this.isUseAbsoluteRates();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setDataFile((String)newValue);
                return;
            }
            case 4: {
                this.setScalingFactor((Double)newValue);
                return;
            }
            case 5: {
                this.setNodeSize((Double)newValue);
                return;
            }
            case 6: {
                this.setUseRegionURI((Boolean)newValue);
                return;
            }
            case 7: {
                this.setMoveNodesToContainers((Boolean)newValue);
                return;
            }
            case 8: {
                this.setUseAbsoluteRates((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setDataFile(DATA_FILE_EDEFAULT);
                return;
            }
            case 4: {
                this.setScalingFactor(1.0);
                return;
            }
            case 5: {
                this.setNodeSize(0.1);
                return;
            }
            case 6: {
                this.setUseRegionURI(false);
                return;
            }
            case 7: {
                this.setMoveNodesToContainers(false);
                return;
            }
            case 8: {
                this.setUseAbsoluteRates(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return DATA_FILE_EDEFAULT == null ? this.dataFile != null : !DATA_FILE_EDEFAULT.equals(this.dataFile);
            }
            case 4: {
                return this.scalingFactor != 1.0;
            }
            case 5: {
                return this.nodeSize != 0.1;
            }
            case 6: {
                return this.useRegionURI;
            }
            case 7: {
                return this.moveNodesToContainers;
            }
            case 8: {
                return !this.useAbsoluteRates;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataFile: ");
        result.append(this.dataFile);
        result.append(", scalingFactor: ");
        result.append(this.scalingFactor);
        result.append(", nodeSize: ");
        result.append(this.nodeSize);
        result.append(", useRegionURI: ");
        result.append(this.useRegionURI);
        result.append(", moveNodesToContainers: ");
        result.append(this.moveNodesToContainers);
        result.append(", useAbsoluteRates: ");
        result.append(this.useAbsoluteRates);
        result.append(')');
        return result.toString();
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public Graph getGraph() {
        Graph graph = null;
        File file = new File(this.getDataFile());
        if (file == null || !file.exists() || file.isDirectory()) {
            Activator.logError((String)"Pajek importing: File cannot be found", null);
        }
        try {
            graph = this.getGraph(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return graph;
    }

    @Override
    public void setGraphFileName(String fileName) {
        this.fileName = fileName;
    }

    private Graph getGraph(File pajekNETFileURI) throws IOException {
        String line;
        if (this.isOldFormat(pajekNETFileURI)) {
            PajekNetGraphGeneratorImplOld gen = new PajekNetGraphGeneratorImplOld(pajekNETFileURI, this.getScalingFactor());
            return gen.getGraph();
        }
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        BufferedReader reader = new BufferedReader(new FileReader(pajekNETFileURI));
        ArrayList<URI> nodeList = new ArrayList<URI>();
        TriggerList triggerList = TriggerFactory.eINSTANCE.createTriggerList();
        HashMap<URI, URI> containers = new HashMap<URI, URI>();
        int numNodes = 0;
        dc.populate();
        dc.setTitle("Pajek Import");
        dc.setSource(this.getClass().getSimpleName());
        dc.setValid(formatter.format(Calendar.getInstance().getTime()));
        triggerList.setURI(URI.createPlatformResourceURI((String)(String.valueOf(this.project.getName()) + "/triggers/" + this.fileName + ".trigger"), (boolean)false));
        numNodes = this.readNumberOfNodes(reader.readLine());
        if (numNodes == -1) {
            String error = "Error reading number of nodes!";
            Activator.logError((String)("Pajek importing " + pajekNETFileURI.getName() + ": " + error), null);
            this.showErrorMessage("Pajek importing " + pajekNETFileURI.getName() + ": " + error);
            reader.close();
            return null;
        }
        int i = 0;
        while (i < numNodes) {
            if (!this.readRegionNode(reader.readLine(), i + 1, graph, nodeList)) {
                String error = "Error reading node at line " + (i + 2) + "!";
                Activator.logError((String)("Pajek importing " + pajekNETFileURI.getName() + ": " + error), null);
                this.showErrorMessage("Pajek importing " + pajekNETFileURI.getName() + ": " + error);
                reader.close();
                return null;
            }
            ++i;
        }
        if (!this.readEdgeTag(reader.readLine())) {
            String error = "Error reading edge tag!";
            Activator.logError((String)("Pajek importing " + pajekNETFileURI.getName() + ": " + error), null);
            this.showErrorMessage("Pajek importing " + pajekNETFileURI.getName() + ": " + error);
            reader.close();
            return null;
        }
        i = 0;
        while ((line = reader.readLine()) != null && !line.trim().isEmpty()) {
            if (!this.readEdge(line, graph, nodeList, triggerList, containers)) {
                String error = "Error reading edge at line " + (i + numNodes + 3) + "!";
                Activator.logError((String)("Pajek importing " + pajekNETFileURI.getName() + ": " + error), null);
                this.showErrorMessage("Pajek importing " + pajekNETFileURI.getName() + ": " + error);
                reader.close();
                return null;
            }
            ++i;
        }
        reader.close();
        if (this.isMoveNodesToContainers()) {
            this.moveNodesToContainers(graph, containers);
        }
        if (!triggerList.getPredicateList().isEmpty()) {
            try {
                Utility.serializeIdentifiable((Identifiable)triggerList, (URI)triggerList.getURI());
                this.project.refreshLocal(2, null);
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        assert (graph.sane());
        return graph;
    }

    private int readNumberOfNodes(String line) {
        if (line == null) {
            return -1;
        }
        String[] toks = line.split(" ");
        if (toks.length != 2 || !toks[0].equalsIgnoreCase("*vertices")) {
            return -1;
        }
        try {
            return Integer.parseInt(toks[1]);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private void showErrorMessage(String message) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Status warning = new Status(4, "org.eclipse.stem.definitions", 1, message, null);
        ErrorDialog.openError((Shell)window.getShell(), null, null, (IStatus)warning);
    }

    private boolean readRegionNode(String line, int index, Graph graph, List<URI> nodeList) {
        if (line == null) {
            return false;
        }
        String[] toks = line.split(" ");
        if (toks.length == 2) {
            block18: {
                try {
                    if (Integer.parseInt(toks[0]) == index) break block18;
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (toks[1].startsWith("stem://")) {
                nodeList.add(STEMURI.createURI((String)toks[1]));
            } else {
                nodeList.add(RegionImpl.createRegionNodeURI((String)toks[1]));
            }
            return true;
        }
        String name = DATA_FILE_EDEFAULT;
        double x = 0.0;
        double y = 0.0;
        try {
            name = toks[1];
            x = Double.parseDouble(toks[2]);
            y = Double.parseDouble(toks[3]);
            if (Integer.parseInt(toks[0]) != index) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        Region node = NodesFactory.eINSTANCE.createRegion();
        DublinCore dc = node.getDublinCore();
        dc.setTitle(name);
        if (this.isUseRegionURI()) {
            node.setURI(STEMURI.createURI((String)("node/geo/region/" + name)));
        } else {
            node.setURI(STEMURI.createURI((String)("node/" + graph.getURI().lastSegment() + "/" + name)));
        }
        for (int i = 4; i < toks.length; i += 4) {
            try {
                if (toks[i].equalsIgnoreCase("popid") && toks[i + 2].equalsIgnoreCase("popcount")) {
                    PopulationLabel popLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
                    popLabel.setPopulationIdentifier(toks[i + 1]);
                    popLabel.setURIOfIdentifiableToBeLabeled(node.getURI());
                    popLabel.setNode((Node)node);
                    popLabel.getCurrentPopulationValue().setCount(Double.parseDouble(toks[i + 3]));
                    node.getLabels().add((Object)popLabel);
                    graph.getNodeLabels().put((Object)popLabel.getURI(), (Object)popLabel);
                    continue;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        node.getDublinCore().setSpatial(this.createNodeSpatialString(x *= this.getScalingFactor(), y *= this.getScalingFactor()));
        graph.getNodes().put((Object)node.getURI(), (Object)node);
        nodeList.add(node.getURI());
        return true;
    }

    private boolean readEdgeTag(String line) {
        return line != null && (line.trim().equalsIgnoreCase("*edges") || line.trim().equalsIgnoreCase("*arcs"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readEdge(String line, Graph graph, List<URI> nodeList, TriggerList triggerList, Map<URI, URI> containers) {
        block10: {
            if (line == null) {
                return false;
            }
            String[] toks = line.split(" ");
            try {
                if (toks.length >= 6 && toks[2].equalsIgnoreCase("popid") && toks[4].equalsIgnoreCase("rate")) {
                    int id1 = Integer.parseInt(toks[0]) - 1;
                    int id2 = Integer.parseInt(toks[1]) - 1;
                    String population = toks[3];
                    double rate = Double.parseDouble(toks[5]);
                    MigrationEdge edge = EdgesFactory.eINSTANCE.createMigrationEdge();
                    edge.setURI(STEMURI.createURI((String)("edge/migration/" + graph.getURI().lastSegment() + "/" + STEMURI.generateUniquePart())));
                    edge.setNodeAURI(nodeList.get(id1));
                    edge.setNodeBURI(nodeList.get(id2));
                    edge.setPopulationIdentifier(population);
                    edge.setUseAbsoluteValues(this.isUseAbsoluteRates());
                    edge.getLabel().setURIOfIdentifiableToBeLabeled(edge.getURI());
                    edge.getLabel().getCurrentValue().setMigrationRate(rate);
                    edge.getDublinCore().setTitle(this.createEdgeTitle(nodeList.get(id1), nodeList.get(id2), "MigrationEdge", true));
                    graph.getEdges().put((Object)edge.getURI(), (Object)edge);
                    if (toks.length == 6) {
                        return true;
                    }
                    int i = 6;
                    while (i < toks.length) {
                        if (!toks[i].equalsIgnoreCase("date") || !toks[i + 2].equalsIgnoreCase("rate")) {
                            return false;
                        }
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
                        Date triggerDate = dateFormat.parse(String.valueOf(toks[i + 1]) + "-00-00-00");
                        double triggerRate = Double.parseDouble(toks[i + 3]);
                        this.addToTriggerList(triggerList, edge, triggerDate, triggerRate);
                        i += 4;
                    }
                    break block10;
                }
                if (toks.length == 2) {
                    int id1 = Integer.parseInt(toks[0]) - 1;
                    int id2 = Integer.parseInt(toks[1]) - 1;
                    containers.put(nodeList.get(id2), nodeList.get(id1));
                    break block10;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            catch (ParseException e) {
                return false;
            }
        }
        return true;
    }

    private void moveNodesToContainers(Graph graph, Map<URI, URI> containers) {
        Map<URI, LatLong> spatials = this.getSpatials();
        HashMap<LatLong, HashSet<Node>> containedNodes = new HashMap<LatLong, HashSet<Node>>();
        for (Map.Entry<URI, URI> entry : containers.entrySet()) {
            Node node = graph.getNode(entry.getKey());
            LatLong container = spatials.get(entry.getValue());
            if (node == null || container == null) continue;
            Set nodes = (Set)containedNodes.get(container);
            if (nodes == null) {
                containedNodes.put(container, new HashSet<Node>(Arrays.asList(node)));
                continue;
            }
            nodes.add(node);
        }
        for (Map.Entry<Object, Object> entry : containedNodes.entrySet()) {
            LatLong container = (LatLong)entry.getKey();
            LatLong.Segment largestSegment = null;
            double largestArea = 0.0;
            for (LatLong.Segment segment : container.getSegments()) {
                double area = this.getArea(segment);
                if (!(area > largestArea)) continue;
                largestSegment = segment;
                largestArea = area;
            }
            Point2D.Double centroid = this.getCentroid(largestSegment);
            Set nodeSet = (Set)entry.getValue();
            Set<Point2D.Double> locationSet = this.getNodeLocations(centroid, nodeSet.size());
            ArrayList nodeList = new ArrayList(nodeSet);
            ArrayList<Point2D.Double> locationList = new ArrayList<Point2D.Double>(locationSet);
            int i = 0;
            while (i < nodeList.size()) {
                Node node = (Node)nodeList.get(i);
                Point2D.Double location = (Point2D.Double)locationList.get(i);
                node.getDublinCore().setSpatial(this.createNodeSpatialString(location.x, location.y));
                ++i;
            }
        }
    }

    private void addToTriggerList(TriggerList triggerList, MigrationEdge edge, Date date, double rate) {
        IdentifiablePredicateExpression predicate = PredicateFactory.eINSTANCE.createIdentifiablePredicateExpression();
        And andPredicate = PredicateFactory.eINSTANCE.createAnd();
        Not notPredicate = PredicateFactory.eINSTANCE.createNot();
        ElapsedTimeTest timeTest1 = PredicateFactory.eINSTANCE.createElapsedTimeTest();
        ElapsedTimeTest timeTest2 = PredicateFactory.eINSTANCE.createElapsedTimeTest();
        Modifier modifier = ModifierFactory.eINSTANCE.createModifier();
        DoubleModifier featureModifier = ModifierFactory.eINSTANCE.createDoubleModifier();
        STEMTime date1 = ModelFactory.eINSTANCE.createSTEMTime();
        STEMTime date2 = ModelFactory.eINSTANCE.createSTEMTime();
        date1.setTime((Date)date.clone());
        date2.setTime((Date)date.clone());
        timeTest1.setNumberofDays(0);
        timeTest1.setReferenceTime(date1);
        timeTest1.setReferenceTimeValid(true);
        timeTest2.setNumberofDays(1);
        timeTest2.setReferenceTime(date2);
        timeTest2.setReferenceTimeValid(true);
        notPredicate.setOperand((Predicate)timeTest2);
        andPredicate.getOperands().add((Object)timeTest1);
        andPredicate.getOperands().add((Object)notPredicate);
        predicate.setPredicate((Predicate)andPredicate);
        featureModifier.setEStructuralFeature((EStructuralFeature)EdgesPackage.Literals.MIGRATION_EDGE_LABEL_VALUE__MIGRATION_RATE);
        featureModifier.setTarget((EObject)edge.getLabel());
        featureModifier.setValue(rate);
        modifier.setTargetURI(edge.getLabel().getURI());
        modifier.getFeatureModifiers().add((Object)featureModifier);
        triggerList.getPredicateList().add((Object)predicate);
        triggerList.getActionList().add((Object)modifier);
    }

    private String createNodeSpatialString(double x, double y) {
        LatLong latlon = new LatLong();
        LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
        double size = this.getNodeSize();
        sb.add(y - size / 2.0, x - size / 2.0);
        sb.add(y - size / 2.0, x + size / 2.0);
        sb.add(y + size / 2.0, x + size / 2.0);
        sb.add(y + size / 2.0, x - size / 2.0);
        sb.add(y - size / 2.0, x - size / 2.0);
        latlon.add(sb.toSegment());
        return InlineLatLongDataProvider.createSpatialInlineURIString((LatLong)latlon);
    }

    private String createEdgeTitle(URI nodeA, URI nodeB, String typeName, boolean directed) {
        String nA = nodeA.lastSegment();
        String nB = nodeB.lastSegment();
        String title = null;
        title = directed ? String.valueOf(typeName) + "[(" + nA + ")->(" + nB + ")]" : String.valueOf(typeName) + "[(" + nA + ")<->(" + nB + ")]";
        return title;
    }

    private Map<URI, LatLong> getSpatials() {
        Identifiable id;
        URI uri;
        IResource r;
        int n;
        int n2;
        Object object;
        HashMap<URI, LatLong> latLongs = new HashMap<URI, LatLong>();
        ArrayList<Graph> graphList = new ArrayList<Graph>();
        IFolder modelFolder = this.project.getFolder("models");
        IFolder graphsFolder = this.project.getFolder("graphs");
        IResource[] models = null;
        IResource[] graphs = null;
        try {
            models = modelFolder.members();
            graphs = graphsFolder.members();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (models != null) {
            object = models;
            n2 = models.length;
            n = 0;
            while (n < n2) {
                r = object[n];
                if (r.getName().endsWith(".model")) {
                    try {
                        uri = URI.createURI((String)r.getLocationURI().toString());
                        id = Utility.getIdentifiable((URI)uri);
                        graphList.add(((Model)id).getCanonicalGraphNoDecorate(STEMURI.createURI((String)DATA_FILE_EDEFAULT), null, null));
                    }
                    catch (ScenarioInitializationException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                ++n;
            }
        }
        if (graphs != null) {
            object = graphs;
            n2 = graphs.length;
            n = 0;
            while (n < n2) {
                r = object[n];
                if (r.getName().endsWith(".graph")) {
                    uri = URI.createURI((String)r.getLocationURI().toString());
                    id = Utility.getIdentifiable((URI)uri);
                    graphList.add((Graph)id);
                }
                ++n;
            }
        }
        for (Graph graph : graphList) {
            for (Node n3 : graph.getNodes().values()) {
                LatLongProvider latLongProvider = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)n3, LatLongProvider.class);
                latLongs.put(n3.getURI(), latLongProvider.getLatLong());
            }
        }
        return latLongs;
    }

    private double getArea(LatLong.Segment segment) {
        double area = 0.0;
        int i = 0;
        while (i < segment.size() - 1) {
            double x1 = segment.longitude(i);
            double y1 = segment.latitude(i);
            double x2 = segment.longitude(i + 1);
            double y2 = segment.latitude(i + 1);
            area += x1 * y2 - x2 * y1;
            ++i;
        }
        return Math.abs(area /= 2.0);
    }

    private Point2D.Double getCentroid(LatLong.Segment segment) {
        double area = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        int i = 0;
        while (i < segment.size() - 1) {
            double x1 = segment.longitude(i);
            double y1 = segment.latitude(i);
            double x2 = segment.longitude(i + 1);
            double y2 = segment.latitude(i + 1);
            double mem = x1 * y2 - x2 * y1;
            area += mem;
            cx += (x1 + x2) * mem;
            cy += (y1 + y2) * mem;
            ++i;
        }
        return new Point2D.Double(cx /= 6.0 * (area /= 2.0), cy /= 6.0 * area);
    }

    private Set<Point2D.Double> getNodeLocations(Point2D.Double center, int n) {
        HashSet<Point2D.Double> locationSet = new HashSet<Point2D.Double>();
        double distance = this.getNodeSize() * 1.5;
        int i = 0;
        int d = 1;
        while (true) {
            int dx = -d;
            while (dx <= d) {
                int dy = -d;
                while (dy <= d) {
                    double y;
                    double x;
                    Point2D.Double location;
                    if (!(dx == 0 && dy == 0 || locationSet.contains(location = new Point2D.Double(x = center.x + (double)dx * distance, y = center.y + (double)dy * distance)))) {
                        locationSet.add(location);
                        if (++i == n) {
                            return locationSet;
                        }
                    }
                    ++dy;
                }
                ++dx;
            }
            ++d;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOldFormat(File pajekNETFileURI) {
        block11: {
            try {
                reader = new BufferedReader(new FileReader(pajekNETFileURI));
                reader.readLine();
                while (true) {
                    if ((line = reader.readLine()).contains("*Arcs")) {
                        reader.close();
                        return true;
                    }
                    if (!line.contains("*Edges")) {
                        tokens = line.replaceAll("\"[^\"]*\"", "id").split(" ");
                        if (tokens.length < 5) continue;
                        try {
                            Double.parseDouble(tokens[4]);
                            return true;
                        }
                        catch (NumberFormatException var5_6) {
                            if (tokens[4].equals("triangle") || tokens[4].equals("cross") || tokens[4].equals("ellipse") || tokens[4].equals("box") || tokens[4].equals("diamond") || tokens[4].equals("s_size")) ** break;
                            continue;
                            reader.close();
                            return true;
                        }
                    }
                    break block11;
                    break;
                }
            }
            catch (Exception var2_3) {
                // empty catch block
            }
            return false;
        }
        while (true) {
            if ((line = reader.readLine()) == null) {
                reader.close();
                return false;
            }
            tokens = line.replaceAll("\"[^\"]*\"", "id").split(" ");
            if (tokens.length < 3) continue;
            try {
                Double.parseDouble(tokens[2]);
                return true;
            }
            catch (NumberFormatException var5_8) {
                continue;
            }
            break;
        }
    }
}

