/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.presentation.CoreEditorPlugin;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;
import org.eclipse.stem.jobs.execution.IExecutable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.handlers.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public abstract class STEMExecutionCommandHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        boolean switchPerspective = false;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        boolean useSimulationPerspective = true;
        if (selection instanceof StructuredSelection) {
            for (Object obj : ((StructuredSelection)selection).toList()) {
                IExecutable executable = (IExecutable)Platform.getAdapterManager().getAdapter(obj, IExecutable.class);
                if (executable instanceof Adapter) {
                    Adapter a = (Adapter)executable;
                    Notifier aObj = a.getTarget();
                    switchPerspective = aObj instanceof ScenarioImpl;
                }
                if (executable != null) {
                    this.waitOnBuildComplete();
                    this.doit(executable);
                    continue;
                }
                Activator.logError("STEM Internal error execution command applied to \"" + obj.getClass().getName() + "\"", null);
            }
        }
        if (switchPerspective && useSimulationPerspective) {
            Activator.switchToPerspective("org.eclipse.stem.ui.STEMSimulationPerspective");
        }
        return null;
    }

    private void waitOnBuildComplete() {
        final IJobManager jobManager = Job.getJobManager();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        if (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.STEMExecutionCommandHandler_2, (int)100);
                    try {
                        jobManager.join(ResourcesPlugin.FAMILY_MANUAL_BUILD, (IProgressMonitor)subMonitor.split(1));
                        jobManager.join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)subMonitor.split(1));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e2) {
                CoreEditorPlugin.INSTANCE.log(e2);
            }
        }
    }

    protected abstract void doit(IExecutable var1);

    public static class PauseCommandHandler
    extends STEMExecutionCommandHandler {
        @Override
        protected void doit(IExecutable executable) {
            executable.pause();
        }
    }

    public static class ResetCommandHandler
    extends STEMExecutionCommandHandler {
        @Override
        protected void doit(IExecutable executable) {
            try {
                executable.reset();
            }
            catch (ScenarioInitializationException sie) {
                Utility.handleException((String)sie.getErrorMessage(), (boolean)true, (ScenarioInitializationException)sie);
            }
        }
    }

    public static class RunCommandHandler
    extends STEMExecutionCommandHandler {
        @Override
        protected void doit(IExecutable executable) {
            executable.run();
        }
    }

    public static class StepCommandHandler
    extends STEMExecutionCommandHandler {
        @Override
        protected void doit(IExecutable executable) {
            executable.step();
        }
    }

    public static class StopCommandHandler
    extends STEMExecutionCommandHandler {
        @Override
        protected void doit(IExecutable executable) {
            executable.stop();
        }
    }
}

