/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.loggers.imagewriter.AzimuthalEquidistantMapLogger;
import org.eclipse.stem.loggers.imagewriter.EquirectangularMapLogger;
import org.eclipse.stem.loggers.imagewriter.ImagewriterFactory;
import org.eclipse.stem.loggers.imagewriter.ImagewriterPackage;
import org.eclipse.stem.loggers.imagewriter.MAP_PROJECTIONS;
import org.eclipse.stem.loggers.imagewriter.MapViewImageWriterLogger;
import org.eclipse.stem.loggers.imagewriter.MercatorMapLogger;
import org.eclipse.stem.loggers.imagewriter.OrthographicMapLogger;
import org.eclipse.stem.loggers.imagewriter.impl.AzimuthalEquidistantMapLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.impl.EquirectangularMapLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.impl.MapViewImageWriterLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.impl.MercatorMapLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.impl.OrthographicMapLoggerImpl;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;
import org.eclipse.stem.ui.adapters.color.ColorProvider;

public class ImagewriterFactoryImpl
extends EFactoryImpl
implements ImagewriterFactory {
    public static ImagewriterFactory init() {
        try {
            ImagewriterFactory theImagewriterFactory = (ImagewriterFactory)EPackage.Registry.INSTANCE.getEFactory("http://org/eclipse/stem/loggers/imagewriter");
            if (theImagewriterFactory != null) {
                return theImagewriterFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ImagewriterFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createMapViewImageWriterLogger();
            }
            case 3: {
                return this.createEquirectangularMapLogger();
            }
            case 4: {
                return this.createMercatorMapLogger();
            }
            case 6: {
                return this.createAzimuthalEquidistantMapLogger();
            }
            case 7: {
                return this.createOrthographicMapLogger();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createMAP_PROJECTIONSFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createIMapProjectionFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createColorProviderFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertMAP_PROJECTIONSToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertIMapProjectionToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertColorProviderToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public MapViewImageWriterLogger createMapViewImageWriterLogger() {
        MapViewImageWriterLoggerImpl mapViewImageWriterLogger = new MapViewImageWriterLoggerImpl();
        return mapViewImageWriterLogger;
    }

    @Override
    public EquirectangularMapLogger createEquirectangularMapLogger() {
        EquirectangularMapLoggerImpl equirectangularMapLogger = new EquirectangularMapLoggerImpl();
        return equirectangularMapLogger;
    }

    @Override
    public MercatorMapLogger createMercatorMapLogger() {
        MercatorMapLoggerImpl mercatorMapLogger = new MercatorMapLoggerImpl();
        return mercatorMapLogger;
    }

    @Override
    public AzimuthalEquidistantMapLogger createAzimuthalEquidistantMapLogger() {
        AzimuthalEquidistantMapLoggerImpl azimuthalEquidistantMapLogger = new AzimuthalEquidistantMapLoggerImpl();
        return azimuthalEquidistantMapLogger;
    }

    @Override
    public OrthographicMapLogger createOrthographicMapLogger() {
        OrthographicMapLoggerImpl orthographicMapLogger = new OrthographicMapLoggerImpl();
        return orthographicMapLogger;
    }

    public MAP_PROJECTIONS createMAP_PROJECTIONSFromString(EDataType eDataType, String initialValue) {
        MAP_PROJECTIONS result = MAP_PROJECTIONS.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMAP_PROJECTIONSToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IMapProjection createIMapProjectionFromString(EDataType eDataType, String initialValue) {
        return (IMapProjection)super.createFromString(eDataType, initialValue);
    }

    public String convertIMapProjectionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ColorProvider createColorProviderFromString(EDataType eDataType, String initialValue) {
        return (ColorProvider)super.createFromString(eDataType, initialValue);
    }

    public String convertColorProviderToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ImagewriterPackage getImagewriterPackage() {
        return (ImagewriterPackage)this.getEPackage();
    }

    @Deprecated
    public static ImagewriterPackage getPackage() {
        return ImagewriterPackage.eINSTANCE;
    }
}

