/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.diseasemodels.example.presentation;

import org.eclipse.core.resources.IProject;
import org.eclipse.stem.diseasemodels.example.ExampleDiseaseModel;
import org.eclipse.stem.diseasemodels.example.ExamplePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.diseasemodels.example.presentation.ExampleDiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.StandardDiseaseModelPropertyEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ExampleDiseaseModelPropertyEditor
extends StandardDiseaseModelPropertyEditor {
    public ExampleDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate(diseaseModel);
        if (diseaseModel instanceof ExampleDiseaseModel) {
            ExampleDiseaseModel model = (ExampleDiseaseModel)diseaseModel;
            model.setSeasonalModulationExponent(Double.parseDouble(((Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__SEASONAL_MODULATION_EXPONENT)).getText()));
            model.setModulationPeriod(Double.parseDouble(((Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__MODULATION_PERIOD)).getText()));
            model.setModulationPhaseShift(Double.parseDouble(((Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__MODULATION_PHASE_SHIFT)).getText()));
            model.setSeasonalModulationFloor(Double.parseDouble(((Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__SEASONAL_MODULATION_FLOOR)).getText()));
        }
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__SEASONAL_MODULATION_EXPONENT);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("seasonalModulationExponentMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("seasonalModulationExponentINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__MODULATION_PERIOD)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("modulationPeriodMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("modulationPeriodINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__MODULATION_PHASE_SHIFT)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("modulationPhaseMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("modulationPhaseINVALID");
                return false;
            }
        }
        if ((text = (Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__SEASONAL_MODULATION_FLOOR)) != null) {
            if (text.getText().equals("")) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("seasonalModulationFloorMISSING");
                return false;
            }
            if (!this.isValidDoubleValue(text.getText())) {
                this.errorMessage = ExampleDiseaseWizardMessages.getString("seasonalModulationFloorINVALID");
                return false;
            }
        }
        return true;
    }
}

