/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.edges.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.provider.EdgeLabelItemProvider;
import org.eclipse.stem.definitions.edges.provider.DefinitionsEditPlugin;
import org.eclipse.stem.geography.names.GeographicNames;

public class MixingEdgeLabelItemProvider
extends EdgeLabelItemProvider {
    public MixingEdgeLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public String getText(Object object) {
        Edge edge = ((EdgeLabel)object).getEdge();
        String firstISOKey = edge.getNodeAURI().lastSegment();
        String secondISOKey = edge.getNodeBURI().lastSegment();
        String firstGeoName = GeographicNames.getName((String)firstISOKey);
        String secondGeoName = GeographicNames.getName((String)secondISOKey);
        StringBuilder sb = new StringBuilder(firstGeoName.startsWith("!") ? firstISOKey : firstGeoName);
        sb.append(" <-> ");
        sb.append(secondGeoName.startsWith("!") ? secondISOKey : secondGeoName);
        return sb.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return DefinitionsEditPlugin.INSTANCE;
    }
}

