/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.util.analysis.Activator;
import org.osgi.service.prefs.BackingStoreException;

public class MonitorPreferences {
    Plugin plugin = Activator.getDefault();
    IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private static final String DEFAULT_PREFERENCE = "PREVIOUS_FOLDER";
    private static final String ESTIMATOR_PREFERENCE = "ESTIMATOR_METHOD";
    private static final String DEFAULT_PREF_VALUE = "";
    String recentFolder = null;
    String recentEstimationMethod = null;

    public MonitorPreferences() {
        if (this.preferenceStore.contains(DEFAULT_PREFERENCE)) {
            this.recentFolder = this.preferenceStore.getString(DEFAULT_PREFERENCE);
        } else {
            this.recentFolder = DEFAULT_PREF_VALUE;
            this.setPreferences();
        }
        if (this.preferenceStore.contains(ESTIMATOR_PREFERENCE)) {
            this.recentEstimationMethod = this.preferenceStore.getString(ESTIMATOR_PREFERENCE);
        } else {
            this.recentEstimationMethod = null;
            this.setPreferences();
        }
    }

    public void setPreferences() {
        this.preferenceStore.setValue(DEFAULT_PREFERENCE, this.recentFolder);
        if (this.recentEstimationMethod != null) {
            this.preferenceStore.setValue(ESTIMATOR_PREFERENCE, this.recentEstimationMethod);
        }
        try {
            InstanceScope.INSTANCE.getNode(Activator.getDefault().getBundle().getSymbolicName()).flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("Not able to save preferences", e);
        }
    }

    public void setRecentFolder(String consumer, String recent) {
        this.recentFolder = recent;
        this.preferenceStore.setValue(String.valueOf(consumer) + "_" + DEFAULT_PREFERENCE, this.recentFolder);
        try {
            InstanceScope.INSTANCE.getNode(Activator.getDefault().getBundle().getSymbolicName()).flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("Not able to save preferences", e);
        }
    }

    public void setEstimatorMethod(String method) {
        this.recentEstimationMethod = method;
        this.preferenceStore.setValue(ESTIMATOR_PREFERENCE, this.recentEstimationMethod);
        try {
            InstanceScope.INSTANCE.getNode(Activator.getDefault().getBundle().getSymbolicName()).flush();
        }
        catch (BackingStoreException e) {
            Activator.logError("Not able to save preferences", e);
        }
    }

    public String getRecentFolder(String consumer) {
        this.recentFolder = this.preferenceStore.getString(String.valueOf(consumer) + "_" + DEFAULT_PREFERENCE);
        if (this.recentFolder == null || this.recentFolder.length() == 0) {
            this.recentFolder = DEFAULT_PREF_VALUE;
            this.setRecentFolder(consumer, this.recentFolder);
        }
        return this.recentFolder;
    }

    public String getRecentEstimatorMethod() {
        return this.recentEstimationMethod;
    }
}

