/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.util.CDateTime;

public final class GanttEntry
implements IDataPointEntry {
    private CDateTime dateStart;
    private CDateTime dateEnd;
    private String strLabel;

    public GanttEntry(Calendar dateStart, Calendar dateEnd, String strLabel) {
        this.dateStart = new CDateTime(dateStart);
        this.dateEnd = new CDateTime(dateEnd);
        this.strLabel = strLabel;
    }

    public GanttEntry(Date dateStart, Date dateEnd, String strLabel) {
        this.dateStart = new CDateTime(dateStart);
        this.dateEnd = new CDateTime(dateEnd);
        this.strLabel = strLabel;
    }

    public GanttEntry(CDateTime dateStart, CDateTime dateEnd, String strLabel) {
        this.dateStart = dateStart;
        this.dateEnd = dateEnd;
        this.strLabel = strLabel;
    }

    GanttEntry(Object[] oaThreeComponents) {
        this.dateStart = oaThreeComponents[0] instanceof CDateTime ? (CDateTime)oaThreeComponents[0] : null;
        this.dateEnd = oaThreeComponents[1] instanceof CDateTime ? (CDateTime)oaThreeComponents[1] : null;
        this.strLabel = oaThreeComponents[2] != null ? String.valueOf(oaThreeComponents[2]) : null;
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public final CDateTime getStart() {
        return this.dateStart;
    }

    public final void setStart(CDateTime start) {
        this.dateStart = start;
    }

    public final CDateTime getEnd() {
        return this.dateEnd;
    }

    public final void setEnd(CDateTime end) {
        this.dateEnd = end;
    }

    public final String getLabel() {
        return this.strLabel;
    }

    public final void setLabel(String strLabel) {
        this.strLabel = strLabel;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strStart = this.getFormattedString("gantt_start_date", formatter, locale);
        String strEnd = this.getFormattedString("gantt_end_date", formatter, locale);
        String formattedString = "S " + strStart + "; E " + strEnd;
        if (this.strLabel != null) {
            formattedString = String.valueOf(formattedString) + "; " + this.strLabel;
        }
        return formattedString;
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = "";
        try {
            if ("gantt_start_date".equals(type)) {
                str = ValueFormatter.format((Object)this.dateStart, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("gantt_end_date".equals(type)) {
                str = ValueFormatter.format((Object)this.dateEnd, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("gantt_decoration_label".equals(type)) {
                str = ValueFormatter.format((Object)this.strLabel, (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            Logger.getLogger((String)"org.eclipse.birt.chart.engine/exception").log((Exception)((Object)e));
        }
        return str;
    }

    public boolean isValid() {
        return this.dateStart != null || this.dateEnd != null;
    }
}

