/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class SimulationControl
extends Composite
implements ISimulationListener,
ControlListener {
    protected ISimulation simulation = null;
    private boolean reset = false;
    private static ImageRegistry imageRegistry = null;
    private static ColorRegistry colorRegistry = null;
    private static FontRegistry fontRegistry = null;
    private Composite mainContainer = null;
    private Composite btnContainer = null;
    private Text simulationProgressText;
    private Text simulationStateText;
    private Text simulationTimeText;
    private ProgressBar pb = null;
    private Text simulationTitleText = null;
    private static int BEGIN_WORK = 0;
    private boolean UNKNOWN_DURATION = false;
    private static final int STANDARD_LENGTH = 100;
    private static final int STANDARD_HEIGHT = 22;
    private static final int CONTAINER_HEIGHT = 225;
    private static final int MARGIN = 10;
    int stepCount = 0;
    int lastWorkCompleted = -1;

    public SimulationControl(Composite parent, ISimulation simulation) {
        super(parent, 0);
        Activator activator;
        simulation.addSimulationListener((ISimulationListener)this);
        this.simulation = simulation;
        Sequencer sequencer = simulation.getScenario().getSequencer();
        boolean bl = this.UNKNOWN_DURATION = sequencer.getDuration() == -1L;
        if (imageRegistry == null) {
            activator = Activator.getDefault();
            imageRegistry = activator.getImageRegistry();
        }
        if (colorRegistry == null) {
            activator = Activator.getDefault();
            colorRegistry = activator.getColorRegistry();
        }
        if (fontRegistry == null) {
            activator = Activator.getDefault();
            fontRegistry = activator.getFontRegistry();
        }
        this.setLayoutData(new GridData(4, 0, true, false));
        this.createContents(this);
        parent.redraw();
    }

    public void controlResized(ControlEvent event) {
        int MULTIPLIER = 5;
        Rectangle clientBounds = null;
        if (this.getParent() != null && this.getParent().getParent() != null) {
            clientBounds = this.getParent().getParent().getClientArea();
        }
        if (clientBounds == null) {
            return;
        }
        int width = clientBounds.width - 50;
        int height = 22;
        Rectangle mainBounds = this.computeTrim(clientBounds.x, clientBounds.y, clientBounds.width - 10, 225);
        Rectangle btnBounds = this.computeTrim(this.btnContainer.getBounds().x, this.btnContainer.getBounds().y, width, height + 20);
        this.btnContainer.setBounds(btnBounds);
        this.mainContainer.setBounds(mainBounds);
        this.mainContainer.redraw();
    }

    public void controlMoved(ControlEvent event) {
    }

    protected void resetProgressBar() {
        if (this.pb == null || this.pb.isDisposed()) {
            return;
        }
        this.pb.setMinimum(BEGIN_WORK);
        this.pb.setMaximum(100);
        this.pb.setSelection(BEGIN_WORK);
        this.pb.redraw();
    }

    protected void updateStateLabel(SimulationState state) {
        if (this.simulationStateText == null || this.simulationStateText.isDisposed()) {
            return;
        }
        Rectangle bounds = this.simulationStateText.getBounds();
        if (state.equals((Object)SimulationState.RUNNING) || state.equals((Object)SimulationState.COMPLETED_CYCLE)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Running"));
            this.simulationStateText.setBackground(colorRegistry.get("green"));
        } else if (state.equals((Object)SimulationState.PAUSED)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Paused"));
            this.simulationStateText.setBackground(colorRegistry.get("yellow"));
        } else if (state.equals((Object)SimulationState.RESET)) {
            this.simulationStateText.setText(Messages.getString("SCtrl.Reset"));
            this.simulationStateText.setBackground(colorRegistry.get("orange"));
            this.pb.setSelection(0);
        }
        this.simulationStateText.setBounds(bounds);
        this.simulationStateText.redraw();
    }

    protected void updateProgressLabel(int workCompleted, SimulationState state) {
        Sequencer sequencer = this.simulation.getScenario().getSequencer();
        int current = sequencer.getCycle();
        Rectangle bounds = this.simulationProgressText.getBounds();
        if (this.UNKNOWN_DURATION) {
            this.simulationProgressText.setText(String.valueOf(Messages.getString("SCtrl.Progress")) + " : unknown duration");
            current %= 100;
        } else if (workCompleted <= 100) {
            this.simulationProgressText.setText(String.valueOf(Messages.getString("SCtrl.Progress")) + " : " + workCompleted + "%");
        }
        this.simulationProgressText.setBounds(bounds);
        this.simulationProgressText.redraw();
    }

    protected void updateTimeLabel(SimulationState state) {
        if (this.simulationTimeText.isDisposed()) {
            return;
        }
        Rectangle bounds = this.simulationTimeText.getBounds();
        Sequencer sequencer = this.simulation.getScenario().getSequencer();
        STEMTime time = sequencer.getCurrentTime();
        if (!state.name().equals("RUNNING")) {
            state.name().equals("COMPLETED_CYCLE");
        }
        if (sequencer.getCycle() > 0 && this.reset) {
            this.reset = false;
            return;
        }
        String timeLabel = "[" + sequencer.getCycle() + "] " + Messages.getString("SCtrl.Time") + " : " + time.toString();
        this.simulationTimeText.setText(timeLabel);
        this.simulationTimeText.setToolTipText(timeLabel);
        this.simulationTimeText.setBounds(bounds);
        this.simulationTimeText.redraw();
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    private void createContents(Composite parent) {
        this.mainContainer = new Composite(parent, 67584);
        this.mainContainer.setLayoutData((Object)this.getMainContainerGridData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.mainContainer.setLayout((Layout)new FormLayout());
        this.simulationTitleText = new Text(this.mainContainer, 66);
        this.simulationTitleText.setText(this.simulation.getNameWithSequenceNumber());
        this.simulationTitleText.setToolTipText(this.simulation.getName());
        this.simulationTitleText.setBackground(colorRegistry.get("gray"));
        this.simulationTitleText.setFont(fontRegistry.get("default"));
        this.simulationTitleText.setEditable(false);
        FormData sttFormData = new FormData();
        sttFormData.left = new FormAttachment(0, 0);
        sttFormData.right = new FormAttachment(100, 0);
        sttFormData.top = new FormAttachment(1, 0);
        this.simulationTitleText.setLayoutData((Object)sttFormData);
        this.simulationProgressText = new Text(this.mainContainer, 67584);
        this.simulationProgressText.setBackground(colorRegistry.get("green"));
        this.simulationProgressText.setEditable(false);
        this.simulationProgressText.setFont(fontRegistry.get("default"));
        FormData sptFormData = new FormData();
        sptFormData.left = new FormAttachment(0, 0);
        sptFormData.right = new FormAttachment(100, 0);
        sptFormData.top = new FormAttachment((Control)this.simulationTitleText, 0);
        this.simulationProgressText.setLayoutData((Object)sptFormData);
        this.simulationStateText = new Text(this.mainContainer, 67584);
        this.simulationStateText.setBackground(colorRegistry.get("green"));
        this.simulationStateText.setEditable(false);
        this.simulationStateText.setFont(fontRegistry.get("default"));
        FormData sstFormData = new FormData();
        sstFormData.left = new FormAttachment(0, 0);
        sstFormData.right = new FormAttachment(100, 0);
        sstFormData.top = new FormAttachment((Control)this.simulationProgressText, 0);
        this.simulationStateText.setLayoutData((Object)sstFormData);
        this.pb = new ProgressBar(this.mainContainer, 67584);
        this.pb.setFont(fontRegistry.get("default"));
        FormData pbFormData = new FormData();
        pbFormData.left = new FormAttachment(0, 0);
        pbFormData.right = new FormAttachment(100, 0);
        pbFormData.top = new FormAttachment((Control)this.simulationStateText, 0);
        this.pb.setLayoutData((Object)pbFormData);
        this.simulationTimeText = new Text(this.mainContainer, 67584);
        this.simulationTimeText.setBackground(colorRegistry.get("green"));
        this.simulationTimeText.setEditable(false);
        this.simulationTimeText.setFont(fontRegistry.get("default"));
        FormData stmtFormData = new FormData();
        stmtFormData.left = new FormAttachment(0, 0);
        stmtFormData.right = new FormAttachment(100, 0);
        stmtFormData.top = new FormAttachment((Control)this.pb, 0);
        this.simulationTimeText.setLayoutData((Object)stmtFormData);
        Composite controlButtons = this.createControlButtons(this.mainContainer);
        FormData controlsFormData = new FormData();
        controlsFormData.left = new FormAttachment(0, 0);
        controlsFormData.right = new FormAttachment(80, 0);
        controlsFormData.top = new FormAttachment((Control)this.simulationTimeText, 0);
        controlButtons.setLayoutData((Object)controlsFormData);
        this.resetProgressBar();
        this.updateStateLabel(this.simulation.getSimulationState());
        this.updateProgressLabel(BEGIN_WORK, this.simulation.getSimulationState());
        this.updateTimeLabel(this.simulation.getSimulationState());
    }

    protected GridData getDefaultGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 22;
        gridData.minimumHeight = 22;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.horizontalAlignment = 16384;
        return gridData;
    }

    protected GridData getTextGridData() {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 22;
        gridData.minimumHeight = 20;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    protected GridData getProgressBarGridData() {
        GridData gridData = new GridData(4, 0, true, false);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    protected GridData getMainContainerGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        gridData.heightHint = 225;
        gridData.minimumHeight = 225;
        return gridData;
    }

    protected GridData getButtonGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        gridData.heightHint = 30;
        gridData.minimumHeight = 20;
        return gridData;
    }

    protected Composite createControlButtons(Composite parent) {
        int OFFSET = 16;
        this.btnContainer = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = true;
        this.btnContainer.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 48;
        gridData.minimumHeight = 48;
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        this.btnContainer.setLayoutData((Object)gridData);
        Button run = new Button(this.btnContainer, 8);
        Button pause = new Button(this.btnContainer, 8);
        Button reset = new Button(this.btnContainer, 8);
        Button step = new Button(this.btnContainer, 8);
        Button stop = new Button(this.btnContainer, 8);
        run.setBackground(parent.getDisplay().getSystemColor(15));
        run.setToolTipText(Messages.getString("SCtrl.StartSim"));
        run.setLayoutData((Object)this.getButtonGridData());
        pause.setBackground(parent.getDisplay().getSystemColor(15));
        pause.setToolTipText(Messages.getString("SCtrl.PauseSim"));
        pause.setLayoutData((Object)this.getButtonGridData());
        reset.setBackground(parent.getDisplay().getSystemColor(15));
        reset.setToolTipText(Messages.getString("SCtrl.RestoreSim"));
        reset.setLayoutData((Object)this.getButtonGridData());
        step.setBackground(parent.getDisplay().getSystemColor(15));
        step.setToolTipText(Messages.getString("SCtrl.StepSim"));
        step.setLayoutData((Object)this.getButtonGridData());
        stop.setBackground(parent.getDisplay().getSystemColor(15));
        stop.setToolTipText(Messages.getString("SCtrl.StopSim"));
        stop.setLayoutData((Object)this.getButtonGridData());
        run.setImage(imageRegistry.get("run.image"));
        pause.setImage(imageRegistry.get("pause.image"));
        reset.setImage(imageRegistry.get("reset.image"));
        step.setImage(imageRegistry.get("step.image"));
        stop.setImage(imageRegistry.get("stop.image"));
        run.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        SimulationControl.this.run();
                    }
                }
            }
        });
        pause.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        SimulationControl.this.pause();
                    }
                }
            }
        });
        reset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        SimulationControl.this.reset();
                    }
                }
            }
        });
        step.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        SimulationControl.this.step();
                    }
                }
            }
        });
        stop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        SimulationControl.this.stop();
                    }
                }
            }
        });
        return this.btnContainer;
    }

    public void dispose() {
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
        }
        if (this.mainContainer != null) {
            this.mainContainer.dispose();
        }
    }

    public void simulationChanged(SimulationEvent event) {
        if (this.simulation == null) {
            return;
        }
        SimulationState simulationState = this.simulation.getSimulationState();
        Scenario scenario = this.simulation.getScenario();
        if (scenario == null) {
            return;
        }
        Sequencer sequencer = scenario.getSequencer();
        if (sequencer == null) {
            return;
        }
        int workComplete = (int)sequencer.getWorkComplete();
        if (this.pb.isDisposed()) {
            return;
        }
        this.lastWorkCompleted = workComplete;
        this.pb.setSelection(workComplete);
        this.updateProgressLabel(workComplete, this.simulation.getSimulationState());
        this.updateStateLabel(simulationState);
        this.updateTimeLabel(simulationState);
    }

    protected void resetTimeLabel() {
        boolean ZERO = false;
        this.simulationTimeText.setText("[ 0 ] " + Messages.getString("SCtrl.Time") + " : " + 0);
        this.simulationTimeText.redraw();
    }

    public void run() {
        this.simulation.run();
    }

    public void pause() {
        this.simulation.pause();
    }

    public void reset() {
        try {
            this.simulation.reset();
        }
        catch (ScenarioInitializationException sie) {
            Utility.handleException((String)sie.getErrorMessage(), (boolean)true, (ScenarioInitializationException)sie);
        }
        this.reset = true;
        this.resetTimeLabel();
    }

    public void step() {
        this.simulation.step();
    }

    public void stop() {
        this.simulation.stop();
    }
}

