/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.ErrorReporter;
import org.eclipse.pde.internal.core.builders.IHeader;
import org.eclipse.pde.internal.core.builders.JarManifestHeader;

public class JarManifestErrorReporter
extends ErrorReporter {
    protected Map<String, JarManifestHeader> fHeaders;
    protected IDocument fTextDocument;

    public JarManifestErrorReporter(IFile file) {
        super(file);
        this.fTextDocument = this.createDocument(file);
    }

    private String getHeaderName(String line) {
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == ':') {
                return line.substring(0, i);
            }
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c)) {
                if (i == 0) {
                    return null;
                }
                if (c != '-' && c != '_') {
                    return null;
                }
            }
            ++i;
        }
        return null;
    }

    protected int getPackageLine(IHeader header, ManifestElement element) {
        String packageName = element.getValue();
        if (element.getDirectiveKeys() != null || element.getKeys() != null) {
            return this.getLine(header, String.valueOf(packageName) + ";");
        }
        try {
            IRegion lineRegion = this.fTextDocument.getLineInformation(header.getLineNumber() + header.getLinesSpan() - 1);
            String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            if (lineStr.endsWith(packageName)) {
                return header.getLineNumber() + header.getLinesSpan();
            }
        }
        catch (BadLocationException ble) {
            PDECore.logException(ble);
        }
        return this.getLine(header, String.valueOf(packageName) + ",");
    }

    protected int getLine(IHeader header, String valueSubstring) {
        int l = header.getLineNumber();
        while (l < header.getLineNumber() + header.getLinesSpan()) {
            try {
                IRegion lineRegion = this.fTextDocument.getLineInformation(l);
                String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
                if (lineStr.contains(valueSubstring)) {
                    return l + 1;
                }
            }
            catch (BadLocationException ble) {
                PDECore.logException(ble);
            }
            ++l;
        }
        try {
            IRegion lineRegion = this.fTextDocument.getLineInformation(header.getLineNumber());
            String lineStr = this.fTextDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            int l2 = header.getLineNumber() + 1;
            while (l2 < header.getLineNumber() + header.getLinesSpan()) {
                lineRegion = this.fTextDocument.getLineInformation(l2);
                if ((lineStr = String.valueOf(lineStr) + this.fTextDocument.get(lineRegion.getOffset() + 1, lineRegion.getLength())).contains(valueSubstring)) {
                    return l2;
                }
                ++l2;
            }
        }
        catch (BadLocationException ble) {
            PDECore.logException(ble);
        }
        return header.getLineNumber() + 1;
    }

    /*
     * Unable to fully structure code
     */
    protected void parseManifest(IDocument document, IProgressMonitor monitor) {
        try {
            this.fHeaders = new HashMap<String, JarManifestHeader>();
            header = null;
            l = 0;
            while (l < document.getNumberOfLines()) {
                if (l % 100 == 0) {
                    this.checkCanceled(monitor);
                }
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                lineDelimiter = document.getLineDelimiter(l);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                if ((byteBuf = StandardCharsets.UTF_8.encode(line)).limit() + lineDelimiter.length() > 512) {
                    this.report(PDECoreMessages.BundleErrorReporter_lineTooLong, l + 1, 0, "fatal");
                    return;
                }
                if (line.length() == 0) {
                    if (l == 0) {
                        this.report(PDECoreMessages.BundleErrorReporter_noMainSection, 1, 0, "fatal");
                        return;
                    }
                    if (header == null) break;
                    this.fHeaders.put(header.getName().toLowerCase(), header);
                    header = null;
                    break;
                }
                if (line.charAt(0) == ' ') {
                    if (l == 0) {
                        this.report(PDECoreMessages.BundleErrorReporter_noMainSection, 1, 0, "fatal");
                        return;
                    }
                    if (header != null) {
                        header.append(line.substring(1));
                    }
                } else {
                    if (header != null) {
                        this.fHeaders.put(header.getName().toLowerCase(), header);
                        header = null;
                    }
                    if ((colon = line.indexOf(58)) == -1) {
                        this.report(PDECoreMessages.BundleErrorReporter_noColon, l + 1, 0, "fatal");
                        return;
                    }
                    headerName = this.getHeaderName(line);
                    if (headerName == null) {
                        this.report(PDECoreMessages.BundleErrorReporter_invalidHeaderName, l + 1, 0, "fatal");
                        return;
                    }
                    if (line.length() < colon + 2 || line.charAt(colon + 1) != ' ') {
                        this.report(PDECoreMessages.BundleErrorReporter_noSpaceValue, l + 1, 0, "fatal");
                        return;
                    }
                    if ("Name".equals(headerName)) {
                        this.report(PDECoreMessages.BundleErrorReporter_nameHeaderInMain, l + 1, 0, "fatal");
                        return;
                    }
                    header = new JarManifestHeader(headerName, line.substring(colon + 2), l, this);
                    if (this.fHeaders.containsKey(header.getName().toLowerCase())) {
                        this.report(PDECoreMessages.BundleErrorReporter_duplicateHeader, l + 1, 1, "");
                    }
                }
                ++l;
            }
            if (header == null) ** GOTO lbl77
            marker = this.report(PDECoreMessages.BundleErrorReporter_noLineTermination, l, 0, 4132, "fatal");
            if (marker != null) {
                lineInfo = document.getLineInformation(document.getNumberOfLines() - 1);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                marker.setAttribute("noLineTermination.hasContent", line.matches("\\s+") == false);
            }
            return;
lbl-1000:
            // 1 sources

            {
                lineInfo = document.getLineInformation(l);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                if (line.length() != 0) {
                    if (line.startsWith("Name:")) break;
                    this.report(PDECoreMessages.BundleErrorReporter_noNameHeader, l, 0, "fatal");
                    break;
                }
                ++l;
lbl77:
                // 2 sources

                ** while (l < document.getNumberOfLines())
            }
lbl78:
            // 3 sources

            return;
        }
        catch (BadLocationException ble) {
            PDECore.logException(ble);
            return;
        }
    }

    protected void reportIllegalAttributeValue(IHeader header, String key, String value) {
        String msg = NLS.bind((String)PDECoreMessages.BundleErrorReporter_att_value, (Object[])new String[]{value, key});
        this.report(msg, this.getLine(header, String.valueOf(key) + "="), 0, "fatal");
    }

    protected void reportIllegalValue(IHeader header, String value) {
        String msg = NLS.bind((String)PDECoreMessages.BundleErrorReporter_illegal_value, (Object)value);
        this.report(msg, this.getLine(header, value), 0, "fatal");
    }

    protected void reportIllegalDirectiveValue(IHeader header, String key, String value) {
        String msg = NLS.bind((String)PDECoreMessages.BundleErrorReporter_dir_value, (Object[])new String[]{value, key});
        this.report(msg, this.getLine(header, String.valueOf(key) + ":="), 0, "fatal");
    }

    protected void validateAttributeValue(IHeader header, ManifestElement element, String key, String[] allowedValues) {
        String value = element.getAttribute(key);
        if (value == null) {
            return;
        }
        String[] stringArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            if (allowedValue.equals(value)) {
                return;
            }
            ++n2;
        }
        this.reportIllegalAttributeValue(header, key, value);
    }

    protected void validateBooleanAttributeValue(IHeader header, ManifestElement element, String key) {
        this.validateAttributeValue(header, element, key, BOOLEAN_VALUES);
    }

    protected void validateBooleanDirectiveValue(IHeader header, ManifestElement element, String key) {
        this.validateDirectiveValue(header, element, key, BOOLEAN_VALUES);
    }

    protected void validateBooleanValue(IHeader header) {
        this.validateHeaderValue(header, BOOLEAN_VALUES);
    }

    @Override
    protected void validate(IProgressMonitor monitor) {
        if (this.fTextDocument != null) {
            this.parseManifest(this.fTextDocument, monitor);
        }
    }

    protected void validateDirectiveValue(IHeader header, ManifestElement element, String key, String[] allowedValues) {
        String value = element.getDirective(key);
        if (value == null) {
            return;
        }
        String[] stringArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            if (allowedValue.equals(value)) {
                return;
            }
            ++n2;
        }
        this.reportIllegalDirectiveValue(header, key, value);
    }

    protected void validateHeaderValue(IHeader header, String[] allowedValues) {
        ManifestElement[] elements = header.getElements();
        if (elements.length > 0) {
            String[] stringArray = allowedValues;
            int n = allowedValues.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedValue = stringArray[n2];
                if (allowedValue.equals(elements[0].getValue())) {
                    return;
                }
                ++n2;
            }
            this.reportIllegalValue(header, elements[0].getValue());
        }
    }

    protected IHeader validateRequiredHeader(String name) {
        IHeader header = this.fHeaders.get(name.toLowerCase());
        if (header == null) {
            this.report(NLS.bind((String)PDECoreMessages.BundleErrorReporter_headerMissing, (Object)name), 1, 0, "fatal");
        }
        return header;
    }

    protected IHeader getHeader(String key) {
        return this.fHeaders.get(key.toLowerCase());
    }

    protected void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

