/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.guice;

import com.google.inject.Injector;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public abstract class AbstractGuiceAwareExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    public static final String GUICEKEY = "guicekey";
    protected Logger log = Logger.getLogger(this.getClass());
    protected String clazzName;
    protected IConfigurationElement config;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.clazzName = (String)data;
        } else if (data instanceof Map) {
            this.clazzName = (String)((Map)data).get(GUICEKEY);
        }
        if (this.clazzName == null) {
            throw new IllegalArgumentException("couldn't handle passed data : " + data);
        }
        this.config = config;
    }

    public Object create() throws CoreException {
        try {
            Class clazz = this.getBundle().loadClass(this.clazzName);
            Injector injector = this.getInjector();
            if (injector == null) {
                throw this.handleCreationError(null);
            }
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, null, null);
            }
            return result;
        }
        catch (VirtualMachineError | CoreException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.handleCreationError(e);
        }
    }

    protected CoreException handleCreationError(Throwable cause) {
        String contributor = this.config.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)contributor);
        String message = cause != null && !(cause instanceof NullPointerException) ? String.valueOf(cause.getMessage()) + " (occurred in " + this.getClass().getName() + ")" : "Could not create the Injector for " + this.getClass().getName() + ".";
        if (bundle.getState() != 32) {
            message = String.valueOf(message) + "\nBundle " + bundle.getSymbolicName() + " was not activated.\n" + "Please check that all dependencies could be resolved and 'Bundle-ActivationPolicy: lazy' is configured in the bundle's MANIFEST.MF. " + "Check also the error log.";
        }
        if (cause instanceof NullPointerException) {
            message = String.valueOf(message) + "\nA NullPointerException occurred. This also indicates that bundle " + bundle.getSymbolicName() + " was compiled with an outdated version of Xtext. Please consider to regenerate the DSL implementation " + " with a current version.\n" + "Your currently installed version of Xtext is " + Platform.getBundle((String)"org.eclipse.xtext.ui").getVersion() + ".";
        }
        return new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), message, cause));
    }

    protected abstract Bundle getBundle();

    protected abstract Injector getInjector();
}

