/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class RefactorWizard
extends Wizard {
    private String title;
    boolean cancelPressed = false;
    Identifiable identifiable;
    XMIResource resource;
    String value;
    IProject project;
    boolean delete = false;
    boolean dependenciesLoadNeeded = true;
    String fullNewName;
    String newNamePrefix = Messages.getString("NEW_PREFIX");
    private IWorkbench workbench;
    private boolean updateReferences = false;
    WizardPage namePage = null;
    WizardPage dependenciesPage = null;
    Button[] updateButtons;
    Label[] identLabels;
    Composite checkboxesAndAffectedObjectsComposite;
    Button updateRefButton;
    String IDENTIFIABLE_KEY = "IDENTIFIABLE";
    List<URI> changedResources = new ArrayList<URI>();

    public RefactorWizard(Identifiable ident, XMIResource res, boolean delete) {
        this.identifiable = ident;
        this.resource = res;
        this.delete = delete;
    }

    public IWizardPage getFirstPage() {
        WizardPage ret;
        if (this.namePage != null) {
            return this.namePage;
        }
        this.namePage = ret = new WizardPage(this.delete ? Messages.getString("DELETE_TITLE") : Messages.getString("RENAME_TITLE")){

            public void createControl(Composite parent) {
                GridData lgd;
                Composite container = new Composite(parent, 0);
                GridLayout gl = new GridLayout();
                gl.numColumns = 2;
                container.setLayout((Layout)gl);
                if (!RefactorWizard.this.delete) {
                    lgd = new GridData();
                    lgd.horizontalSpan = 1;
                    Label nn_label = new Label(container, 0);
                    nn_label.setText(Messages.getString("REFACTOR_NEW_NAME_TITLE"));
                    nn_label.setLayoutData((Object)lgd);
                    GridData gd = new GridData();
                    gd.horizontalSpan = 1;
                    final Text text = new Text(container, 0);
                    if (RefactorWizard.this.identifiable != null) {
                        String val = String.valueOf(RefactorWizard.this.newNamePrefix) + RefactorWizard.this.identifiable.getURI().lastSegment();
                        text.setText(val);
                        RefactorWizard.this.fullNewName = RefactorWizard.this.getFullNewName(val);
                        RefactorWizard.this.value = val;
                    }
                    text.setLayoutData((Object)gd);
                    gd.minimumWidth = 100;
                    gd.grabExcessHorizontalSpace = true;
                    final 1 p_self = this;
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            String newName = RefactorWizard.this.getFullNewName(text.getText());
                            File f = new File(newName);
                            if (f.exists() || text.getText().trim().equals("") || text.getText().equals((this).RefactorWizard.this.identifiable.getURI().lastSegment())) {
                                p_self.setErrorMessage(Messages.getString("REFACTOR_INVALID_NAME"));
                                p_self.setPageComplete(false);
                            } else {
                                (this).RefactorWizard.this.value = text.getText();
                                (this).RefactorWizard.this.fullNewName = newName;
                                p_self.setErrorMessage(null);
                                p_self.setPageComplete(true);
                            }
                        }
                    });
                } else {
                    lgd = new GridData();
                    lgd.horizontalSpan = 1;
                    Label nn_label = new Label(container, 0);
                    nn_label.setText(String.valueOf(Messages.getString("REFACTOR_DELETE")) + RefactorWizard.this.identifiable.getURI().toString());
                    nn_label.setLayoutData((Object)lgd);
                }
                GridData urGD = new GridData();
                urGD.horizontalSpan = 2;
                RefactorWizard.this.updateRefButton = new Button(container, 32);
                RefactorWizard.this.updateRefButton.setText(Messages.getString("REFACTOR_UPDATE_REFERENCES"));
                RefactorWizard.this.updateRefButton.setLayoutData((Object)urGD);
                RefactorWizard.this.updateRefButton.setSelection(RefactorWizard.this.updateReferences);
                RefactorWizard.this.updateRefButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        RefactorWizard.this.updateReferences = (this).RefactorWizard.this.updateRefButton.getSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        RefactorWizard.this.updateReferences = (this).RefactorWizard.this.updateRefButton.getSelection();
                    }
                });
                this.setControl((Control)container);
            }
        };
        return ret;
    }

    private String getFullNewName(String nn) {
        URI oldURI = this.identifiable.getURI();
        String path = oldURI.toString();
        int ind = path.lastIndexOf("/");
        String truncpath = "";
        if (ind != -1) {
            truncpath = path.substring(0, ind + 1);
        }
        String newpath = String.valueOf(truncpath) + nn;
        return newpath;
    }

    public IWizardPage getDependenciesPage() {
        WizardPage ret;
        if (this.dependenciesPage != null) {
            return this.dependenciesPage;
        }
        this.dependenciesPage = ret = new WizardPage(Messages.getString("REFACTOR_DEPENDENCIES_FOUND")){

            public void createControl(Composite parent) {
                Composite container = new Composite(parent, 0);
                GridLayout gl = new GridLayout();
                gl.numColumns = 2;
                container.setLayout((Layout)gl);
                Label depLabel = new Label(container, 0);
                GridData depGD = new GridData();
                depLabel.setLayoutData((Object)depGD);
                depGD.horizontalSpan = 2;
                depLabel.setText(Messages.getString("REFACTOR_CHANGES_TO_BE_MADE"));
                RefactorWizard.this.checkboxesAndAffectedObjectsComposite = new Composite(container, 0);
                GridData gdCheck = new GridData();
                gdCheck.horizontalSpan = 2;
                RefactorWizard.this.checkboxesAndAffectedObjectsComposite.setLayoutData((Object)gdCheck);
                GridLayout gl2 = new GridLayout();
                gl2.numColumns = 2;
                RefactorWizard.this.checkboxesAndAffectedObjectsComposite.setLayout((Layout)gl2);
                this.setControl((Control)container);
            }
        };
        return ret;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(Messages.getString("REFACTOR"));
        this.setHelpAvailable(true);
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(false);
        this.addPage(this.getFirstPage());
        this.addPage(this.getDependenciesPage());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.dependenciesPage) {
            try {
                this.fetchDependenciesAndBuildTable();
            }
            catch (CoreException ce) {
                Activator.logError("Exception fetching resources to modify", ce);
            }
        } else if (!this.updateReferences) {
            this.clearDependenciesUI();
        }
        return nextPage;
    }

    private void fetchDependenciesAndBuildTable() throws CoreException {
        if (this.dependenciesLoadNeeded && this.updateReferences) {
            this.changedResources = Utility.findReferences((Identifiable)this.identifiable);
            this.dependenciesLoadNeeded = false;
        }
        this.clearDependenciesUI();
        if (this.updateReferences) {
            this.updateButtons = new Button[this.changedResources.size()];
            this.identLabels = new Label[this.changedResources.size()];
            int i = 0;
            for (URI uri : this.changedResources) {
                this.updateButtons[i] = new Button(this.checkboxesAndAffectedObjectsComposite, 32);
                GridData gdButt = new GridData();
                gdButt.horizontalSpan = 1;
                this.updateButtons[i].setLayoutData((Object)gdButt);
                this.updateButtons[i].setSelection(true);
                this.identLabels[i] = new Label(this.checkboxesAndAffectedObjectsComposite, 0);
                this.identLabels[i].setText(uri.toString());
                GridData gdLab = new GridData();
                gdLab.horizontalSpan = 1;
                this.identLabels[i].setLayoutData((Object)gdLab);
                ++i;
            }
        }
        this.checkboxesAndAffectedObjectsComposite.getParent().redraw();
        this.checkboxesAndAffectedObjectsComposite.getParent().layout();
        this.checkboxesAndAffectedObjectsComposite.redraw();
        this.checkboxesAndAffectedObjectsComposite.layout();
    }

    private void clearDependenciesUI() {
        int n;
        int n2;
        Button[] buttonArray;
        if (this.updateButtons != null) {
            buttonArray = this.updateButtons;
            n2 = this.updateButtons.length;
            n = 0;
            while (n < n2) {
                Button b = buttonArray[n];
                b.dispose();
                ++n;
            }
        }
        if (this.identLabels != null) {
            buttonArray = this.identLabels;
            n2 = this.identLabels.length;
            n = 0;
            while (n < n2) {
                Button l = buttonArray[n];
                l.dispose();
                ++n;
            }
        }
    }

    private void processIdentifiable(Identifiable updateIdent, URI oldURI, Identifiable newIdentifiable) {
        EList attrs = updateIdent.eClass().getEStructuralFeatures();
        Resource thisResource = updateIdent.eResource();
        block0: for (EStructuralFeature ea : attrs) {
            EReference ref;
            if (!(ea instanceof EReference) || !updateIdent.eIsSet((EStructuralFeature)(ref = (EReference)ea))) continue;
            Object val = updateIdent.eGet((EStructuralFeature)ref, true);
            if (val instanceof EList) {
                EList references = (EList)val;
                int index = 0;
                while (index < references.size()) {
                    EObject eo = (EObject)references.get(index);
                    if (eo.eIsProxy() || eo.eResource() != thisResource && eo.eResource() != null) {
                        if (eo instanceof Identifiable && ((Identifiable)eo).getURI().equals(oldURI)) {
                            if (!this.delete) {
                                references.set(index, (Object)newIdentifiable);
                                continue block0;
                            }
                            references.remove(index);
                            continue block0;
                        }
                    } else if (eo instanceof Identifiable && !(eo instanceof Graph)) {
                        this.processIdentifiable((Identifiable)eo, oldURI, newIdentifiable);
                    }
                    ++index;
                }
                continue;
            }
            if (!(val instanceof EObject)) continue;
            EObject eo = (EObject)val;
            if (eo.eIsProxy() || eo.eResource() != thisResource && eo.eResource() != null) {
                if (!(eo instanceof Identifiable) || !((Identifiable)eo).getURI().equals(oldURI)) continue;
                if (!this.delete) {
                    updateIdent.eSet((EStructuralFeature)ref, (Object)newIdentifiable);
                    continue;
                }
                updateIdent.eUnset((EStructuralFeature)ref);
                continue;
            }
            if (!(eo instanceof Identifiable) || eo instanceof Graph) continue;
            this.processIdentifiable((Identifiable)eo, oldURI, newIdentifiable);
        }
    }

    public boolean performFinish() {
        if (this.dependenciesLoadNeeded && this.updateReferences) {
            try {
                this.changedResources = Utility.findReferences((Identifiable)this.identifiable);
            }
            catch (CoreException ce) {
                Activator.logError(ce.getMessage(), ce);
            }
            this.dependenciesLoadNeeded = false;
        }
        URI oldIdURI = this.identifiable.getURI();
        if (!this.delete) {
            URI oldURI = this.resource.getURI();
            String s_newURI = oldURI.toString().substring(0, oldURI.toString().indexOf(oldURI.lastSegment()));
            String s_newIdURI = oldIdURI.toString().substring(0, oldIdURI.toString().indexOf(oldIdURI.lastSegment()));
            URI newURI = URI.createURI((String)(String.valueOf(s_newURI) + this.value));
            URI newIDURI = URI.createURI((String)(String.valueOf(s_newIdURI) + this.value));
            Identifiable newIdent = null;
            try {
                ArrayList<Identifiable> newlist = new ArrayList<Identifiable>();
                newIdent = (Identifiable)EcoreUtil.copy((EObject)this.identifiable);
                newIdent.setURI(newIDURI);
                newlist.add(newIdent);
                Utility.serializeIdentifiables(newlist, (URI)newURI);
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
            }
            try {
                int i = 0;
                for (URI uri : this.changedResources) {
                    if (this.updateButtons == null || this.updateButtons[i] == null || this.updateButtons[i].getSelection()) {
                        Identifiable ident = Utility.getIdentifiable((URI)uri);
                        this.processIdentifiable(ident, oldIdURI, newIdent);
                        ident.eResource().save(Utility.EMF_SAVE_OPTIONS);
                    }
                    ++i;
                }
                this.resource.delete(null);
            }
            catch (IOException ioe) {
                Activator.logError(ioe.getMessage(), ioe);
            }
        } else {
            try {
                int i = 0;
                for (URI uri : this.changedResources) {
                    if (this.updateButtons == null || this.updateButtons[i] == null || this.updateButtons[i].getSelection()) {
                        Identifiable ident = Utility.getIdentifiable((URI)uri);
                        this.processIdentifiable(ident, oldIdURI, null);
                        ident.eResource().save(Utility.EMF_SAVE_OPTIONS);
                    }
                    ++i;
                }
                if (this.resource != null) {
                    this.resource.delete(null);
                }
            }
            catch (IOException ioe) {
                Activator.logError(ioe.getMessage(), ioe);
            }
            return true;
        }
        return true;
    }
}

