/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final String P_FOLDER = "folderPreference";
    static final String P_SERVER_HOST = "ServerHostPreference";
    static final String P_AUTO_LAUNCH = "AutoLaunchPreference";
    static final String P_INTERNAL_SERVER = "InternalServer";
    static final String P_WHICH_CYCLE = "whichCycle";
    static final String P_DEBUG = "DebugPreference";
    static final String P_BBOX = "BBOXPreference";
    static final String P_ASPECT = "AspectPreference";
    static final String P_AUTO_LOGGING = "AutoLoggingPreference";
    static final String P_TEST = "TestPreference";
    static final String P_SHOW_BORDER = "ShowBorderPreference";
    static final String P_METHOD = "MethodPreference";
    public static final int M_LOG_ONLY = 1;
    public static final int M_LOG_SERVLET = 2;
    public static final int M_ASYNC_SERVLET = 3;
    public static final int M_AUTO_LAUNCH = 4;
    public static final int M_MANUAL_DISPLAY = 5;
    public static final IPreferenceStore preferences = org.eclipse.stem.ui.ge.Activator.getDefault().getPreferenceStore();

    public GEPreferencePage() {
        super(1);
        this.setPreferenceStore(preferences);
        this.setDescription("Preferences for the STEM - GoogleEarth interface\n ");
    }

    public void init(IWorkbench workbench) {
    }

    public void createFieldEditors() {
        String[][] aspectList;
        this.addField((FieldEditor)new RadioGroupFieldEditor(P_METHOD, "&Choose the method used to display STEM results.", 1, (String[][])new String[][]{{"LogOnly    - KML files will be logged for later display", "1"}, {"Log+Servlet - KML files logged and displayed by GoogleEarth", "2"}, {"AsyncServlet - KML written to Control.kml and Async read by Servlet ", "3"}, {"DirectLaunch - At each Nth cycle, directly launch the file to GE ", "4"}, {"ManualDisplay - Use DisplayMap command to display", "5"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(P_FOLDER, "&Folder for KML logging:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_INTERNAL_SERVER, "&Use internal webserver", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(P_SERVER_HOST, "Hostname:port for external webserver:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_AUTO_LAUNCH, "&Automatically startup GoogleEarth", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_AUTO_LOGGING, "&Automatically process every simulation", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(P_WHICH_CYCLE, "Write KML files only every N th cycle", this.getFieldEditorParent(), 2));
        String a = preferences.getString(P_ASPECT);
        if ("".equals(a)) {
            this.getVisualizationPreferences();
        }
        if ((aspectList = this.aspects()) != null) {
            this.addField((FieldEditor)new RadioGroupFieldEditor(P_ASPECT, "&Choose the STEM Aspect to be Logged.", 2, this.aspects(), this.getFieldEditorParent()));
        }
    }

    private String[][] aspects() {
        Map<String, Aspect> aspectMap = Aspect.getMap();
        if (aspectMap == null || aspectMap.size() == 0) {
            return null;
        }
        int n = aspectMap.size();
        String[][] result = new String[n][2];
        int i = 0;
        for (Map.Entry<String, Aspect> entry : aspectMap.entrySet()) {
            String code = entry.getKey();
            Aspect aspect = entry.getValue();
            result[i][0] = aspect.getName();
            result[i][1] = code;
            ++i;
        }
        return result;
    }

    public boolean performOk() {
        this.update();
        try {
            if (preferences instanceof ScopedPreferenceStore) {
                ScopedPreferenceStore p = (ScopedPreferenceStore)preferences;
                p.save();
            }
        }
        catch (IOException e) {
            GELog.error("Failure saving Preferences", e);
        }
        GELog.debug((Object)this, "saved preferences");
        return super.performOk();
    }

    private void update() {
        if (GEPreferencePage.isDebug() != GELog.DEBUG) {
            GELog.DEBUG = GEPreferencePage.isDebug();
            if (GEPreferencePage.isDebug()) {
                GELog.debug("Set DEBUG to " + GEPreferencePage.isDebug());
            }
        }
    }

    private void getVisualizationPreferences() {
        Activator uiPlugin = null;
        try {
            uiPlugin = Activator.getDefault();
            IPreferenceStore preferenceStore = uiPlugin.getPreferenceStore();
            String visualizationAspect = preferenceStore.getString("org.eclipse.stem.ui.initialattributename");
            if (preferenceStore.getString(P_ASPECT) == "") {
                GELog.debug((Object)this, "Use visualizationAspect=" + visualizationAspect);
                if (visualizationAspect.equals("S")) {
                    visualizationAspect = "I";
                }
                GEPreferencePage.setAspect(visualizationAspect);
            } else {
                GELog.debug((Object)this, "Ignore visualizationAspect=" + visualizationAspect);
            }
        }
        catch (Exception e) {
            GELog.error("Failure getting Visualization preferences", e);
        }
        try {
            uiPlugin.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    GEPreferencePage.this.setVisulizationPreferences(event);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setVisulizationPreferences(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("org.eclipse.stem.ui.initialattributename" == property) {
            String visualizationAspect = (String)event.getNewValue();
            GELog.debug((Object)this, "Changed visualizationAspect=" + visualizationAspect);
            GEPreferencePage.setAspect(visualizationAspect);
            this.performOk();
        }
    }

    public static String getFolder() {
        return preferences.getString(P_FOLDER);
    }

    public static void setFolder(String logFolder) {
        preferences.setValue(P_FOLDER, logFolder);
    }

    public static String getServerHost() {
        return preferences.getString(P_SERVER_HOST);
    }

    public static int getMethod() {
        String s = preferences.getString(P_METHOD);
        int type = Integer.parseInt(s);
        return type;
    }

    public static void setMethod(int newMethod) {
        String m = "" + newMethod;
        preferences.setValue(P_METHOD, m);
    }

    public static boolean isInternalServer() {
        return preferences.getBoolean(P_INTERNAL_SERVER);
    }

    public static boolean isAutoLaunch() {
        return preferences.getBoolean(P_AUTO_LAUNCH);
    }

    public static boolean isAutoLogging() {
        return preferences.getBoolean(P_AUTO_LOGGING);
    }

    public static int getWhichCycle() {
        return preferences.getInt(P_WHICH_CYCLE);
    }

    public static Aspect getAspect() {
        Aspect aspect = null;
        String a = preferences.getString(P_ASPECT);
        aspect = a.length() == 0 ? Aspect.getDefault() : Aspect.getAspect(a);
        if (aspect == null) {
            GELog.debug("GEPreferencePage.getAspect: ", String.valueOf(a) + " returned null, use default aspect");
            aspect = Aspect.getDefault();
        }
        return aspect;
    }

    public static void setAspect(String aspectStr) {
        Map<String, Aspect> aspectMap = Aspect.getMap();
        if (aspectMap != null && aspectMap.size() > 0) {
            Aspect aspect = null;
            aspect = Aspect.getAspect(aspectStr);
            if (aspect == null) {
                GELog.debug(GEPreferencePage.class, "Invalid aspect ignored: " + aspectStr);
                return;
            }
        }
        preferences.setValue(P_ASPECT, aspectStr);
        GELog.debug(GEPreferencePage.class, "Aspect set: " + aspectStr);
    }

    public static boolean isBBOX() {
        if (preferences != null) {
            return preferences.getBoolean(P_BBOX);
        }
        return false;
    }

    public static boolean isDebug() {
        if (preferences != null) {
            return preferences.getBoolean(P_DEBUG);
        }
        return true;
    }

    public static boolean isTest() {
        if (preferences != null) {
            return preferences.getBoolean(P_TEST);
        }
        return true;
    }

    public static boolean isShowBorder() {
        if (preferences != null) {
            return preferences.getBoolean(P_SHOW_BORDER);
        }
        return true;
    }

    public static String display() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("STEM-GoogleEarth Preferences:\n");
        sb.append("P_METHOD: ");
        switch (GEPreferencePage.getMethod()) {
            case 1: {
                sb.append("M_LOG_ONLY ");
                break;
            }
            case 2: {
                sb.append("M_LOG_SERVLET ");
                break;
            }
            case 3: {
                sb.append("M_ASYNC_SERVLET ");
                break;
            }
            case 4: {
                sb.append("M_AUTO_LAUNCH ");
                break;
            }
            case 5: {
                sb.append("M_MANUAL_DISPLAY ");
                break;
            }
            default: {
                sb.append("Unknown ");
            }
        }
        sb.append("\n");
        sb.append("P_FOLDER: ");
        sb.append(String.valueOf(GEPreferencePage.getFolder()) + "\n");
        sb.append("P_SERVER_HOST: ");
        sb.append(String.valueOf(GEPreferencePage.getServerHost()) + "\n");
        sb.append("P_INTERNAL_SERVER: ");
        sb.append(String.valueOf(GEPreferencePage.isInternalServer()) + "\n");
        sb.append("P_AUTO_LAUNCH: ");
        sb.append(String.valueOf(GEPreferencePage.isAutoLaunch()) + "\n");
        sb.append("P_AUTO_LOGGING: ");
        sb.append(String.valueOf(GEPreferencePage.isAutoLogging()) + "\n");
        sb.append("P_WHICH_CYCLE: ");
        sb.append(String.valueOf(GEPreferencePage.getWhichCycle()) + "\n");
        sb.append("P_ASPECT: ");
        sb.append(String.valueOf(GEPreferencePage.getAspect().toString()) + "\n");
        sb.append("P_BBOX: ");
        sb.append(String.valueOf(GEPreferencePage.isBBOX()) + "\n");
        sb.append("P_DEBUG: ");
        sb.append(String.valueOf(GEPreferencePage.isDebug()) + "\n");
        sb.append("P_TEST: ");
        sb.append(String.valueOf(GEPreferencePage.isTest()) + "\n");
        sb.append("P_SHOW_BORDER: ");
        sb.append(String.valueOf(GEPreferencePage.isShowBorder()) + "\n");
        return sb.toString();
    }
}

