/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenCodeStyle implements Enumerator
{
    UNNECESSARY_ELSE(0, "UnnecessaryElse", "UnnecessaryElse"),
    SWITCH_MISSING_DEFAULT_CASE(1, "SwitchMissingDefaultCase", "SwitchMissingDefaultCase"),
    UNNECESSARY_ASSIGNMENT_BEFORE_RETURN(2, "UnnecessaryAssignmentBeforeReturn", "UnnecessaryAssignmentBeforeReturn"),
    UNNECESSARY_DEPRECATED_METHOD(3, "UnnecessaryDeprecatedMethod", "UnnecessaryDeprecatedMethod");

    public static final int UNNECESSARY_ELSE_VALUE = 0;
    public static final int SWITCH_MISSING_DEFAULT_CASE_VALUE = 1;
    public static final int UNNECESSARY_ASSIGNMENT_BEFORE_RETURN_VALUE = 2;
    public static final int UNNECESSARY_DEPRECATED_METHOD_VALUE = 3;
    private static final GenCodeStyle[] VALUES_ARRAY;
    public static final List<GenCodeStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenCodeStyle[]{UNNECESSARY_ELSE, SWITCH_MISSING_DEFAULT_CASE, UNNECESSARY_ASSIGNMENT_BEFORE_RETURN, UNNECESSARY_DEPRECATED_METHOD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenCodeStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenCodeStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenCodeStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenCodeStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenCodeStyle get(int value) {
        switch (value) {
            case 0: {
                return UNNECESSARY_ELSE;
            }
            case 1: {
                return SWITCH_MISSING_DEFAULT_CASE;
            }
            case 2: {
                return UNNECESSARY_ASSIGNMENT_BEFORE_RETURN;
            }
            case 3: {
                return UNNECESSARY_DEPRECATED_METHOD;
            }
        }
        return null;
    }

    private GenCodeStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

